/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import io.druid.java.util.common.guava.LazySequence;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.SequenceWrapper;
import io.druid.java.util.common.guava.Sequences;
import io.druid.java.util.emitter.service.ServiceEmitter;
import io.druid.query.Query;
import io.druid.query.QueryMetrics;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryToolChest;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.ObjLongConsumer;

public class MetricsEmittingQueryRunner<T>
implements QueryRunner<T> {
    private final ServiceEmitter emitter;
    private final QueryToolChest<T, ? extends Query<T>> queryToolChest;
    private final QueryRunner<T> queryRunner;
    private final long creationTimeNs;
    private final ObjLongConsumer<? super QueryMetrics<?>> reportMetric;
    private final Consumer<QueryMetrics<?>> applyCustomDimensions;

    private MetricsEmittingQueryRunner(ServiceEmitter emitter, QueryToolChest<T, ? extends Query<T>> queryToolChest, QueryRunner<T> queryRunner, long creationTimeNs, ObjLongConsumer<? super QueryMetrics<?>> reportMetric, Consumer<QueryMetrics<?>> applyCustomDimensions) {
        this.emitter = emitter;
        this.queryToolChest = queryToolChest;
        this.queryRunner = queryRunner;
        this.creationTimeNs = creationTimeNs;
        this.reportMetric = reportMetric;
        this.applyCustomDimensions = applyCustomDimensions;
    }

    public MetricsEmittingQueryRunner(ServiceEmitter emitter, QueryToolChest<T, ? extends Query<T>> queryToolChest, QueryRunner<T> queryRunner, ObjLongConsumer<? super QueryMetrics<?>> reportMetric, Consumer<QueryMetrics<?>> applyCustomDimensions) {
        this(emitter, queryToolChest, queryRunner, -1L, reportMetric, applyCustomDimensions);
    }

    public MetricsEmittingQueryRunner<T> withWaitMeasuredFromNow() {
        return new MetricsEmittingQueryRunner<T>(this.emitter, this.queryToolChest, this.queryRunner, System.nanoTime(), this.reportMetric, this.applyCustomDimensions);
    }

    @Override
    public Sequence<T> run(QueryPlus<T> queryPlus, Map<String, Object> responseContext) {
        QueryPlus<T> queryWithMetrics = queryPlus.withQueryMetrics(this.queryToolChest);
        final QueryMetrics<?> queryMetrics = queryWithMetrics.getQueryMetrics();
        this.applyCustomDimensions.accept(queryMetrics);
        return Sequences.wrap((Sequence)new LazySequence(() -> this.queryRunner.run(queryWithMetrics, responseContext)), (SequenceWrapper)new SequenceWrapper(){
            private long startTimeNs;

            public void before() {
                this.startTimeNs = System.nanoTime();
            }

            public void after(boolean isDone, Throwable thrown) {
                if (thrown != null) {
                    queryMetrics.status("failed");
                } else if (!isDone) {
                    queryMetrics.status("short");
                }
                long timeTakenNs = System.nanoTime() - this.startTimeNs;
                MetricsEmittingQueryRunner.this.reportMetric.accept(queryMetrics, timeTakenNs);
                if (MetricsEmittingQueryRunner.this.creationTimeNs > 0L) {
                    queryMetrics.reportWaitTime(this.startTimeNs - MetricsEmittingQueryRunner.this.creationTimeNs);
                }
                queryMetrics.emit(MetricsEmittingQueryRunner.this.emitter);
            }
        });
    }
}

