/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.emitter.service.ServiceEmitter;
import io.druid.query.CPUTimeMetricQueryRunner;
import io.druid.query.FinalizeResultsQueryRunner;
import io.druid.query.PostProcessingOperator;
import io.druid.query.Query;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryToolChest;
import io.druid.query.UnionQueryRunner;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class FluentQueryRunnerBuilder<T> {
    final QueryToolChest<T, Query<T>> toolChest;

    public FluentQueryRunner create(QueryRunner<T> baseRunner) {
        return new FluentQueryRunner(baseRunner);
    }

    public FluentQueryRunnerBuilder(QueryToolChest<T, Query<T>> toolChest) {
        this.toolChest = toolChest;
    }

    public class FluentQueryRunner
    implements QueryRunner<T> {
        private QueryRunner<T> baseRunner;

        public FluentQueryRunner(QueryRunner<T> runner) {
            this.baseRunner = runner;
        }

        @Override
        public Sequence<T> run(QueryPlus<T> queryPlus, Map<String, Object> responseContext) {
            return this.baseRunner.run(queryPlus, responseContext);
        }

        public FluentQueryRunner from(QueryRunner<T> runner) {
            return new FluentQueryRunner(runner);
        }

        public FluentQueryRunner applyPostMergeDecoration() {
            return this.from(new FinalizeResultsQueryRunner(FluentQueryRunnerBuilder.this.toolChest.postMergeQueryDecoration(this.baseRunner), FluentQueryRunnerBuilder.this.toolChest));
        }

        public FluentQueryRunner applyPreMergeDecoration() {
            return this.from(new UnionQueryRunner(FluentQueryRunnerBuilder.this.toolChest.preMergeQueryDecoration(this.baseRunner)));
        }

        public FluentQueryRunner emitCPUTimeMetric(ServiceEmitter emitter) {
            return this.from(CPUTimeMetricQueryRunner.safeBuild(this.baseRunner, FluentQueryRunnerBuilder.this.toolChest, emitter, new AtomicLong(0L), true));
        }

        public FluentQueryRunner postProcess(PostProcessingOperator<T> postProcessing) {
            return this.from(postProcessing != null ? postProcessing.postProcess(this.baseRunner) : this.baseRunner);
        }

        public FluentQueryRunner mergeResults() {
            return this.from(FluentQueryRunnerBuilder.this.toolChest.mergeResults(this.baseRunner));
        }
    }
}

