/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.query.BySegmentResultValue;
import io.druid.query.BySegmentResultValueClass;
import io.druid.query.Query;
import io.druid.query.QueryContexts;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryToolChest;
import io.druid.query.Result;
import io.druid.query.aggregation.MetricManipulationFn;
import io.druid.query.aggregation.MetricManipulatorFns;
import java.util.Map;

public class FinalizeResultsQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunner<T> baseRunner;
    private final QueryToolChest<T, Query<T>> toolChest;

    public FinalizeResultsQueryRunner(QueryRunner<T> baseRunner, QueryToolChest<T, Query<T>> toolChest) {
        this.baseRunner = baseRunner;
        this.toolChest = toolChest;
    }

    @Override
    public Sequence<T> run(QueryPlus<T> queryPlus, Map<String, Object> responseContext) {
        MetricManipulationFn metricManipulationFn;
        Query<T> queryToRun;
        final Query<T> query = queryPlus.getQuery();
        boolean isBySegment = QueryContexts.isBySegment(query);
        boolean shouldFinalize = QueryContexts.isFinalize(query, true);
        if (shouldFinalize) {
            queryToRun = query.withOverriddenContext((Map<String, Object>)ImmutableMap.of((Object)"finalize", (Object)false));
            metricManipulationFn = MetricManipulatorFns.finalizing();
        } else {
            queryToRun = query;
            metricManipulationFn = MetricManipulatorFns.identity();
        }
        Function finalizerFn = isBySegment ? new Function<T, T>(){
            final Function<T, T> baseFinalizer;
            {
                this.baseFinalizer = FinalizeResultsQueryRunner.this.toolChest.makePostComputeManipulatorFn(query, metricManipulationFn);
            }

            public T apply(T input) {
                Result result = (Result)input;
                if (input == null) {
                    throw new ISE("Cannot have a null result!", new Object[0]);
                }
                BySegmentResultValue resultsClass = (BySegmentResultValue)result.getValue();
                return new Result(result.getTimestamp(), new BySegmentResultValueClass(Lists.transform(resultsClass.getResults(), this.baseFinalizer), resultsClass.getSegmentId(), resultsClass.getInterval()));
            }
        } : this.toolChest.makePostComputeManipulatorFn(query, metricManipulationFn);
        return Sequences.map(this.baseRunner.run(queryPlus.withQuery(queryToRun), responseContext), (Function)finalizerFn);
    }
}

