/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import io.druid.java.util.common.concurrent.ExecutorServiceConfig;
import io.druid.segment.column.ColumnConfig;
import org.skife.config.Config;

public abstract class DruidProcessingConfig
extends ExecutorServiceConfig
implements ColumnConfig {
    public static final int DEFAULT_NUM_MERGE_BUFFERS = -1;

    @Config(value={"druid.computation.buffer.size", "${base_path}.buffer.sizeBytes"})
    public int intermediateComputeSizeBytes() {
        return 0x40000000;
    }

    @Config(value={"druid.computation.buffer.poolCacheMaxCount", "${base_path}.buffer.poolCacheMaxCount"})
    public int poolCacheMaxCount() {
        return Integer.MAX_VALUE;
    }

    @Config(value={"${base_path}.numThreads"})
    public int getNumThreadsConfigured() {
        return -1;
    }

    public int getNumMergeBuffers() {
        int numMergeBuffersConfigured = this.getNumMergeBuffersConfigured();
        if (numMergeBuffersConfigured != -1) {
            return numMergeBuffersConfigured;
        }
        return Math.max(2, this.getNumThreads() / 4);
    }

    @Config(value={"${base_path}.numMergeBuffers"})
    public int getNumMergeBuffersConfigured() {
        return -1;
    }

    @Override
    @Config(value={"${base_path}.columnCache.sizeBytes"})
    public int columnCacheSizeBytes() {
        return 0;
    }

    @Config(value={"${base_path}.fifo"})
    public boolean isFifo() {
        return false;
    }

    @Config(value={"${base_path}.tmpDir"})
    public String getTmpDir() {
        return System.getProperty("java.io.tmpdir");
    }
}

