/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.druid.query.GenericQueryMetricsFactory;
import io.druid.query.Query;
import io.druid.query.QueryMetrics;
import io.druid.query.QueryToolChest;
import io.druid.query.aggregation.AggregatorFactory;
import java.util.List;

public class DruidMetrics {
    public static final String DATASOURCE = "dataSource";
    public static final String TYPE = "type";
    public static final String INTERVAL = "interval";
    public static final String ID = "id";
    public static final String TASK_ID = "taskId";
    public static final String STATUS = "status";
    public static final String TASK_TYPE = "taskType";
    public static final String TASK_STATUS = "taskStatus";
    public static final String SERVER = "server";
    public static final String TIER = "tier";

    public static int findNumComplexAggs(List<AggregatorFactory> aggs) {
        int retVal = 0;
        for (AggregatorFactory agg : aggs) {
            if (agg.getTypeName().equals("float") || agg.getTypeName().equals("long") || agg.getTypeName().equals("double")) continue;
            ++retVal;
        }
        return retVal;
    }

    public static <T> QueryMetrics<?> makeRequestMetrics(GenericQueryMetricsFactory queryMetricsFactory, QueryToolChest<T, Query<T>> toolChest, Query<T> query, String remoteAddr) throws JsonProcessingException {
        QueryMetrics<Query<Object>> queryMetrics = toolChest != null ? toolChest.makeMetrics(query) : queryMetricsFactory.makeMetrics(query);
        queryMetrics.context(query);
        queryMetrics.remoteAddress(remoteAddr);
        return queryMetrics;
    }
}

