/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.druid.collections.bitmap.BitmapFactory;
import io.druid.java.util.emitter.service.ServiceEmitter;
import io.druid.java.util.emitter.service.ServiceMetricEvent;
import io.druid.query.BitmapResultFactory;
import io.druid.query.DataSourceUtil;
import io.druid.query.DefaultBitmapResultFactory;
import io.druid.query.Query;
import io.druid.query.QueryMetrics;
import io.druid.query.filter.Filter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.joda.time.Interval;
import org.joda.time.base.AbstractInterval;

public class DefaultQueryMetrics<QueryType extends Query<?>>
implements QueryMetrics<QueryType> {
    protected final ObjectMapper jsonMapper;
    protected final ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder();
    protected final Map<String, Number> metrics = new HashMap<String, Number>();
    protected Thread ownerThread = Thread.currentThread();

    public DefaultQueryMetrics(ObjectMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    protected void checkModifiedFromOwnerThread() {
        if (Thread.currentThread() != this.ownerThread) {
            throw new IllegalStateException("DefaultQueryMetrics must not be modified from multiple threads. If it is needed to gather dimension or metric information from multiple threads or from an async thread, this information should explicitly be passed between threads (e. g. using Futures), or this DefaultQueryMetrics's ownerThread should be reassigned explicitly");
        }
    }

    protected void setDimension(String dimension, String value) {
        this.checkModifiedFromOwnerThread();
        this.builder.setDimension(dimension, value);
    }

    @Override
    public void query(QueryType query) {
        this.dataSource(query);
        this.queryType(query);
        this.interval(query);
        this.hasFilters(query);
        this.duration(query);
        this.queryId(query);
    }

    @Override
    public void dataSource(QueryType query) {
        this.setDimension("dataSource", DataSourceUtil.getMetricName(query.getDataSource()));
    }

    @Override
    public void queryType(QueryType query) {
        this.setDimension("type", query.getType());
    }

    @Override
    public void interval(QueryType query) {
        this.checkModifiedFromOwnerThread();
        this.builder.setDimension("interval", (String[])query.getIntervals().stream().map(AbstractInterval::toString).toArray(String[]::new));
    }

    @Override
    public void hasFilters(QueryType query) {
        this.setDimension("hasFilters", String.valueOf(query.hasFilters()));
    }

    @Override
    public void duration(QueryType query) {
        this.setDimension("duration", query.getDuration().toString());
    }

    @Override
    public void queryId(QueryType query) {
        this.setDimension("id", Strings.nullToEmpty((String)query.getId()));
    }

    @Override
    public void context(QueryType query) {
        try {
            this.setDimension("context", this.jsonMapper.writeValueAsString(query.getContext() == null ? ImmutableMap.of() : query.getContext()));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void server(String host) {
        this.setDimension("server", host);
    }

    @Override
    public void remoteAddress(String remoteAddress) {
        this.setDimension("remoteAddress", remoteAddress);
    }

    @Override
    public void status(String status) {
        this.setDimension("status", status);
    }

    @Override
    public void success(boolean success) {
        this.setDimension("success", String.valueOf(success));
    }

    @Override
    public void segment(String segmentIdentifier) {
        this.setDimension("segment", segmentIdentifier);
    }

    @Override
    public void chunkInterval(Interval interval) {
        this.setDimension("chunkInterval", interval.toString());
    }

    @Override
    public void preFilters(List<Filter> preFilters) {
    }

    @Override
    public void postFilters(List<Filter> postFilters) {
    }

    @Override
    public void identity(String identity) {
    }

    @Override
    public BitmapResultFactory<?> makeBitmapResultFactory(BitmapFactory factory) {
        return new DefaultBitmapResultFactory(factory);
    }

    @Override
    public QueryMetrics<QueryType> reportQueryTime(long timeNs) {
        return this.reportMillisTimeMetric("query/time", timeNs);
    }

    @Override
    public QueryMetrics<QueryType> reportQueryBytes(long byteCount) {
        return this.reportMetric("query/bytes", byteCount);
    }

    @Override
    public QueryMetrics<QueryType> reportWaitTime(long timeNs) {
        return this.reportMillisTimeMetric("query/wait/time", timeNs);
    }

    @Override
    public QueryMetrics<QueryType> reportSegmentTime(long timeNs) {
        return this.reportMillisTimeMetric("query/segment/time", timeNs);
    }

    @Override
    public QueryMetrics<QueryType> reportSegmentAndCacheTime(long timeNs) {
        return this.reportMillisTimeMetric("query/segmentAndCache/time", timeNs);
    }

    @Override
    public QueryMetrics<QueryType> reportIntervalChunkTime(long timeNs) {
        return this.reportMillisTimeMetric("query/intervalChunk/time", timeNs);
    }

    @Override
    public QueryMetrics<QueryType> reportCpuTime(long timeNs) {
        return this.reportMetric("query/cpu/time", TimeUnit.NANOSECONDS.toMicros(timeNs));
    }

    @Override
    public QueryMetrics<QueryType> reportNodeTimeToFirstByte(long timeNs) {
        return this.reportMillisTimeMetric("query/node/ttfb", timeNs);
    }

    @Override
    public QueryMetrics<QueryType> reportNodeTime(long timeNs) {
        return this.reportMillisTimeMetric("query/node/time", timeNs);
    }

    private QueryMetrics<QueryType> reportMillisTimeMetric(String metricName, long timeNs) {
        return this.reportMetric(metricName, TimeUnit.NANOSECONDS.toMillis(timeNs));
    }

    protected QueryMetrics<QueryType> reportMetric(String metricName, Number value) {
        this.checkModifiedFromOwnerThread();
        this.metrics.put(metricName, value);
        return this;
    }

    @Override
    public QueryMetrics<QueryType> reportNodeBytes(long byteCount) {
        return this.reportMetric("query/node/bytes", byteCount);
    }

    @Override
    public QueryMetrics<QueryType> reportBitmapConstructionTime(long timeNs) {
        return this;
    }

    @Override
    public QueryMetrics<QueryType> reportSegmentRows(long numRows) {
        return this;
    }

    @Override
    public QueryMetrics<QueryType> reportPreFilteredRows(long numRows) {
        return this;
    }

    @Override
    public void emit(ServiceEmitter emitter) {
        this.checkModifiedFromOwnerThread();
        for (Map.Entry<String, Number> metric : this.metrics.entrySet()) {
            emitter.emit(this.builder.build(metric.getKey(), metric.getValue()));
        }
        this.metrics.clear();
    }
}

