/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import io.druid.guice.LazySingleton;
import io.druid.guice.annotations.Json;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.DefaultQueryMetrics;
import io.druid.query.GenericQueryMetricsFactory;
import io.druid.query.Query;
import io.druid.query.QueryMetrics;

@LazySingleton
public class DefaultGenericQueryMetricsFactory
implements GenericQueryMetricsFactory {
    private static final GenericQueryMetricsFactory INSTANCE = new DefaultGenericQueryMetricsFactory(new DefaultObjectMapper());
    private final ObjectMapper jsonMapper;

    @VisibleForTesting
    public static GenericQueryMetricsFactory instance() {
        return INSTANCE;
    }

    @Inject
    public DefaultGenericQueryMetricsFactory(@Json ObjectMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    @Override
    public QueryMetrics<Query<?>> makeMetrics(Query<?> query) {
        DefaultQueryMetrics queryMetrics = new DefaultQueryMetrics(this.jsonMapper);
        queryMetrics.query(query);
        return queryMetrics;
    }
}

