/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.guava.BaseSequence;
import io.druid.java.util.common.guava.MergeIterable;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.java.util.common.logger.Logger;
import io.druid.query.AbstractPrioritizedCallable;
import io.druid.query.Query;
import io.druid.query.QueryContexts;
import io.druid.query.QueryInterruptedException;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryWatcher;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ChainedExecutionQueryRunner<T>
implements QueryRunner<T> {
    private static final Logger log = new Logger(ChainedExecutionQueryRunner.class);
    private final Iterable<QueryRunner<T>> queryables;
    private final ListeningExecutorService exec;
    private final QueryWatcher queryWatcher;

    public ChainedExecutionQueryRunner(ExecutorService exec, QueryWatcher queryWatcher, QueryRunner<T> ... queryables) {
        this(exec, queryWatcher, Arrays.asList(queryables));
    }

    public ChainedExecutionQueryRunner(ExecutorService exec, QueryWatcher queryWatcher, Iterable<QueryRunner<T>> queryables) {
        this.exec = MoreExecutors.listeningDecorator((ExecutorService)exec);
        this.queryables = Iterables.unmodifiableIterable(queryables);
        this.queryWatcher = queryWatcher;
    }

    @Override
    public Sequence<T> run(QueryPlus<T> queryPlus, final Map<String, Object> responseContext) {
        final Query<T> query = queryPlus.getQuery();
        final int priority = QueryContexts.getPriority(query);
        final Ordering<T> ordering = query.getResultOrdering();
        final QueryPlus<T> threadSafeQueryPlus = queryPlus.withoutThreadUnsafeState();
        return new BaseSequence(new BaseSequence.IteratorMaker<T, Iterator<T>>(){

            public Iterator<T> make() {
                ListenableFuture futures = Futures.allAsList((Iterable)Lists.newArrayList((Iterable)Iterables.transform((Iterable)ChainedExecutionQueryRunner.this.queryables, (Function)new Function<QueryRunner<T>, ListenableFuture<Iterable<T>>>(){

                    public ListenableFuture<Iterable<T>> apply(final QueryRunner<T> input) {
                        if (input == null) {
                            throw new ISE("Null queryRunner! Looks to be some segment unmapping action happening", new Object[0]);
                        }
                        return ChainedExecutionQueryRunner.this.exec.submit((Callable)new AbstractPrioritizedCallable<Iterable<T>>(priority){

                            @Override
                            public Iterable<T> call() throws Exception {
                                try {
                                    Sequence result = input.run(threadSafeQueryPlus, responseContext);
                                    if (result == null) {
                                        throw new ISE("Got a null result! Segments are missing!", new Object[0]);
                                    }
                                    List retVal = Sequences.toList(result, (List)Lists.newArrayList());
                                    if (retVal == null) {
                                        throw new ISE("Got a null list of results! WTF?!", new Object[0]);
                                    }
                                    return retVal;
                                }
                                catch (QueryInterruptedException e) {
                                    throw Throwables.propagate((Throwable)e);
                                }
                                catch (Exception e) {
                                    log.error((Throwable)e, "Exception with one of the sequences!", new Object[0]);
                                    throw Throwables.propagate((Throwable)e);
                                }
                            }
                        });
                    }
                })));
                ChainedExecutionQueryRunner.this.queryWatcher.registerQuery(query, futures);
                try {
                    return new MergeIterable((Comparator)ordering.nullsFirst(), QueryContexts.hasTimeout(query) ? (Iterable)futures.get(QueryContexts.getTimeout(query), TimeUnit.MILLISECONDS) : (Iterable)futures.get()).iterator();
                }
                catch (InterruptedException e) {
                    log.warn((Throwable)e, "Query interrupted, cancelling pending results, query id [%s]", new Object[]{query.getId()});
                    futures.cancel(true);
                    throw new QueryInterruptedException(e);
                }
                catch (CancellationException e) {
                    throw new QueryInterruptedException(e);
                }
                catch (TimeoutException e) {
                    log.info("Query timeout, cancelling pending results for query id [%s]", new Object[]{query.getId()});
                    futures.cancel(true);
                    throw new QueryInterruptedException(e);
                }
                catch (ExecutionException e) {
                    throw Throwables.propagate((Throwable)e.getCause());
                }
            }

            public void cleanup(Iterator<T> tIterator) {
            }
        });
    }
}

