/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.base.Supplier;
import io.druid.common.utils.VMUtils;
import io.druid.java.util.common.ISE;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.SequenceWrapper;
import io.druid.java.util.common.guava.Sequences;
import io.druid.java.util.emitter.service.ServiceEmitter;
import io.druid.query.Query;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryToolChest;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class CPUTimeMetricQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunner<T> delegate;
    private final QueryToolChest<T, ? extends Query<T>> queryToolChest;
    private final ServiceEmitter emitter;
    private final AtomicLong cpuTimeAccumulator;
    private final boolean report;

    private CPUTimeMetricQueryRunner(QueryRunner<T> delegate, QueryToolChest<T, ? extends Query<T>> queryToolChest, ServiceEmitter emitter, AtomicLong cpuTimeAccumulator, boolean report) {
        if (!VMUtils.isThreadCpuTimeEnabled()) {
            throw new ISE("Cpu time must enabled", new Object[0]);
        }
        this.delegate = delegate;
        this.queryToolChest = queryToolChest;
        this.emitter = emitter;
        this.cpuTimeAccumulator = cpuTimeAccumulator == null ? new AtomicLong(0L) : cpuTimeAccumulator;
        this.report = report;
    }

    @Override
    public Sequence<T> run(QueryPlus<T> queryPlus, Map<String, Object> responseContext) {
        final QueryPlus<T> queryWithMetrics = queryPlus.withQueryMetrics(this.queryToolChest);
        Sequence<T> baseSequence = this.delegate.run(queryWithMetrics, responseContext);
        return Sequences.wrap(baseSequence, (SequenceWrapper)new SequenceWrapper(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public <RetType> RetType wrap(Supplier<RetType> sequenceProcessing) {
                long start = VMUtils.getCurrentThreadCpuTime();
                try {
                    Object object = sequenceProcessing.get();
                    return (RetType)object;
                }
                finally {
                    CPUTimeMetricQueryRunner.this.cpuTimeAccumulator.addAndGet(VMUtils.getCurrentThreadCpuTime() - start);
                }
            }

            public void after(boolean isDone, Throwable thrown) throws Exception {
                long cpuTimeNs;
                if (CPUTimeMetricQueryRunner.this.report && (cpuTimeNs = CPUTimeMetricQueryRunner.this.cpuTimeAccumulator.get()) > 0L) {
                    queryWithMetrics.getQueryMetrics().reportCpuTime(cpuTimeNs).emit(CPUTimeMetricQueryRunner.this.emitter);
                }
            }
        });
    }

    public static <T> QueryRunner<T> safeBuild(QueryRunner<T> delegate, QueryToolChest<T, ? extends Query<T>> queryToolChest, ServiceEmitter emitter, AtomicLong accumulator, boolean report) {
        if (!VMUtils.isThreadCpuTimeEnabled()) {
            return delegate;
        }
        return new CPUTimeMetricQueryRunner<T>(delegate, queryToolChest, emitter, accumulator, report);
    }
}

