/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.collect.Lists;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.query.BySegmentResultValueClass;
import io.druid.query.QueryContexts;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.Result;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class BySegmentQueryRunner<T>
implements QueryRunner<T> {
    private final String segmentIdentifier;
    private final DateTime timestamp;
    private final QueryRunner<T> base;

    public BySegmentQueryRunner(String segmentIdentifier, DateTime timestamp, QueryRunner<T> base) {
        this.segmentIdentifier = segmentIdentifier;
        this.timestamp = timestamp;
        this.base = base;
    }

    @Override
    public Sequence<T> run(QueryPlus<T> queryPlus, Map<String, Object> responseContext) {
        if (QueryContexts.isBySegment(queryPlus.getQuery())) {
            Sequence<T> baseSequence = this.base.run(queryPlus, responseContext);
            List results = Sequences.toList(baseSequence, (List)Lists.newArrayList());
            return Sequences.simple(Collections.singletonList(new Result(this.timestamp, new BySegmentResultValueClass(results, this.segmentIdentifier, queryPlus.getQuery().getIntervals().get(0)))));
        }
        return this.base.run(queryPlus, responseContext);
    }
}

