/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.druid.java.util.common.guava.LazySequence;
import io.druid.java.util.common.guava.Sequence;
import io.druid.query.AbstractPrioritizedCallable;
import io.druid.query.Query;
import io.druid.query.QueryContexts;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryWatcher;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AsyncQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunner<T> baseRunner;
    private final ListeningExecutorService executor;
    private final QueryWatcher queryWatcher;

    public AsyncQueryRunner(QueryRunner<T> baseRunner, ExecutorService executor, QueryWatcher queryWatcher) {
        this.baseRunner = baseRunner;
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)executor);
        this.queryWatcher = queryWatcher;
    }

    @Override
    public Sequence<T> run(QueryPlus<T> queryPlus, final Map<String, Object> responseContext) {
        final Query<T> query = queryPlus.getQuery();
        int priority = QueryContexts.getPriority(query);
        final QueryPlus<T> threadSafeQueryPlus = queryPlus.withoutThreadUnsafeState();
        final ListenableFuture future = this.executor.submit((Callable)new AbstractPrioritizedCallable<Sequence<T>>(priority){

            @Override
            public Sequence<T> call() throws Exception {
                return AsyncQueryRunner.this.baseRunner.run(threadSafeQueryPlus, responseContext);
            }
        });
        this.queryWatcher.registerQuery(query, future);
        return new LazySequence(new Supplier<Sequence<T>>(){

            public Sequence<T> get() {
                try {
                    if (QueryContexts.hasTimeout(query)) {
                        return (Sequence)future.get(QueryContexts.getTimeout(query), TimeUnit.MILLISECONDS);
                    }
                    return (Sequence)future.get();
                }
                catch (InterruptedException | ExecutionException | TimeoutException ex) {
                    throw Throwables.propagate((Throwable)ex);
                }
            }
        });
    }
}

