/*
 * Decompiled with CFR 0.152.
 */
package io.druid.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.google.common.base.Throwables;
import io.druid.jackson.JodaStuff;
import io.druid.java.util.common.guava.Accumulator;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Yielder;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.TimeZone;
import org.joda.time.DateTimeZone;

public class DruidDefaultSerializersModule
extends SimpleModule {
    public DruidDefaultSerializersModule() {
        super("Druid default serializers");
        JodaStuff.register(this);
        this.addDeserializer(DateTimeZone.class, (JsonDeserializer)new JsonDeserializer<DateTimeZone>(){

            public DateTimeZone deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                String tzId = jp.getText();
                try {
                    return DateTimeZone.forID((String)tzId);
                }
                catch (IllegalArgumentException e) {
                    return DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(tzId));
                }
            }
        });
        this.addSerializer(DateTimeZone.class, (JsonSerializer)new JsonSerializer<DateTimeZone>(){

            public void serialize(DateTimeZone dateTimeZone, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
                jsonGenerator.writeString(dateTimeZone.getID());
            }
        });
        this.addSerializer(Sequence.class, (JsonSerializer)new JsonSerializer<Sequence>(){

            public void serialize(Sequence value, final JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
                jgen.writeStartArray();
                value.accumulate(null, (Accumulator)new Accumulator<Object, Object>(){

                    public Object accumulate(Object o, Object o1) {
                        try {
                            jgen.writeObject(o1);
                        }
                        catch (IOException e) {
                            throw Throwables.propagate((Throwable)e);
                        }
                        return null;
                    }
                });
                jgen.writeEndArray();
            }
        });
        this.addSerializer(Yielder.class, (JsonSerializer)new JsonSerializer<Yielder>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serialize(Yielder yielder, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
                try {
                    jgen.writeStartArray();
                    while (!yielder.isDone()) {
                        Object o = yielder.get();
                        jgen.writeObject(o);
                        yielder = yielder.next(null);
                    }
                    jgen.writeEndArray();
                }
                finally {
                    yielder.close();
                }
            }
        });
        this.addSerializer(ByteOrder.class, (JsonSerializer)ToStringSerializer.instance);
        this.addDeserializer(ByteOrder.class, (JsonDeserializer)new JsonDeserializer<ByteOrder>(){

            public ByteOrder deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                if (ByteOrder.BIG_ENDIAN.toString().equals(jp.getText())) {
                    return ByteOrder.BIG_ENDIAN;
                }
                return ByteOrder.LITTLE_ENDIAN;
            }
        });
    }
}

