/*
 * Decompiled with CFR 0.152.
 */
package io.druid.collections.bitmap;

import com.google.common.base.Throwables;
import io.druid.collections.bitmap.ImmutableBitmap;
import io.druid.collections.bitmap.MutableBitmap;
import io.druid.collections.bitmap.WrappedImmutableRoaringBitmap;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.roaringbitmap.IntIterator;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class WrappedRoaringBitmap
implements MutableBitmap {
    private final boolean compressRunOnSerialization;
    private MutableRoaringBitmap bitmap = new MutableRoaringBitmap();

    public WrappedRoaringBitmap() {
        this(false);
    }

    public WrappedRoaringBitmap(boolean compressRunOnSerialization) {
        this.compressRunOnSerialization = compressRunOnSerialization;
    }

    ImmutableBitmap toImmutableBitmap() {
        MutableRoaringBitmap mrb = this.bitmap.clone();
        if (this.compressRunOnSerialization) {
            mrb.runOptimize();
        }
        return new WrappedImmutableRoaringBitmap((ImmutableRoaringBitmap)mrb);
    }

    @Override
    public byte[] toBytes() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (this.compressRunOnSerialization) {
                this.bitmap.runOptimize();
            }
            this.bitmap.serialize((DataOutput)new DataOutputStream(out));
            return out.toByteArray();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void clear() {
        this.bitmap.clear();
    }

    @Override
    public void or(MutableBitmap mutableBitmap) {
        WrappedRoaringBitmap other = (WrappedRoaringBitmap)mutableBitmap;
        MutableRoaringBitmap unwrappedOtherBitmap = other.bitmap;
        this.bitmap.or((ImmutableRoaringBitmap)unwrappedOtherBitmap);
    }

    @Override
    public int getSizeInBytes() {
        if (this.compressRunOnSerialization) {
            this.bitmap.runOptimize();
        }
        return this.bitmap.serializedSizeInBytes();
    }

    @Override
    public void add(int entry) {
        this.bitmap.add(entry);
    }

    @Override
    public int size() {
        return this.bitmap.getCardinality();
    }

    public void serialize(ByteBuffer buffer) {
        if (this.compressRunOnSerialization) {
            this.bitmap.runOptimize();
        }
        try {
            this.bitmap.serialize((DataOutput)new DataOutputStream(new OutputStream(){
                ByteBuffer mBB;

                OutputStream init(ByteBuffer mbb) {
                    this.mBB = mbb;
                    return this;
                }

                @Override
                public void close() {
                }

                @Override
                public void flush() {
                }

                @Override
                public void write(int b) {
                    this.mBB.put((byte)b);
                }

                @Override
                public void write(byte[] b) {
                    this.mBB.put(b);
                }

                @Override
                public void write(byte[] b, int off, int l) {
                    this.mBB.put(b, off, l);
                }
            }.init(buffer)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.bitmap.toString();
    }

    @Override
    public void remove(int entry) {
        this.bitmap.remove(entry);
    }

    @Override
    public IntIterator iterator() {
        return this.bitmap.getIntIterator();
    }

    @Override
    public boolean isEmpty() {
        return this.bitmap.isEmpty();
    }

    @Override
    public ImmutableBitmap intersection(ImmutableBitmap otherBitmap) {
        WrappedRoaringBitmap other = (WrappedRoaringBitmap)otherBitmap;
        MutableRoaringBitmap unwrappedOtherBitmap = other.bitmap;
        return new WrappedImmutableRoaringBitmap((ImmutableRoaringBitmap)MutableRoaringBitmap.and((MutableRoaringBitmap)this.bitmap, (MutableRoaringBitmap)unwrappedOtherBitmap));
    }

    @Override
    public boolean get(int value) {
        return this.bitmap.contains(value);
    }
}

