/*
 * Decompiled with CFR 0.152.
 */
package io.druid.collections.bitmap;

import com.google.common.base.Throwables;
import io.druid.collections.bitmap.ImmutableBitmap;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import org.roaringbitmap.IntIterator;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;

public class WrappedImmutableRoaringBitmap
implements ImmutableBitmap {
    private final ImmutableRoaringBitmap bitmap;

    protected WrappedImmutableRoaringBitmap(ByteBuffer byteBuffer) {
        this.bitmap = new ImmutableRoaringBitmap(byteBuffer);
    }

    public WrappedImmutableRoaringBitmap(ImmutableRoaringBitmap immutableRoaringBitmap) {
        this.bitmap = immutableRoaringBitmap;
    }

    public ImmutableRoaringBitmap getBitmap() {
        return this.bitmap;
    }

    @Override
    public byte[] toBytes() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.bitmap.serialize((DataOutput)new DataOutputStream(out));
            return out.toByteArray();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.bitmap.toString();
    }

    @Override
    public IntIterator iterator() {
        return this.bitmap.getIntIterator();
    }

    @Override
    public int size() {
        return this.bitmap.getCardinality();
    }

    @Override
    public boolean isEmpty() {
        return this.bitmap.isEmpty();
    }

    @Override
    public boolean get(int value) {
        return this.bitmap.contains(value);
    }

    @Override
    public ImmutableBitmap intersection(ImmutableBitmap otherBitmap) {
        WrappedImmutableRoaringBitmap other = (WrappedImmutableRoaringBitmap)otherBitmap;
        ImmutableRoaringBitmap unwrappedOtherBitmap = other.bitmap;
        return new WrappedImmutableRoaringBitmap((ImmutableRoaringBitmap)ImmutableRoaringBitmap.and((ImmutableRoaringBitmap)this.bitmap, (ImmutableRoaringBitmap)unwrappedOtherBitmap));
    }
}

