/*
 * Decompiled with CFR 0.152.
 */
package io.druid.collections.bitmap;

import io.druid.collections.bitmap.ImmutableBitmap;
import io.druid.extendedset.intset.ImmutableConciseSet;
import java.nio.ByteBuffer;
import org.roaringbitmap.IntIterator;

public class WrappedImmutableConciseBitmap
implements ImmutableBitmap {
    private final ImmutableConciseSet bitmap;

    public WrappedImmutableConciseBitmap(ByteBuffer byteBuffer) {
        this.bitmap = new ImmutableConciseSet(byteBuffer);
    }

    public WrappedImmutableConciseBitmap(ImmutableConciseSet immutableConciseSet) {
        this.bitmap = immutableConciseSet;
    }

    public ImmutableConciseSet getBitmap() {
        return this.bitmap;
    }

    @Override
    public boolean get(int value) {
        return this.bitmap.contains(value);
    }

    @Override
    public byte[] toBytes() {
        return this.bitmap.toBytes();
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.bitmap.toString();
    }

    @Override
    public IntIterator iterator() {
        return this.bitmap.iterator();
    }

    @Override
    public int size() {
        return this.bitmap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.bitmap.size() == 0;
    }

    @Override
    public ImmutableBitmap intersection(ImmutableBitmap otherBitmap) {
        WrappedImmutableConciseBitmap other = (WrappedImmutableConciseBitmap)otherBitmap;
        ImmutableConciseSet unwrappedOtherBitmap = other.bitmap;
        return new WrappedImmutableConciseBitmap(ImmutableConciseSet.intersection((ImmutableConciseSet[])new ImmutableConciseSet[]{this.bitmap, unwrappedOtherBitmap}));
    }
}

