/*
 * Decompiled with CFR 0.152.
 */
package io.druid.collections.bitmap;

import io.druid.collections.bitmap.BitmapFactory;
import io.druid.collections.bitmap.ImmutableBitmap;
import io.druid.collections.bitmap.MutableBitmap;
import io.druid.collections.bitmap.WrappedBitSetBitmap;
import io.druid.collections.bitmap.WrappedImmutableBitSetBitmap;
import java.nio.ByteBuffer;
import java.util.BitSet;

public class BitSetBitmapFactory
implements BitmapFactory {
    @Override
    public MutableBitmap makeEmptyMutableBitmap() {
        return new WrappedBitSetBitmap();
    }

    @Override
    public ImmutableBitmap makeEmptyImmutableBitmap() {
        return this.makeEmptyMutableBitmap();
    }

    @Override
    public ImmutableBitmap makeImmutableBitmap(MutableBitmap mutableBitmap) {
        return mutableBitmap;
    }

    @Override
    public ImmutableBitmap mapImmutableBitmap(ByteBuffer b) {
        return new WrappedBitSetBitmap(BitSet.valueOf(b.array()));
    }

    @Override
    public ImmutableBitmap union(Iterable<ImmutableBitmap> b) {
        WrappedImmutableBitSetBitmap newSet = null;
        for (ImmutableBitmap bm : b) {
            if (null == newSet) {
                newSet = new WrappedBitSetBitmap(((WrappedBitSetBitmap)bm).cloneBitSet());
                continue;
            }
            newSet.union(bm);
        }
        return newSet;
    }

    @Override
    public ImmutableBitmap intersection(Iterable<ImmutableBitmap> b) {
        WrappedImmutableBitSetBitmap newSet = null;
        for (ImmutableBitmap bm : b) {
            if (null == newSet) {
                newSet = new WrappedBitSetBitmap(((WrappedBitSetBitmap)bm).cloneBitSet());
                continue;
            }
            newSet.intersection(bm);
        }
        return newSet;
    }

    @Override
    public ImmutableBitmap complement(ImmutableBitmap b, int length) {
        return null;
    }
}

