/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.serde;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.druid.segment.TestHelper;
import io.druid.segment.data.ConciseBitmapSerdeFactory;
import io.druid.segment.data.RoaringBitmapSerdeFactory;
import io.druid.segment.serde.ColumnPartSerde;
import io.druid.segment.serde.DictionaryEncodedColumnPartSerde;
import java.nio.ByteOrder;
import org.junit.Assert;
import org.junit.Test;

public class DictionaryEncodedColumnPartSerdeTest {
    @Test
    public void testSerde() throws Exception {
        String json = "{\n \"type\": \"stringDictionary\",\n \"byteOrder\": \"BIG_ENDIAN\"\n}\n";
        ObjectMapper mapper = TestHelper.makeJsonMapper();
        DictionaryEncodedColumnPartSerde serde = (DictionaryEncodedColumnPartSerde)mapper.readValue(mapper.writeValueAsString(mapper.readValue(json, ColumnPartSerde.class)), ColumnPartSerde.class);
        Assert.assertEquals((Object)ByteOrder.BIG_ENDIAN, (Object)serde.getByteOrder());
        Assert.assertTrue((boolean)(serde.getBitmapSerdeFactory() instanceof ConciseBitmapSerdeFactory));
        json = "{\n\"type\": \"stringDictionary\",\n\"byteOrder\": \"LITTLE_ENDIAN\",\n\"bitmapSerdeFactory\": { \"type\": \"roaring\" }\n}";
        serde = (DictionaryEncodedColumnPartSerde)mapper.readValue(mapper.writeValueAsString(mapper.readValue(json, ColumnPartSerde.class)), ColumnPartSerde.class);
        Assert.assertEquals((Object)ByteOrder.LITTLE_ENDIAN, (Object)serde.getByteOrder());
        Assert.assertTrue((boolean)(serde.getBitmapSerdeFactory() instanceof RoaringBitmapSerdeFactory));
    }
}

