/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.incremental;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.druid.data.input.InputRow;
import io.druid.data.input.MapBasedInputRow;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IndexSizeExceededException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class TimeAndDimsCompTest {
    @Test
    public void testBasic() throws IndexSizeExceededException {
        IncrementalIndex index = new IncrementalIndex.Builder().setSimpleTestingIndexSchema(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).setMaxRowCount(1000).buildOnheap();
        long time = System.currentTimeMillis();
        IncrementalIndex.TimeAndDims td1 = index.toTimeAndDims((InputRow)this.toMapRow(time, "billy", "A", "joe", "B"));
        IncrementalIndex.TimeAndDims td2 = index.toTimeAndDims((InputRow)this.toMapRow(time, "billy", "A", "joe", "A"));
        IncrementalIndex.TimeAndDims td3 = index.toTimeAndDims((InputRow)this.toMapRow(time, "billy", "A"));
        IncrementalIndex.TimeAndDims td4 = index.toTimeAndDims((InputRow)this.toMapRow(time + 1L, "billy", "A", "joe", "B"));
        IncrementalIndex.TimeAndDims td5 = index.toTimeAndDims((InputRow)this.toMapRow(time + 1L, "billy", "A", "joe", Arrays.asList("A", "B")));
        IncrementalIndex.TimeAndDims td6 = index.toTimeAndDims((InputRow)this.toMapRow(time + 1L, new Object[0]));
        Comparator comparator = index.dimsComparator();
        Assert.assertEquals((long)0L, (long)comparator.compare(td1, td1));
        Assert.assertEquals((long)0L, (long)comparator.compare(td2, td2));
        Assert.assertEquals((long)0L, (long)comparator.compare(td3, td3));
        Assert.assertTrue((comparator.compare(td1, td2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(td2, td1) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(td2, td3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(td3, td2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(td1, td3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(td3, td1) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(td6, td1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(td6, td2) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(td6, td3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(td4, td6) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(td5, td6) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(td4, td5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(td5, td4) > 0 ? 1 : 0) != 0);
    }

    private MapBasedInputRow toMapRow(long time, Object ... dimAndVal) {
        HashMap data = Maps.newHashMap();
        for (int i = 0; i < dimAndVal.length; i += 2) {
            data.put((String)dimAndVal[i], dimAndVal[i + 1]);
        }
        return new MapBasedInputRow(time, (List)Lists.newArrayList(data.keySet()), (Map)data);
    }
}

