/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.druid.data.input.InputRow;
import io.druid.java.util.common.StringUtils;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.segment.IndexMerger;
import io.druid.segment.IndexMergerV9;
import io.druid.segment.IndexSpec;
import io.druid.segment.IndexableAdapter;
import io.druid.segment.QueryableIndex;
import io.druid.segment.QueryableIndexIndexableAdapter;
import io.druid.segment.TestHelper;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IncrementalIndexSchema;
import io.druid.segment.incremental.IndexSizeExceededException;
import io.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import io.druid.segment.writeout.SegmentWriteOutMediumFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.UUID;

public class IndexBuilder {
    private static final int ROWS_PER_INDEX_FOR_MERGING = 1;
    private static final int DEFAULT_MAX_ROWS = Integer.MAX_VALUE;
    private IncrementalIndexSchema schema = new IncrementalIndexSchema.Builder().withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("count")}).build();
    private SegmentWriteOutMediumFactory segmentWriteOutMediumFactory = OffHeapMemorySegmentWriteOutMediumFactory.instance();
    private IndexMerger indexMerger = TestHelper.getTestIndexMergerV9(this.segmentWriteOutMediumFactory);
    private File tmpDir;
    private IndexSpec indexSpec = new IndexSpec();
    private int maxRows = Integer.MAX_VALUE;
    private final List<InputRow> rows = Lists.newArrayList();

    private IndexBuilder() {
    }

    public static IndexBuilder create() {
        return new IndexBuilder();
    }

    public IndexBuilder schema(IncrementalIndexSchema schema) {
        this.schema = schema;
        return this;
    }

    public IndexBuilder segmentWriteOutMediumFactory(SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) {
        this.segmentWriteOutMediumFactory = segmentWriteOutMediumFactory;
        this.indexMerger = TestHelper.getTestIndexMergerV9(segmentWriteOutMediumFactory);
        return this;
    }

    public IndexBuilder indexSpec(IndexSpec indexSpec) {
        this.indexSpec = indexSpec;
        return this;
    }

    public IndexBuilder tmpDir(File tmpDir) {
        this.tmpDir = tmpDir;
        return this;
    }

    public IndexBuilder rows(Iterable<InputRow> rows) {
        this.rows.clear();
        Iterables.addAll(this.rows, rows);
        return this;
    }

    public IncrementalIndex buildIncrementalIndex() {
        return IndexBuilder.buildIncrementalIndexWithRows(this.schema, this.maxRows, this.rows);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public QueryableIndex buildMMappedIndex() {
        Preconditions.checkNotNull((Object)this.indexMerger, (Object)"indexMerger");
        Preconditions.checkNotNull((Object)this.tmpDir, (Object)"tmpDir");
        try (IncrementalIndex incrementalIndex = this.buildIncrementalIndex();){
            QueryableIndex queryableIndex = TestHelper.getTestIndexIO(this.segmentWriteOutMediumFactory).loadIndex(this.indexMerger.persist(incrementalIndex, new File(this.tmpDir, StringUtils.format((String)"testIndex-%s", (Object[])new Object[]{new Random().nextInt(Integer.MAX_VALUE)})), this.indexSpec, null));
            return queryableIndex;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public QueryableIndex buildMMappedMergedIndex() {
        IndexMergerV9 indexMerger = TestHelper.getTestIndexMergerV9(this.segmentWriteOutMediumFactory);
        Preconditions.checkNotNull((Object)this.tmpDir, (Object)"tmpDir");
        ArrayList persisted = Lists.newArrayList();
        try {
            for (int i = 0; i < this.rows.size(); ++i) {
                persisted.add(TestHelper.getTestIndexIO(this.segmentWriteOutMediumFactory).loadIndex(indexMerger.persist(IndexBuilder.buildIncrementalIndexWithRows(this.schema, this.maxRows, this.rows.subList(i, Math.min(this.rows.size(), i + 1))), new File(this.tmpDir, StringUtils.format((String)"testIndex-%s", (Object[])new Object[]{UUID.randomUUID().toString()})), this.indexSpec, null)));
            }
            QueryableIndex merged = TestHelper.getTestIndexIO(this.segmentWriteOutMediumFactory).loadIndex(indexMerger.merge(Lists.transform((List)persisted, (Function)new Function<QueryableIndex, IndexableAdapter>(){

                public IndexableAdapter apply(QueryableIndex input) {
                    return new QueryableIndexIndexableAdapter(input);
                }
            }), true, (AggregatorFactory[])Iterables.toArray((Iterable)Iterables.transform(Arrays.asList(this.schema.getMetrics()), (Function)new Function<AggregatorFactory, AggregatorFactory>(){

                public AggregatorFactory apply(AggregatorFactory input) {
                    return input.getCombiningFactory();
                }
            }), AggregatorFactory.class), new File(this.tmpDir, StringUtils.format((String)"testIndex-%s", (Object[])new Object[]{UUID.randomUUID()})), this.indexSpec));
            for (QueryableIndex index : persisted) {
                index.close();
            }
            return merged;
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static IncrementalIndex buildIncrementalIndexWithRows(IncrementalIndexSchema schema, int maxRows, Iterable<InputRow> rows) {
        Preconditions.checkNotNull((Object)schema, (Object)"schema");
        IncrementalIndex incrementalIndex = new IncrementalIndex.Builder().setIndexSchema(schema).setMaxRowCount(maxRows).buildOnheap();
        for (InputRow row : rows) {
            try {
                incrementalIndex.add(row);
            }
            catch (IndexSizeExceededException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return incrementalIndex;
    }
}

