/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.Intervals;
import io.druid.java.util.common.granularity.Granularities;
import io.druid.java.util.common.guava.Sequence;
import io.druid.query.CacheStrategy;
import io.druid.query.DataSource;
import io.druid.query.Query;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.Result;
import io.druid.query.TableDataSource;
import io.druid.query.TestQueryRunners;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.query.aggregation.post.ArithmeticPostAggregator;
import io.druid.query.aggregation.post.ConstantPostAggregator;
import io.druid.query.aggregation.post.FieldAccessPostAggregator;
import io.druid.query.dimension.DefaultDimensionSpec;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.spec.MultipleIntervalSegmentSpec;
import io.druid.query.spec.QuerySegmentSpec;
import io.druid.query.topn.NumericTopNMetricSpec;
import io.druid.query.topn.TopNMetricSpec;
import io.druid.query.topn.TopNQuery;
import io.druid.query.topn.TopNQueryBuilder;
import io.druid.query.topn.TopNQueryConfig;
import io.druid.query.topn.TopNQueryQueryToolChest;
import io.druid.query.topn.TopNQueryRunnerFactory;
import io.druid.query.topn.TopNResultValue;
import io.druid.segment.IncrementalIndexSegment;
import io.druid.segment.Segment;
import io.druid.segment.TestHelper;
import io.druid.segment.TestIndex;
import io.druid.segment.VirtualColumns;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class TopNQueryQueryToolChestTest {
    private static final String segmentId = "testSegment";

    @Test
    public void testCacheStrategy() throws Exception {
        CacheStrategy strategy = new TopNQueryQueryToolChest(null, null).getCacheStrategy(new TopNQuery((DataSource)new TableDataSource("dummy"), VirtualColumns.EMPTY, (DimensionSpec)new DefaultDimensionSpec("test", "test"), (TopNMetricSpec)new NumericTopNMetricSpec("metric1"), 3, (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2015-01-01/2015-01-02"))), null, Granularities.ALL, (List)ImmutableList.of((Object)new CountAggregatorFactory("metric1")), (List)ImmutableList.of((Object)new ConstantPostAggregator("post", (Number)10)), null));
        Result result = new Result(DateTimes.utc((long)123L), (Object)new TopNResultValue(Arrays.asList(ImmutableMap.of((Object)"test", (Object)"val1", (Object)"metric1", (Object)2))));
        Object preparedValue = strategy.prepareForCache().apply((Object)result);
        ObjectMapper objectMapper = TestHelper.makeJsonMapper();
        Object fromCacheValue = objectMapper.readValue(objectMapper.writeValueAsBytes(preparedValue), strategy.getCacheObjectClazz());
        Result fromCacheResult = (Result)strategy.pullFromCache().apply(fromCacheValue);
        Assert.assertEquals((Object)result, (Object)fromCacheResult);
    }

    @Test
    public void testComputeCacheKeyWithDifferentPostAgg() throws Exception {
        TopNQuery query1 = new TopNQuery((DataSource)new TableDataSource("dummy"), VirtualColumns.EMPTY, (DimensionSpec)new DefaultDimensionSpec("test", "test"), (TopNMetricSpec)new NumericTopNMetricSpec("post"), 3, (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2015-01-01/2015-01-02"))), null, Granularities.ALL, (List)ImmutableList.of((Object)new CountAggregatorFactory("metric1")), (List)ImmutableList.of((Object)new ConstantPostAggregator("post", (Number)10)), null);
        TopNQuery query2 = new TopNQuery((DataSource)new TableDataSource("dummy"), VirtualColumns.EMPTY, (DimensionSpec)new DefaultDimensionSpec("test", "test"), (TopNMetricSpec)new NumericTopNMetricSpec("post"), 3, (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2015-01-01/2015-01-02"))), null, Granularities.ALL, (List)ImmutableList.of((Object)new CountAggregatorFactory("metric1")), (List)ImmutableList.of((Object)new ArithmeticPostAggregator("post", "+", (List)ImmutableList.of((Object)new FieldAccessPostAggregator(null, "metric1"), (Object)new FieldAccessPostAggregator(null, "metric1")))), null);
        CacheStrategy strategy1 = new TopNQueryQueryToolChest(null, null).getCacheStrategy(query1);
        CacheStrategy strategy2 = new TopNQueryQueryToolChest(null, null).getCacheStrategy(query2);
        Assert.assertFalse((boolean)Arrays.equals(strategy1.computeCacheKey((Query)query1), strategy2.computeCacheKey((Query)query2)));
    }

    @Test
    public void testMinTopNThreshold() throws Exception {
        TopNQueryConfig config = new TopNQueryConfig();
        TopNQueryQueryToolChest chest = new TopNQueryQueryToolChest(config, QueryRunnerTestHelper.NoopIntervalChunkingQueryRunnerDecorator());
        TopNQueryRunnerFactory factory = new TopNQueryRunnerFactory(TestQueryRunners.getPool(), chest, QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        QueryRunner runner = QueryRunnerTestHelper.makeQueryRunner(factory, (Segment)new IncrementalIndexSegment(TestIndex.getIncrementalTestIndex(), segmentId), null);
        HashMap context = Maps.newHashMap();
        context.put("minTopNThreshold", 500);
        TopNQueryBuilder builder = new TopNQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.allGran).dimension("placementish").metric("index").intervals(QueryRunnerTestHelper.fullOnInterval).aggregators(QueryRunnerTestHelper.commonDoubleAggregators);
        TopNQuery query1 = builder.threshold(10).context(null).build();
        MockQueryRunner mockRunner = new MockQueryRunner(runner);
        new TopNQueryQueryToolChest.ThresholdAdjustingQueryRunner((QueryRunner)mockRunner, config).run(QueryPlus.wrap((Query)query1), (Map)ImmutableMap.of());
        Assert.assertEquals((long)1000L, (long)mockRunner.query.getThreshold());
        TopNQuery query2 = builder.threshold(10).context((Map)context).build();
        new TopNQueryQueryToolChest.ThresholdAdjustingQueryRunner((QueryRunner)mockRunner, config).run(QueryPlus.wrap((Query)query2), (Map)ImmutableMap.of());
        Assert.assertEquals((long)500L, (long)mockRunner.query.getThreshold());
        TopNQuery query3 = builder.threshold(2000).context((Map)context).build();
        new TopNQueryQueryToolChest.ThresholdAdjustingQueryRunner((QueryRunner)mockRunner, config).run(QueryPlus.wrap((Query)query3), (Map)ImmutableMap.of());
        Assert.assertEquals((long)2000L, (long)mockRunner.query.getThreshold());
    }

    static class MockQueryRunner
    implements QueryRunner<Result<TopNResultValue>> {
        private final QueryRunner<Result<TopNResultValue>> runner;
        TopNQuery query = null;

        MockQueryRunner(QueryRunner<Result<TopNResultValue>> runner) {
            this.runner = runner;
        }

        public Sequence<Result<TopNResultValue>> run(QueryPlus<Result<TopNResultValue>> queryPlus, Map<String, Object> responseContext) {
            this.query = (TopNQuery)queryPlus.getQuery();
            return this.runner.run(queryPlus, responseContext);
        }
    }
}

