/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.google.common.collect.ImmutableSet;
import io.druid.java.util.common.granularity.Granularities;
import io.druid.java.util.emitter.core.Emitter;
import io.druid.java.util.emitter.service.ServiceEmitter;
import io.druid.query.CachingEmitter;
import io.druid.query.DefaultQueryMetricsTest;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.aggregation.CountAggregatorFactory;
import io.druid.query.dimension.DefaultDimensionSpec;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.dimension.ListFilteredDimensionSpec;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.SelectorDimFilter;
import io.druid.query.topn.DefaultTopNQueryMetrics;
import io.druid.query.topn.TopNQuery;
import io.druid.query.topn.TopNQueryBuilder;
import io.druid.segment.TestHelper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.joda.time.Interval;
import org.joda.time.base.AbstractInterval;
import org.junit.Assert;
import org.junit.Test;

public class DefaultTopNQueryMetricsTest {
    @Test
    public void testDefaultTopNQueryMetricsQuery() {
        CachingEmitter cachingEmitter = new CachingEmitter();
        ServiceEmitter serviceEmitter = new ServiceEmitter("", "", (Emitter)cachingEmitter);
        DefaultTopNQueryMetrics queryMetrics = new DefaultTopNQueryMetrics(TestHelper.makeJsonMapper());
        TopNQuery query = new TopNQueryBuilder().dataSource("xx").granularity(Granularities.ALL).dimension((DimensionSpec)new ListFilteredDimensionSpec((DimensionSpec)new DefaultDimensionSpec("tags", "tags"), (Set)ImmutableSet.of((Object)"t3"), null)).metric("count").intervals(QueryRunnerTestHelper.fullOnInterval).aggregators(Collections.singletonList(new CountAggregatorFactory("count"))).threshold(5).filters((DimFilter)new SelectorDimFilter("tags", "t3", null)).build();
        queryMetrics.query(query);
        queryMetrics.reportQueryTime(0L).emit(serviceEmitter);
        Map actualEvent = cachingEmitter.getLastEmittedEvent().toMap();
        Assert.assertEquals((long)16L, (long)actualEvent.size());
        Assert.assertTrue((boolean)actualEvent.containsKey("feed"));
        Assert.assertTrue((boolean)actualEvent.containsKey("timestamp"));
        Assert.assertEquals((Object)"", actualEvent.get("host"));
        Assert.assertEquals((Object)"", actualEvent.get("service"));
        Assert.assertEquals((Object)"xx", actualEvent.get("dataSource"));
        Assert.assertEquals((Object)query.getType(), actualEvent.get("type"));
        List expectedIntervals = QueryRunnerTestHelper.fullOnInterval.getIntervals();
        List expectedStringIntervals = expectedIntervals.stream().map(AbstractInterval::toString).collect(Collectors.toList());
        Assert.assertEquals(expectedStringIntervals, actualEvent.get("interval"));
        Assert.assertEquals((Object)"true", actualEvent.get("hasFilters"));
        Assert.assertEquals((Object)((Interval)expectedIntervals.get(0)).toDuration().toString(), actualEvent.get("duration"));
        Assert.assertEquals((Object)"", actualEvent.get("id"));
        Assert.assertEquals((Object)"5", actualEvent.get("threshold"));
        Assert.assertEquals((Object)"tags", actualEvent.get("dimension"));
        Assert.assertEquals((Object)"1", actualEvent.get("numMetrics"));
        Assert.assertEquals((Object)"0", actualEvent.get("numComplexMetrics"));
        Assert.assertEquals((Object)"query/time", actualEvent.get("metric"));
        Assert.assertEquals((Object)0L, actualEvent.get("value"));
    }

    @Test
    public void testDefaultTopNQueryMetricsMetricNamesAndUnits() {
        CachingEmitter cachingEmitter = new CachingEmitter();
        ServiceEmitter serviceEmitter = new ServiceEmitter("", "", (Emitter)cachingEmitter);
        DefaultTopNQueryMetrics queryMetrics = new DefaultTopNQueryMetrics(TestHelper.makeJsonMapper());
        DefaultQueryMetricsTest.testQueryMetricsDefaultMetricNamesAndUnits(cachingEmitter, serviceEmitter, queryMetrics);
    }
}

