/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.timeboundary;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.java.util.common.DateTimes;
import io.druid.java.util.common.Intervals;
import io.druid.query.CacheStrategy;
import io.druid.query.DataSource;
import io.druid.query.Druids;
import io.druid.query.Result;
import io.druid.query.TableDataSource;
import io.druid.query.spec.MultipleIntervalSegmentSpec;
import io.druid.query.spec.QuerySegmentSpec;
import io.druid.query.timeboundary.TimeBoundaryQuery;
import io.druid.query.timeboundary.TimeBoundaryQueryQueryToolChest;
import io.druid.query.timeboundary.TimeBoundaryResultValue;
import io.druid.timeline.LogicalSegment;
import java.util.Arrays;
import java.util.List;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class TimeBoundaryQueryQueryToolChestTest {
    private static final TimeBoundaryQuery TIME_BOUNDARY_QUERY = new TimeBoundaryQuery((DataSource)new TableDataSource("test"), null, null, null, null);
    private static final TimeBoundaryQuery MAXTIME_BOUNDARY_QUERY = new TimeBoundaryQuery((DataSource)new TableDataSource("test"), null, "maxTime", null, null);
    private static final TimeBoundaryQuery MINTIME_BOUNDARY_QUERY = new TimeBoundaryQuery((DataSource)new TableDataSource("test"), null, "minTime", null, null);
    private static final TimeBoundaryQuery FILTERED_BOUNDARY_QUERY = Druids.newTimeBoundaryQueryBuilder().dataSource("testing").filters("foo", "bar").build();

    private static LogicalSegment createLogicalSegment(final Interval interval) {
        return new LogicalSegment(){

            public Interval getInterval() {
                return interval;
            }
        };
    }

    @Test
    public void testFilterSegments() throws Exception {
        List segments = new TimeBoundaryQueryQueryToolChest().filterSegments(TIME_BOUNDARY_QUERY, Arrays.asList(TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01/P1D")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01T01/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01T02/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-02/P1D")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03T01/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03T02/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03/P1D"))));
        Assert.assertEquals((long)6L, (long)segments.size());
        List<LogicalSegment> expected = Arrays.asList(TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01/P1D")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01T01/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01T02/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03T01/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03T02/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03/P1D")));
        for (int i = 0; i < segments.size(); ++i) {
            Assert.assertEquals((Object)((LogicalSegment)segments.get(i)).getInterval(), (Object)expected.get(i).getInterval());
        }
    }

    @Test
    public void testMaxTimeFilterSegments() throws Exception {
        List segments = new TimeBoundaryQueryQueryToolChest().filterSegments(MAXTIME_BOUNDARY_QUERY, Arrays.asList(TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01/P1D")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01T01/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01T02/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-02/P1D")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03T01/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03T02/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03/P1D"))));
        Assert.assertEquals((long)3L, (long)segments.size());
        List<LogicalSegment> expected = Arrays.asList(TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03T01/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03T02/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03/P1D")));
        for (int i = 0; i < segments.size(); ++i) {
            Assert.assertEquals((Object)((LogicalSegment)segments.get(i)).getInterval(), (Object)expected.get(i).getInterval());
        }
    }

    @Test
    public void testMinTimeFilterSegments() throws Exception {
        List segments = new TimeBoundaryQueryQueryToolChest().filterSegments(MINTIME_BOUNDARY_QUERY, Arrays.asList(TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01/P1D")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01T01/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01T02/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-02/P1D")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03T01/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03T02/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03/P1D"))));
        Assert.assertEquals((long)3L, (long)segments.size());
        List<LogicalSegment> expected = Arrays.asList(TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01/P1D")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01T01/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01T02/PT1H")));
        for (int i = 0; i < segments.size(); ++i) {
            Assert.assertEquals((Object)((LogicalSegment)segments.get(i)).getInterval(), (Object)expected.get(i).getInterval());
        }
    }

    @Test
    public void testFilteredFilterSegments() throws Exception {
        List segments = new TimeBoundaryQueryQueryToolChest().filterSegments(FILTERED_BOUNDARY_QUERY, Arrays.asList(TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01/P1D")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01T01/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-01T02/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-02/P1D")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03T01/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03T02/PT1H")), TimeBoundaryQueryQueryToolChestTest.createLogicalSegment(Intervals.of((String)"2013-01-03/P1D"))));
        Assert.assertEquals((long)7L, (long)segments.size());
    }

    @Test
    public void testCacheStrategy() throws Exception {
        CacheStrategy strategy = new TimeBoundaryQueryQueryToolChest().getCacheStrategy(new TimeBoundaryQuery((DataSource)new TableDataSource("dummy"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2015-01-01/2015-01-02"))), null, null, null));
        Result result = new Result(DateTimes.utc((long)123L), (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"minTime", (Object)DateTimes.EPOCH.toString(), (Object)"maxTime", (Object)DateTimes.of((String)"2015-01-01").toString())));
        Object preparedValue = strategy.prepareForCache().apply((Object)result);
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        Object fromCacheValue = objectMapper.readValue(objectMapper.writeValueAsBytes(preparedValue), strategy.getCacheObjectClazz());
        Result fromCacheResult = (Result)strategy.pullFromCache().apply(fromCacheValue);
        Assert.assertEquals((Object)result, (Object)fromCacheResult);
    }
}

