/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.select;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import io.druid.query.select.PagingOffset;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;

public class PagingOffsetTest {
    @Test
    public void testZeroThreshold() throws Exception {
        PagingOffset offset = PagingOffset.of((int)PagingOffset.toOffset((int)3, (boolean)false), (int)0);
        Assert.assertEquals((long)3L, (long)offset.startOffset());
        Assert.assertEquals((long)3L, (long)offset.startDelta());
        Assert.assertArrayEquals((int[])new int[0], (int[])this.toArray(offset));
        offset = PagingOffset.of((int)PagingOffset.toOffset((int)3, (boolean)true), (int)0);
        Assert.assertEquals((long)-4L, (long)offset.startOffset());
        Assert.assertEquals((long)3L, (long)offset.startDelta());
        Assert.assertArrayEquals((int[])new int[0], (int[])this.toArray(offset));
    }

    @Test
    public void testAscending() throws Exception {
        PagingOffset offset = PagingOffset.of((int)PagingOffset.toOffset((int)3, (boolean)false), (int)3);
        Assert.assertEquals((long)3L, (long)offset.startOffset());
        Assert.assertEquals((long)3L, (long)offset.startDelta());
        Assert.assertArrayEquals((int[])new int[]{3, 4, 5}, (int[])this.toArray(offset));
    }

    @Test
    public void testDescending() throws Exception {
        PagingOffset offset = PagingOffset.of((int)PagingOffset.toOffset((int)3, (boolean)true), (int)3);
        Assert.assertEquals((long)-4L, (long)offset.startOffset());
        Assert.assertEquals((long)3L, (long)offset.startDelta());
        Assert.assertArrayEquals((int[])new int[]{-4, -5, -6}, (int[])this.toArray(offset));
    }

    private int[] toArray(PagingOffset offset) {
        ArrayList ints = Lists.newArrayList();
        while (offset.hasNext()) {
            ints.add(offset.current());
            offset.next();
        }
        return Ints.toArray((Collection)ints);
    }
}

