/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.ordering;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.ordering.StringComparator;
import io.druid.query.ordering.StringComparators;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class StringComparatorsTest {
    private void commonTest(StringComparator comparator) {
        Assert.assertTrue((comparator.compare(null, null) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare((Object)"", (Object)"") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare((Object)"123", (Object)"123") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare((Object)"abc123", (Object)"abc123") == 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare((Object)"", (Object)"abc") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare((Object)"abc", (Object)"") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare(null, (Object)"apple") < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLexicographicComparator() {
        this.commonTest(StringComparators.LEXICOGRAPHIC);
        Assert.assertTrue((StringComparators.LEXICOGRAPHIC.compare((Object)"apple", (Object)"banana") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringComparators.LEXICOGRAPHIC.compare((Object)"banana", (Object)"banana") == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAlphanumericComparator() {
        this.commonTest(StringComparators.ALPHANUMERIC);
        Assert.assertTrue((StringComparators.ALPHANUMERIC.compare((Object)"123", (Object)"abc") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringComparators.ALPHANUMERIC.compare((Object)"abc", (Object)"123") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringComparators.ALPHANUMERIC.compare((Object)"2", (Object)"11") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringComparators.ALPHANUMERIC.compare((Object)"a2", (Object)"a11") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringComparators.ALPHANUMERIC.compare((Object)"02", (Object)"11") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringComparators.ALPHANUMERIC.compare((Object)"02", (Object)"002") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringComparators.ALPHANUMERIC.compare((Object)"1.3", (Object)"1.5") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringComparators.ALPHANUMERIC.compare((Object)"1.3", (Object)"1.15") < 0 ? 1 : 0) != 0);
        ArrayList sorted = Lists.newArrayList((Object[])new String[]{"1-5", "11-15", "16-20", "21-25", "26-30", "6-10", "Other"});
        Collections.sort(sorted, StringComparators.ALPHANUMERIC);
        Assert.assertEquals((Object)ImmutableList.of((Object)"1-5", (Object)"6-10", (Object)"11-15", (Object)"16-20", (Object)"21-25", (Object)"26-30", (Object)"Other"), (Object)sorted);
        ArrayList sortedFixedDecimal = Lists.newArrayList((Object[])new String[]{"Other", "[0.00-0.05)", "[0.05-0.10)", "[0.10-0.50)", "[0.50-1.00)", "[1.00-5.00)", "[5.00-10.00)", "[10.00-20.00)"});
        Collections.sort(sortedFixedDecimal, StringComparators.ALPHANUMERIC);
        Assert.assertEquals((Object)ImmutableList.of((Object)"[0.00-0.05)", (Object)"[0.05-0.10)", (Object)"[0.10-0.50)", (Object)"[0.50-1.00)", (Object)"[1.00-5.00)", (Object)"[5.00-10.00)", (Object)"[10.00-20.00)", (Object)"Other"), (Object)sortedFixedDecimal);
    }

    @Test
    public void testStrlenComparator() {
        this.commonTest(StringComparators.STRLEN);
        Assert.assertTrue((StringComparators.STRLEN.compare((Object)"a", (Object)"apple") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringComparators.STRLEN.compare((Object)"a", (Object)"elppa") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringComparators.STRLEN.compare((Object)"apple", (Object)"elppa") < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNumericComparator() {
        this.commonTest(StringComparators.NUMERIC);
        Assert.assertTrue((StringComparators.NUMERIC.compare((Object)"-1230.452487532", (Object)"6893") < 0 ? 1 : 0) != 0);
        List<String> values = Arrays.asList("-1", "-1.10", "-1.2", "-100", "-2", "0", "1", "1.10", "1.2", "2", "100");
        Collections.sort(values, StringComparators.NUMERIC);
        Assert.assertEquals(Arrays.asList("-100", "-2", "-1.2", "-1.10", "-1", "0", "1", "1.10", "1.2", "2", "100"), values);
        Assert.assertTrue((StringComparators.NUMERIC.compare(null, null) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringComparators.NUMERIC.compare(null, (Object)"1001") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringComparators.NUMERIC.compare((Object)"1001", null) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringComparators.NUMERIC.compare((Object)"-500000000.14124", (Object)"CAN'T TOUCH THIS") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringComparators.NUMERIC.compare((Object)"CAN'T PARSE THIS", (Object)"-500000000.14124") < 0 ? 1 : 0) != 0);
        Assert.assertTrue((StringComparators.NUMERIC.compare((Object)"CAN'T PARSE THIS", (Object)"CAN'T TOUCH THIS") < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testLexicographicComparatorSerdeTest() throws IOException {
        DefaultObjectMapper jsonMapper = new DefaultObjectMapper();
        String expectJsonSpec = "{\"type\":\"lexicographic\"}";
        String jsonSpec = jsonMapper.writeValueAsString((Object)StringComparators.LEXICOGRAPHIC);
        Assert.assertEquals((Object)expectJsonSpec, (Object)jsonSpec);
        Assert.assertEquals((Object)StringComparators.LEXICOGRAPHIC, (Object)jsonMapper.readValue(expectJsonSpec, StringComparator.class));
        String makeFromJsonSpec = "\"lexicographic\"";
        Assert.assertEquals((Object)StringComparators.LEXICOGRAPHIC, (Object)jsonMapper.readValue(makeFromJsonSpec, StringComparator.class));
    }

    @Test
    public void testAlphanumericComparatorSerdeTest() throws IOException {
        DefaultObjectMapper jsonMapper = new DefaultObjectMapper();
        String expectJsonSpec = "{\"type\":\"alphanumeric\"}";
        String jsonSpec = jsonMapper.writeValueAsString((Object)StringComparators.ALPHANUMERIC);
        Assert.assertEquals((Object)expectJsonSpec, (Object)jsonSpec);
        Assert.assertEquals((Object)StringComparators.ALPHANUMERIC, (Object)jsonMapper.readValue(expectJsonSpec, StringComparator.class));
        String makeFromJsonSpec = "\"alphanumeric\"";
        Assert.assertEquals((Object)StringComparators.ALPHANUMERIC, (Object)jsonMapper.readValue(makeFromJsonSpec, StringComparator.class));
    }

    @Test
    public void testStrlenComparatorSerdeTest() throws IOException {
        DefaultObjectMapper jsonMapper = new DefaultObjectMapper();
        String expectJsonSpec = "{\"type\":\"strlen\"}";
        String jsonSpec = jsonMapper.writeValueAsString((Object)StringComparators.STRLEN);
        Assert.assertEquals((Object)expectJsonSpec, (Object)jsonSpec);
        Assert.assertEquals((Object)StringComparators.STRLEN, (Object)jsonMapper.readValue(expectJsonSpec, StringComparator.class));
        String makeFromJsonSpec = "\"strlen\"";
        Assert.assertEquals((Object)StringComparators.STRLEN, (Object)jsonMapper.readValue(makeFromJsonSpec, StringComparator.class));
    }

    @Test
    public void testNumericComparatorSerdeTest() throws IOException {
        DefaultObjectMapper jsonMapper = new DefaultObjectMapper();
        String expectJsonSpec = "{\"type\":\"numeric\"}";
        String jsonSpec = jsonMapper.writeValueAsString((Object)StringComparators.NUMERIC);
        Assert.assertEquals((Object)expectJsonSpec, (Object)jsonSpec);
        Assert.assertEquals((Object)StringComparators.NUMERIC, (Object)jsonMapper.readValue(expectJsonSpec, StringComparator.class));
        String makeFromJsonSpec = "\"numeric\"";
        Assert.assertEquals((Object)StringComparators.NUMERIC, (Object)jsonMapper.readValue(makeFromJsonSpec, StringComparator.class));
        makeFromJsonSpec = "\"NuMeRiC\"";
        Assert.assertEquals((Object)StringComparators.NUMERIC, (Object)jsonMapper.readValue(makeFromJsonSpec, StringComparator.class));
    }
}

