/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby.having;

import com.google.common.collect.ImmutableMap;
import io.druid.data.input.MapBasedRow;
import io.druid.data.input.Row;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.SelectorDimFilter;
import io.druid.query.groupby.having.DimFilterHavingSpec;
import io.druid.query.groupby.having.HavingSpec;
import io.druid.segment.column.ValueType;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.rules.ExpectedException;

public class DimFilterHavingSpecTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testSimple() {
        DimFilterHavingSpec havingSpec = new DimFilterHavingSpec((DimFilter)new SelectorDimFilter("foo", "bar", null), null);
        havingSpec.setRowSignature(null);
        Assert.assertTrue((boolean)havingSpec.eval((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"foo", (Object)"bar"))));
        Assert.assertFalse((boolean)havingSpec.eval((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"foo", (Object)"baz"))));
    }

    @Test
    public void testRowSignature() {
        DimFilterHavingSpec havingSpec = new DimFilterHavingSpec((DimFilter)new SelectorDimFilter("foo", "1", null), null);
        havingSpec.setRowSignature((Map)ImmutableMap.of((Object)"foo", (Object)ValueType.LONG));
        Assert.assertTrue((boolean)havingSpec.eval((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"foo", (Object)1L))));
        Assert.assertFalse((boolean)havingSpec.eval((Row)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"foo", (Object)2L))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    @Ignore
    public void testConcurrentUsage() throws Exception {
        ExecutorService exec = Executors.newFixedThreadPool(2);
        final DimFilterHavingSpec havingSpec = new DimFilterHavingSpec((DimFilter)new SelectorDimFilter("foo", "1", null), null);
        ArrayList futures = new ArrayList();
        for (int i = 0; i < 2; ++i) {
            final MapBasedRow mapBasedRow = new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"foo", (Object)String.valueOf(i)));
            futures.add(exec.submit(new Runnable(){

                @Override
                public void run() {
                    havingSpec.setRowSignature(null);
                    while (!Thread.interrupted()) {
                        havingSpec.eval((Row)mapBasedRow);
                    }
                }
            }));
        }
        this.expectedException.expect(ExecutionException.class);
        this.expectedException.expectCause(CoreMatchers.instanceOf(IllegalStateException.class));
        this.expectedException.expectCause(ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"concurrent 'eval' calls not permitted")));
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            exec.shutdownNow();
        }
        Assert.assertTrue((boolean)false);
    }

    @Test
    public void testSerde() throws Exception {
        DimFilterHavingSpec havingSpec = new DimFilterHavingSpec((DimFilter)new SelectorDimFilter("foo", "1", null), Boolean.valueOf(false));
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        Assert.assertEquals((Object)havingSpec, (Object)objectMapper.readValue(objectMapper.writeValueAsBytes((Object)havingSpec), HavingSpec.class));
    }
}

