/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import io.druid.data.input.MapBasedRow;
import io.druid.java.util.common.granularity.Granularities;
import io.druid.query.Query;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.aggregation.LongSumAggregatorFactory;
import io.druid.query.aggregation.post.FieldAccessPostAggregator;
import io.druid.query.dimension.DefaultDimensionSpec;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.orderby.DefaultLimitSpec;
import io.druid.query.groupby.orderby.LimitSpec;
import io.druid.query.groupby.orderby.OrderByColumnSpec;
import io.druid.query.ordering.StringComparators;
import io.druid.segment.TestHelper;
import io.druid.segment.column.ValueType;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class GroupByQueryTest {
    private static final ObjectMapper jsonMapper = TestHelper.makeJsonMapper();

    @Test
    public void testQuerySerialization() throws IOException {
        GroupByQuery query = GroupByQuery.builder().setDataSource("testing").setQuerySegmentSpec(QueryRunnerTestHelper.firstToThird).setDimensions((List)Lists.newArrayList((Object[])new DimensionSpec[]{new DefaultDimensionSpec("quality", "alias")})).setAggregatorSpecs(Arrays.asList(QueryRunnerTestHelper.rowsCount, new LongSumAggregatorFactory("idx", "index"))).setGranularity(QueryRunnerTestHelper.dayGran).setPostAggregatorSpecs((List)ImmutableList.of((Object)new FieldAccessPostAggregator("x", "idx"))).setLimitSpec((LimitSpec)new DefaultLimitSpec((List)ImmutableList.of((Object)new OrderByColumnSpec("alias", OrderByColumnSpec.Direction.ASCENDING, StringComparators.LEXICOGRAPHIC)), Integer.valueOf(100))).build();
        String json = jsonMapper.writeValueAsString((Object)query);
        Query serdeQuery = (Query)jsonMapper.readValue(json, Query.class);
        Assert.assertEquals((Object)query, (Object)serdeQuery);
    }

    @Test
    public void testRowOrderingMixTypes() {
        GroupByQuery query = GroupByQuery.builder().setDataSource("dummy").setGranularity(Granularities.ALL).setInterval("2000/2001").addDimension((DimensionSpec)new DefaultDimensionSpec("foo", "foo", ValueType.LONG)).addDimension((DimensionSpec)new DefaultDimensionSpec("bar", "bar", ValueType.FLOAT)).addDimension((DimensionSpec)new DefaultDimensionSpec("baz", "baz", ValueType.STRING)).build();
        Ordering rowOrdering = query.getRowOrdering(false);
        int compare = rowOrdering.compare((Object)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"foo", (Object)1, (Object)"bar", (Object)Float.valueOf(1.0f), (Object)"baz", (Object)"a")), (Object)new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"foo", (Object)1L, (Object)"bar", (Object)1.0, (Object)"baz", (Object)"b")));
        Assert.assertEquals((long)-1L, (long)compare);
    }
}

