/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.filter;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.Sets;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.DimFilterUtils;
import io.druid.timeline.partition.ShardSpec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class DimFilterUtilsTest {
    private static final Function<ShardSpec, ShardSpec> CONVERTER = new Function<ShardSpec, ShardSpec>(){

        @Nullable
        public ShardSpec apply(@Nullable ShardSpec input) {
            return input;
        }
    };

    @Test
    public void testFilterShards() {
        DimFilter filter1 = (DimFilter)EasyMock.createMock(DimFilter.class);
        EasyMock.expect((Object)filter1.getDimensionRangeSet("dim1")).andReturn(DimFilterUtilsTest.rangeSet((List<Range<String>>)ImmutableList.of((Object)Range.lessThan((Comparable)((Object)"abc"))))).anyTimes();
        EasyMock.expect((Object)filter1.getDimensionRangeSet("dim2")).andReturn(null).anyTimes();
        DimFilter filter2 = (DimFilter)EasyMock.createMock(DimFilter.class);
        EasyMock.expect((Object)filter2.getDimensionRangeSet("dim1")).andReturn(DimFilterUtilsTest.rangeSet((List<Range<String>>)ImmutableList.of((Object)Range.singleton((Comparable)((Object)"e"))))).anyTimes();
        EasyMock.expect((Object)filter2.getDimensionRangeSet("dim2")).andReturn(DimFilterUtilsTest.rangeSet((List<Range<String>>)ImmutableList.of((Object)Range.singleton((Comparable)((Object)"na"))))).anyTimes();
        ShardSpec shard1 = DimFilterUtilsTest.shardSpec("dim1", (Range<String>)Range.atMost((Comparable)((Object)"abc")));
        ShardSpec shard2 = DimFilterUtilsTest.shardSpec("dim1", (Range<String>)Range.closed((Comparable)((Object)"abc"), (Comparable)((Object)"def")));
        ShardSpec shard3 = DimFilterUtilsTest.shardSpec("dim1", (Range<String>)Range.atLeast((Comparable)((Object)"def")));
        ShardSpec shard4 = DimFilterUtilsTest.shardSpec("dim2", (Range<String>)Range.atMost((Comparable)((Object)"hello")));
        ShardSpec shard5 = DimFilterUtilsTest.shardSpec("dim2", (Range<String>)Range.closed((Comparable)((Object)"hello"), (Comparable)((Object)"jk")));
        ShardSpec shard6 = DimFilterUtilsTest.shardSpec("dim2", (Range<String>)Range.closed((Comparable)((Object)"jk"), (Comparable)((Object)"na")));
        ShardSpec shard7 = DimFilterUtilsTest.shardSpec("dim2", (Range<String>)Range.atLeast((Comparable)((Object)"na")));
        ImmutableList shards = ImmutableList.of((Object)shard1, (Object)shard2, (Object)shard3, (Object)shard4, (Object)shard5, (Object)shard6, (Object)shard7);
        EasyMock.replay((Object[])new Object[]{filter1, filter2, shard1, shard2, shard3, shard4, shard5, shard6, shard7});
        ImmutableSet expected1 = ImmutableSet.of((Object)shard1, (Object)shard4, (Object)shard5, (Object)shard6, (Object)shard7);
        this.assertFilterResult(filter1, (Iterable<ShardSpec>)shards, (Set<ShardSpec>)expected1);
        ImmutableSet expected2 = ImmutableSet.of((Object)shard3, (Object)shard6, (Object)shard7);
        this.assertFilterResult(filter2, (Iterable<ShardSpec>)shards, (Set<ShardSpec>)expected2);
    }

    private void assertFilterResult(DimFilter filter, Iterable<ShardSpec> input, Set<ShardSpec> expected) {
        Set result = DimFilterUtils.filterShards((DimFilter)filter, input, CONVERTER);
        Assert.assertEquals(expected, (Object)result);
        HashMap dimensionRangeMap = Maps.newHashMap();
        result = Sets.newHashSet();
        for (ShardSpec shard : input) {
            result.addAll(DimFilterUtils.filterShards((DimFilter)filter, (Iterable)ImmutableList.of((Object)shard), CONVERTER, (Map)dimensionRangeMap));
        }
        Assert.assertEquals(expected, (Object)result);
    }

    private static RangeSet<String> rangeSet(List<Range<String>> ranges) {
        ImmutableRangeSet.Builder builder = ImmutableRangeSet.builder();
        for (Range<String> range : ranges) {
            builder.add(range);
        }
        return builder.build();
    }

    private static ShardSpec shardSpec(String dimension, Range<String> range) {
        ShardSpec shard = (ShardSpec)EasyMock.createMock(ShardSpec.class);
        EasyMock.expect((Object)shard.getDomain()).andReturn((Object)ImmutableMap.of((Object)dimension, range)).anyTimes();
        return shard;
    }
}

