/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.druid.java.util.common.guava.Sequence;
import io.druid.java.util.common.guava.Sequences;
import io.druid.query.DataSource;
import io.druid.query.Druids;
import io.druid.query.Query;
import io.druid.query.QueryPlus;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerTestHelper;
import io.druid.query.TableDataSource;
import io.druid.query.UnionDataSource;
import io.druid.query.UnionQueryRunner;
import io.druid.query.timeseries.TimeseriesQuery;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.junit.Test;

public class UnionQueryRunnerTest {
    @Test
    public void testUnionQueryRunner() {
        QueryRunner baseRunner = new QueryRunner(){

            public Sequence run(QueryPlus queryPlus, Map responseContext) {
                Assert.assertTrue((boolean)(queryPlus.getQuery().getDataSource() instanceof TableDataSource));
                String dsName = (String)Iterables.getOnlyElement((Iterable)queryPlus.getQuery().getDataSource().getNames());
                if (dsName.equals("ds1")) {
                    responseContext.put("ds1", "ds1");
                    return Sequences.simple(Arrays.asList(1, 2, 3));
                }
                if (dsName.equals("ds2")) {
                    responseContext.put("ds2", "ds2");
                    return Sequences.simple(Arrays.asList(4, 5, 6));
                }
                throw new AssertionError((Object)"Unexpected DataSource");
            }
        };
        UnionQueryRunner runner = new UnionQueryRunner(baseRunner);
        TimeseriesQuery q = Druids.newTimeseriesQueryBuilder().dataSource((DataSource)new UnionDataSource(Arrays.asList(new TableDataSource("ds1"), new TableDataSource("ds2")))).intervals("2014-01-01T00:00:00Z/2015-01-01T00:00:00Z").aggregators(QueryRunnerTestHelper.commonDoubleAggregators).build();
        HashMap responseContext = Maps.newHashMap();
        Sequence result = runner.run(QueryPlus.wrap((Query)q), (Map)responseContext);
        List res = Sequences.toList((Sequence)result, (List)Lists.newArrayList());
        Assert.assertEquals(Arrays.asList(1, 2, 3, 4, 5, 6), (Object)res);
        Assert.assertEquals((int)2, (int)responseContext.size());
        Assert.assertEquals((Object)"ds1", responseContext.get("ds1"));
        Assert.assertEquals((Object)"ds2", responseContext.get("ds2"));
    }
}

