/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import io.druid.java.util.common.ISE;
import io.druid.query.QueryInterruptedException;
import io.druid.query.ResourceLimitExceededException;
import io.druid.segment.TestHelper;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;

public class QueryInterruptedExceptionTest {
    private static final ObjectMapper MAPPER = TestHelper.makeJsonMapper();

    @Test
    public void testErrorCode() {
        Assert.assertEquals((Object)"Query cancelled", (Object)new QueryInterruptedException((Throwable)new QueryInterruptedException((Throwable)new CancellationException())).getErrorCode());
        Assert.assertEquals((Object)"Query cancelled", (Object)new QueryInterruptedException((Throwable)new CancellationException()).getErrorCode());
        Assert.assertEquals((Object)"Query interrupted", (Object)new QueryInterruptedException((Throwable)new InterruptedException()).getErrorCode());
        Assert.assertEquals((Object)"Query timeout", (Object)new QueryInterruptedException((Throwable)new TimeoutException()).getErrorCode());
        Assert.assertEquals((Object)"Unknown exception", (Object)new QueryInterruptedException(null).getErrorCode());
        Assert.assertEquals((Object)"Unknown exception", (Object)new QueryInterruptedException((Throwable)new ISE("Something bad!", new Object[0])).getErrorCode());
        Assert.assertEquals((Object)"Resource limit exceeded", (Object)new QueryInterruptedException((Throwable)new ResourceLimitExceededException("too many!", new Object[0])).getErrorCode());
        Assert.assertEquals((Object)"Unknown exception", (Object)new QueryInterruptedException((Throwable)new QueryInterruptedException((Throwable)new ISE("Something bad!", new Object[0]))).getErrorCode());
    }

    @Test
    public void testErrorMessage() {
        Assert.assertEquals(null, (Object)new QueryInterruptedException((Throwable)new QueryInterruptedException((Throwable)new CancellationException())).getMessage());
        Assert.assertEquals(null, (Object)new QueryInterruptedException((Throwable)new CancellationException()).getMessage());
        Assert.assertEquals(null, (Object)new QueryInterruptedException((Throwable)new InterruptedException()).getMessage());
        Assert.assertEquals(null, (Object)new QueryInterruptedException((Throwable)new TimeoutException()).getMessage());
        Assert.assertEquals(null, (Object)new QueryInterruptedException(null).getMessage());
        Assert.assertEquals((Object)"too many!", (Object)new QueryInterruptedException((Throwable)new ResourceLimitExceededException("too many!", new Object[0])).getMessage());
        Assert.assertEquals((Object)"Something bad!", (Object)new QueryInterruptedException((Throwable)new ISE("Something bad!", new Object[0])).getMessage());
        Assert.assertEquals((Object)"Something bad!", (Object)new QueryInterruptedException((Throwable)new QueryInterruptedException((Throwable)new ISE("Something bad!", new Object[0]))).getMessage());
    }

    @Test
    public void testErrorClass() {
        Assert.assertEquals((Object)"java.util.concurrent.CancellationException", (Object)new QueryInterruptedException((Throwable)new QueryInterruptedException((Throwable)new CancellationException())).getErrorClass());
        Assert.assertEquals((Object)"java.util.concurrent.CancellationException", (Object)new QueryInterruptedException((Throwable)new CancellationException()).getErrorClass());
        Assert.assertEquals((Object)"java.lang.InterruptedException", (Object)new QueryInterruptedException((Throwable)new InterruptedException()).getErrorClass());
        Assert.assertEquals((Object)"java.util.concurrent.TimeoutException", (Object)new QueryInterruptedException((Throwable)new TimeoutException()).getErrorClass());
        Assert.assertEquals((Object)"io.druid.query.ResourceLimitExceededException", (Object)new QueryInterruptedException((Throwable)new ResourceLimitExceededException("too many!", new Object[0])).getErrorClass());
        Assert.assertEquals(null, (Object)new QueryInterruptedException(null).getErrorClass());
        Assert.assertEquals((Object)"io.druid.java.util.common.ISE", (Object)new QueryInterruptedException((Throwable)new ISE("Something bad!", new Object[0])).getErrorClass());
        Assert.assertEquals((Object)"io.druid.java.util.common.ISE", (Object)new QueryInterruptedException((Throwable)new QueryInterruptedException((Throwable)new ISE("Something bad!", new Object[0]))).getErrorClass());
    }

    @Test
    public void testHost() {
        Assert.assertEquals((Object)"myhost", (Object)new QueryInterruptedException((Throwable)new QueryInterruptedException((Throwable)new CancellationException(), "myhost")).getHost());
    }

    @Test
    public void testSerde() {
        Assert.assertEquals((Object)"Query cancelled", (Object)QueryInterruptedExceptionTest.roundTrip(new QueryInterruptedException((Throwable)new QueryInterruptedException((Throwable)new CancellationException()))).getErrorCode());
        Assert.assertEquals((Object)"java.util.concurrent.CancellationException", (Object)QueryInterruptedExceptionTest.roundTrip(new QueryInterruptedException((Throwable)new QueryInterruptedException((Throwable)new CancellationException()))).getErrorClass());
        Assert.assertEquals(null, (Object)QueryInterruptedExceptionTest.roundTrip(new QueryInterruptedException((Throwable)new QueryInterruptedException((Throwable)new CancellationException()))).getMessage());
        Assert.assertEquals((Object)"java.util.concurrent.CancellationException", (Object)QueryInterruptedExceptionTest.roundTrip(new QueryInterruptedException((Throwable)new CancellationException())).getErrorClass());
        Assert.assertEquals((Object)"java.lang.InterruptedException", (Object)QueryInterruptedExceptionTest.roundTrip(new QueryInterruptedException((Throwable)new InterruptedException())).getErrorClass());
        Assert.assertEquals((Object)"java.util.concurrent.TimeoutException", (Object)QueryInterruptedExceptionTest.roundTrip(new QueryInterruptedException((Throwable)new TimeoutException())).getErrorClass());
        Assert.assertEquals(null, (Object)QueryInterruptedExceptionTest.roundTrip(new QueryInterruptedException(null)).getErrorClass());
        Assert.assertEquals((Object)"io.druid.java.util.common.ISE", (Object)QueryInterruptedExceptionTest.roundTrip(new QueryInterruptedException((Throwable)new ISE("Something bad!", new Object[0]))).getErrorClass());
        Assert.assertEquals((Object)"io.druid.java.util.common.ISE", (Object)QueryInterruptedExceptionTest.roundTrip(new QueryInterruptedException((Throwable)new QueryInterruptedException((Throwable)new ISE("Something bad!", new Object[0])))).getErrorClass());
        Assert.assertEquals((Object)"Something bad!", (Object)QueryInterruptedExceptionTest.roundTrip(new QueryInterruptedException((Throwable)new ISE("Something bad!", new Object[0]))).getMessage());
        Assert.assertEquals((Object)"Something bad!", (Object)QueryInterruptedExceptionTest.roundTrip(new QueryInterruptedException((Throwable)new QueryInterruptedException((Throwable)new ISE("Something bad!", new Object[0])))).getMessage());
        Assert.assertEquals((Object)"Unknown exception", (Object)QueryInterruptedExceptionTest.roundTrip(new QueryInterruptedException((Throwable)new ISE("Something bad!", new Object[0]))).getErrorCode());
        Assert.assertEquals((Object)"Unknown exception", (Object)QueryInterruptedExceptionTest.roundTrip(new QueryInterruptedException((Throwable)new QueryInterruptedException((Throwable)new ISE("Something bad!", new Object[0])))).getErrorCode());
    }

    private static QueryInterruptedException roundTrip(QueryInterruptedException e) {
        try {
            return (QueryInterruptedException)MAPPER.readValue(MAPPER.writeValueAsBytes((Object)e), QueryInterruptedException.class);
        }
        catch (Exception e2) {
            throw Throwables.propagate((Throwable)e2);
        }
    }
}

