/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.unixsocket;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.jetty.HttpConnectorFactory;
import io.dropwizard.metrics.jetty11.InstrumentedConnectionFactory;
import java.nio.file.Paths;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.unixdomain.server.UnixDomainServerConnector;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ThreadPool;

@JsonTypeName(value="unix-socket")
public class UnixSocketConnectorFactory
extends HttpConnectorFactory {
    private String path = "/tmp/dropwizard.sock";

    @JsonProperty
    public String getPath() {
        return this.path;
    }

    @JsonProperty
    public void setPath(String path) {
        this.path = path;
    }

    public Connector build(Server server, MetricRegistry metrics, String name, @Nullable ThreadPool threadPool) {
        ScheduledExecutorScheduler scheduler = new ScheduledExecutorScheduler();
        ByteBufferPool bufferPool = this.buildBufferPool();
        HttpConfiguration httpConfig = this.buildHttpConfiguration();
        HttpConnectionFactory httpConnectionFactory = this.buildHttpConnectionFactory(httpConfig);
        InstrumentedConnectionFactory instrumentedConnectionFactory = new InstrumentedConnectionFactory((ConnectionFactory)httpConnectionFactory, metrics.timer(this.httpConnections()));
        UnixDomainServerConnector connector = new UnixDomainServerConnector(server, (Executor)threadPool, (Scheduler)scheduler, bufferPool, this.getAcceptorThreads().orElse(-1).intValue(), this.getSelectorThreads().orElse(-1).intValue(), new ConnectionFactory[]{instrumentedConnectionFactory});
        if (this.getAcceptQueueSize() != null) {
            connector.setAcceptQueueSize(this.getAcceptQueueSize().intValue());
        }
        connector.setUnixDomainPath(Paths.get(this.path, new String[0]));
        connector.setIdleTimeout(this.getIdleTimeout().toMilliseconds());
        connector.setName(name);
        return connector;
    }

    protected String httpConnections() {
        return MetricRegistry.name(UnixSocketConnectorFactory.class, (String[])new String[]{this.path, "connections"});
    }
}

