/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.migrations;

import io.dropwizard.core.Configuration;
import io.dropwizard.db.DatabaseConfiguration;
import io.dropwizard.migrations.AbstractLiquibaseCommand;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import liquibase.Liquibase;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;

public class DbStatusCommand<T extends Configuration>
extends AbstractLiquibaseCommand<T> {
    private PrintStream outputStream = System.out;

    public DbStatusCommand(DatabaseConfiguration<T> strategy, Class<T> configurationClass, String migrationsFileName) {
        super("status", "Check for pending change sets.", strategy, configurationClass, migrationsFileName);
    }

    void setOutputStream(PrintStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void configure(Subparser subparser) {
        super.configure(subparser);
        subparser.addArgument(new String[]{"-v", "--verbose"}).action((ArgumentAction)Arguments.storeTrue()).dest("verbose").help("Output verbose information");
        subparser.addArgument(new String[]{"-i", "--include"}).action((ArgumentAction)Arguments.append()).dest("contexts").help("include change sets from the given context");
    }

    @Override
    public void run(Namespace namespace, Liquibase liquibase) throws Exception {
        Boolean verbose = namespace.getBoolean("verbose");
        liquibase.reportStatus(verbose != null && verbose != false, this.getContext(namespace), (Writer)new OutputStreamWriter((OutputStream)this.outputStream, StandardCharsets.UTF_8));
    }

    private String getContext(Namespace namespace) {
        List contexts = namespace.getList("contexts");
        if (contexts == null) {
            return "";
        }
        return contexts.stream().map(Object::toString).collect(Collectors.joining(","));
    }
}

