/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.http2;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.jetty.HttpsConnectorFactory;
import io.dropwizard.jetty.SslReload;
import io.dropwizard.metrics.jetty10.InstrumentedConnectionFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ThreadPool;

@JsonTypeName(value="h2")
public class Http2ConnectorFactory
extends HttpsConnectorFactory {
    private static final String HTTP2_DEFAULT_CIPHER = "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256";
    @Min(value=100L)
    @Max(value=0x7FFFFFFFL)
    private @Min(value=100L) @Max(value=0x7FFFFFFFL) int maxConcurrentStreams = 1024;
    @Min(value=1L)
    @Max(value=0x7FFFFFFFL)
    private @Min(value=1L) @Max(value=0x7FFFFFFFL) int initialStreamRecvWindow = 65535;

    @JsonProperty
    public int getMaxConcurrentStreams() {
        return this.maxConcurrentStreams;
    }

    @JsonProperty
    public void setMaxConcurrentStreams(int maxConcurrentStreams) {
        this.maxConcurrentStreams = maxConcurrentStreams;
    }

    @JsonProperty
    public int getInitialStreamRecvWindow() {
        return this.initialStreamRecvWindow;
    }

    @JsonProperty
    public void setInitialStreamRecvWindow(int initialStreamRecvWindow) {
        this.initialStreamRecvWindow = initialStreamRecvWindow;
    }

    public Connector build(Server server, MetricRegistry metrics, String name, @Nullable ThreadPool threadPool) {
        this.setSupportedProtocols(Arrays.asList("TLSv1.3", "TLSv1.2"));
        this.checkSupportedCipherSuites();
        HttpConfiguration httpConfig = this.buildHttpConfiguration();
        HttpConnectionFactory http1 = this.buildHttpConnectionFactory(httpConfig);
        HTTP2ServerConnectionFactory http2 = new HTTP2ServerConnectionFactory(httpConfig);
        http2.setMaxConcurrentStreams(this.maxConcurrentStreams);
        http2.setInitialStreamRecvWindow(this.initialStreamRecvWindow);
        ALPNServerConnectionFactory alpn = new ALPNServerConnectionFactory(new String[0]);
        alpn.setDefaultProtocol("http/1.1");
        SslContextFactory.Server sslContextFactory = this.configureSslContextFactory((SslContextFactory)new SslContextFactory.Server());
        sslContextFactory.addEventListener((EventListener)this.logSslParameters((SslContextFactory)sslContextFactory));
        server.addBean((Object)sslContextFactory);
        server.addBean((Object)new SslReload((SslContextFactory)sslContextFactory, arg_0 -> ((Http2ConnectorFactory)this).configureSslContextFactory(arg_0)));
        SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(sslContextFactory, "alpn");
        return this.buildConnector(server, (Scheduler)new ScheduledExecutorScheduler(), this.buildBufferPool(), name, threadPool, new ConnectionFactory[]{new InstrumentedConnectionFactory((ConnectionFactory)sslConnectionFactory, metrics.timer(this.httpConnections())), alpn, http2, http1});
    }

    void checkSupportedCipherSuites() {
        if (this.getSupportedCipherSuites() == null) {
            this.setSupportedCipherSuites(Collections.singletonList(HTTP2_DEFAULT_CIPHER));
        } else if (!this.getSupportedCipherSuites().contains(HTTP2_DEFAULT_CIPHER)) {
            throw new IllegalArgumentException("HTTP/2 server configuration must include cipher: TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256");
        }
    }
}

