/*
 * Decompiled with CFR 0.152.
 */
package io.docops.asciidoc.buttons.theme;

import io.docops.asciidoc.buttons.models.Button;
import io.docops.asciidoc.buttons.theme.ButtonType;
import io.docops.asciidoc.buttons.theme.Grouping;
import io.docops.asciidoc.buttons.theme.GroupingOrder;
import io.docops.asciidoc.buttons.theme.ThemeDSL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@ThemeDSL
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 D2\u00020\u0001:\u0001DB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010;\u001a\u00020\u00052\u0006\u0010<\u001a\u00020=J\u000e\u0010>\u001a\u00020\u00052\u0006\u0010<\u001a\u00020=J\u0011\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u0005H\u0086\u0004J\r\u0010B\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\bCR \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010&\"\u0004\b+\u0010(R\u001a\u0010,\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010&\"\u0004\b.\u0010(R\u001a\u0010/\u001a\u000200X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R&\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000506X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:\u00a8\u0006E"}, d2={"Lio/docops/asciidoc/buttons/theme/Theme;", "", "()V", "colorMap", "", "", "getColorMap", "()Ljava/util/List;", "setColorMap", "(Ljava/util/List;)V", "columns", "", "getColumns", "()I", "setColumns", "(I)V", "defs", "getDefs", "()Ljava/lang/String;", "setDefs", "(Ljava/lang/String;)V", "fontWeight", "getFontWeight", "setFontWeight", "groupBy", "Lio/docops/asciidoc/buttons/theme/Grouping;", "getGroupBy", "()Lio/docops/asciidoc/buttons/theme/Grouping;", "setGroupBy", "(Lio/docops/asciidoc/buttons/theme/Grouping;)V", "groupOrder", "Lio/docops/asciidoc/buttons/theme/GroupingOrder;", "getGroupOrder", "()Lio/docops/asciidoc/buttons/theme/GroupingOrder;", "setGroupOrder", "(Lio/docops/asciidoc/buttons/theme/GroupingOrder;)V", "isPDF", "", "()Z", "setPDF", "(Z)V", "legendOn", "getLegendOn", "setLegendOn", "newWin", "getNewWin", "setNewWin", "type", "Lio/docops/asciidoc/buttons/theme/ButtonType;", "getType", "()Lio/docops/asciidoc/buttons/theme/ButtonType;", "setType", "(Lio/docops/asciidoc/buttons/theme/ButtonType;)V", "typeMap", "", "getTypeMap", "()Ljava/util/Map;", "setTypeMap", "(Ljava/util/Map;)V", "buttonColor", "button", "Lio/docops/asciidoc/buttons/models/Button;", "buttonTextColor", "typeIs", "", "other", "validate", "validate$docops_button_render", "Companion", "docops.button-render"})
public final class Theme {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int columns = 3;
    @NotNull
    private List<String> colorMap;
    @NotNull
    private Grouping groupBy;
    @NotNull
    private GroupingOrder groupOrder;
    @NotNull
    private String fontWeight;
    @NotNull
    private ButtonType type;
    private boolean newWin;
    private boolean legendOn;
    private boolean isPDF;
    @NotNull
    private String defs;
    @NotNull
    private Map<String, String> typeMap;
    @NotNull
    private static final List<String> fontWeights;

    public Theme() {
        Object[] objectArray = new String[]{"url(#linear-gradient-0)", "url(#linear-gradient-1)", "url(#linear-gradient-2)", "url(#linear-gradient-3)", "url(#linear-gradient-4)", "url(#linear-gradient-5)"};
        this.colorMap = CollectionsKt.listOf((Object[])objectArray);
        this.groupBy = Grouping.DATE;
        this.groupOrder = GroupingOrder.ASCENDING;
        this.fontWeight = "normal";
        this.type = ButtonType.BUTTON;
        this.newWin = true;
        this.legendOn = true;
        this.defs = "";
        this.typeMap = new LinkedHashMap();
    }

    public final int getColumns() {
        return this.columns;
    }

    public final void setColumns(int n) {
        this.columns = n;
    }

    @NotNull
    public final List<String> getColorMap() {
        return this.colorMap;
    }

    public final void setColorMap(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.colorMap = list;
    }

    @NotNull
    public final Grouping getGroupBy() {
        return this.groupBy;
    }

    public final void setGroupBy(@NotNull Grouping grouping) {
        Intrinsics.checkNotNullParameter((Object)((Object)grouping), (String)"<set-?>");
        this.groupBy = grouping;
    }

    @NotNull
    public final GroupingOrder getGroupOrder() {
        return this.groupOrder;
    }

    public final void setGroupOrder(@NotNull GroupingOrder groupingOrder) {
        Intrinsics.checkNotNullParameter((Object)((Object)groupingOrder), (String)"<set-?>");
        this.groupOrder = groupingOrder;
    }

    @NotNull
    public final String getFontWeight() {
        return this.fontWeight;
    }

    public final void setFontWeight(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.fontWeight = string;
    }

    @NotNull
    public final ButtonType getType() {
        return this.type;
    }

    public final void setType(@NotNull ButtonType buttonType) {
        Intrinsics.checkNotNullParameter((Object)((Object)buttonType), (String)"<set-?>");
        this.type = buttonType;
    }

    public final boolean getNewWin() {
        return this.newWin;
    }

    public final void setNewWin(boolean bl) {
        this.newWin = bl;
    }

    public final boolean getLegendOn() {
        return this.legendOn;
    }

    public final void setLegendOn(boolean bl) {
        this.legendOn = bl;
    }

    public final boolean isPDF() {
        return this.isPDF;
    }

    public final void setPDF(boolean bl) {
        this.isPDF = bl;
    }

    @NotNull
    public final String getDefs() {
        return this.defs;
    }

    public final void setDefs(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.defs = string;
    }

    @NotNull
    public final Map<String, String> getTypeMap() {
        return this.typeMap;
    }

    public final void setTypeMap(@NotNull Map<String, String> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.typeMap = map;
    }

    public final void typeIs(@NotNull String other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        this.type = ButtonType.valueOf(other);
    }

    @NotNull
    public final Theme validate$docops_button_render() {
        if (!fontWeights.contains(this.fontWeight)) {
            boolean bl = false;
            String string = Intrinsics.stringPlus((String)"not a valid font weight ", (Object)this.getFontWeight());
            throw new IllegalArgumentException(string.toString());
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String buttonColor(@NotNull Button button) {
        String string;
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        String string2 = button.getBackgroundColor();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            return it;
        }
        String col = this.typeMap.get(button.getType());
        if (col == null) {
            void var3_7;
            String color = this.colorMap.get(this.typeMap.size() % this.colorMap.size());
            Map<String, String> map = this.typeMap;
            String string3 = button.getType();
            map.put(string3, color);
            string = var3_7;
        } else {
            string = col;
        }
        return string;
    }

    @NotNull
    public final String buttonTextColor(@NotNull Button button) {
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        String string = button.getForegroundColor();
        if (string != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        return "white";
    }

    static {
        Object[] objectArray = new String[]{"bold", "normal", "italic"};
        fontWeights = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/docops/asciidoc/buttons/theme/Theme$Companion;", "", "()V", "fontWeights", "", "", "docops.button-render"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

