/*
 * Decompiled with CFR 0.152.
 */
package io.docops.asciidoc.buttons;

import io.docops.asciidoc.buttons.ButtonMaker;
import io.docops.asciidoc.buttons.models.Button;
import io.docops.asciidoc.buttons.models.ButtonImage;
import io.docops.asciidoc.buttons.models.ButtonKt;
import io.docops.asciidoc.buttons.theme.Theme;
import io.docops.asciidoc.utils.StringFunctionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\f\u001a\u00020\u00042\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\u000e\u001a\u00020\u00042\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u0010\u001a\u00020\u0004H\u0002\u00a8\u0006\u0011"}, d2={"Lio/docops/asciidoc/buttons/LargeCard;", "Lio/docops/asciidoc/buttons/ButtonMaker;", "()V", "drawButtonRow", "", "rowCount", "", "row", "", "Lio/docops/asciidoc/buttons/models/Button;", "theme", "Lio/docops/asciidoc/buttons/theme/Theme;", "drawButtons", "buttonList", "makeButtons", "buttons", "makeStyles", "docops.button-render"})
public final class LargeCard
extends ButtonMaker {
    @Override
    @NotNull
    public String makeButtons(@NotNull List<List<Button>> buttons, @NotNull Theme theme) {
        Intrinsics.checkNotNullParameter(buttons, (String)"buttons");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        StringBuilder sb = new StringBuilder(this.makeSvgHead(buttons, 410, 500, 300, theme));
        sb.append(this.makeDefs(theme));
        sb.append(this.makeStyles());
        sb.append(this.drawButtons(buttons, theme));
        if (theme.getLegendOn()) {
            sb.append(this.drawLegend(this.getTypes()));
        }
        sb.append(this.makeSvgEnd());
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String drawButtons(List<List<Button>> buttonList, Theme theme) {
        StringBuilder sb = new StringBuilder();
        Iterable $this$forEachIndexed$iv = buttonList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void buttons;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv;
            int index = n;
            boolean bl = false;
            sb.append(this.drawButtonRow(index, (List<Button>)buttons, theme));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String drawButtonRow(int rowCount, List<Button> row, Theme theme) {
        StringBuilder sb = new StringBuilder("<svg>");
        int recXpos = 0;
        recXpos = 10;
        int yPos = 0;
        yPos = 10;
        int dateXpos = 0;
        dateXpos = 95;
        if (rowCount > 0) {
            yPos = rowCount * 410 + 10;
        }
        Iterable $this$forEachIndexed$iv = row;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void button;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Button button2 = (Button)item$iv;
            int index = n;
            boolean bl = false;
            if (index > 0) {
                recXpos += 320;
                dateXpos += 320;
            }
            String win = "_blank";
            if (!theme.getNewWin()) {
                win = "_top";
            }
            List<StringBuilder> lines = StringFunctionsKt.addLinebreaks(button.getDescription(), 41);
            String imgOrRec = null;
            imgOrRec = "";
            if (button.getBase64Image() != null) {
                ButtonImage it;
                boolean bl2 = false;
                imgOrRec = "data:" + it.getType() + ";base64," + it.getBase64Str();
            }
            if (button.getBase64Image() != null) {
                ButtonImage img = button.getBase64Image();
                if (img != null) {
                    boolean bl3 = false;
                    imgOrRec = StringsKt.trimIndent((String)("\n                        <image x=\"" + recXpos + "\" y=\"" + yPos + "\" width=\"300\" height=\"191\" href=\"data:image/png;base64, " + img.getBase64Str() + "\"/>"));
                }
            } else {
                imgOrRec = StringsKt.trimIndent((String)("\n                    <use x=\"" + recXpos + "\" y=\"" + yPos + "\" fill=\"" + theme.buttonColor((Button)button) + "\" xlink:href=\"#myLargerHeroRect\"/>\n                    "));
            }
            if (theme.isPDF()) {
                sb.append(StringsKt.trimIndent((String)("\n                   <use x=\"" + recXpos + "\" y=\"" + yPos + "\" xlink:href=\"#myLargeRect\"><title class=\"description\">" + ButtonKt.escapeXml(button.getDescription()) + "</title></use>     \n                   " + imgOrRec + "\n                ")));
            } else {
                sb.append(StringsKt.trimIndent((String)("\n                    <a xlink:href=\"" + button.getLink() + "\" target=\"" + win + "\">\n                    <use x=\"" + recXpos + "\" y=\"" + yPos + "\" xlink:href=\"#myLargeRect\"><title class=\"description\">" + ButtonKt.escapeXml(button.getDescription()) + "</title></use>    \n                   " + imgOrRec + "\n                   </a>\n                ")));
            }
            StringBuilder authors = new StringBuilder();
            Iterable $this$forEach$iv = button.getAuthors();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl4 = false;
                authors.append("<tspan x=\"" + (recXpos + 10) + "\" dy=\"18\" class=\"author\">" + ButtonKt.escapeXml(it) + "</tspan>");
            }
            sb.append("\n                <text x=\"" + (recXpos + 10) + "\" y=\"" + (yPos + 220) + "\" class=\"headline\">" + ButtonKt.escapeXml(button.getType()) + "</text>\n                <text x=\"" + (recXpos + 10) + "\" y=\"" + (yPos + 240) + "\" class=\"longdesc\">\n                ");
            if (theme.isPDF()) {
                sb.append("<tspan class=\"link\" text-decoration=\"underline\" fill=\"#335D79\">" + ButtonKt.escapeXml(button.getTitle()) + "</tspan>");
            } else {
                sb.append("<tspan class=\"link\" text-decoration=\"underline\"><a href=\"" + button.getLink() + "\" fill=\"#335D79\" target=\"" + win + "\">" + ButtonKt.escapeXml(button.getTitle()) + "</a></tspan>");
            }
            sb.append(((Object)StringsKt.trimEnd((CharSequence)("\n                    " + authors + "\n                    <tspan x=\"" + (recXpos + 10) + "\" dy=\"18\" class=\"date\">" + ButtonKt.escapeXml(button.getDate()) + "</tspan>\n            "))).toString());
            Iterable $this$forEachIndexed$iv2 = lines;
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv2) {
                void str;
                int n2 = index$iv2;
                index$iv2 = n2 + 1;
                if (n2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                StringBuilder stringBuilder = (StringBuilder)item$iv2;
                int i = n2;
                boolean bl5 = false;
                if (i >= 6) continue;
                StringBuilder stringBuilder2 = new StringBuilder().append("\n                <tspan x=\"").append(recXpos + 10).append("\" dy=\"18\" class=\"longdesc\">\n                    ");
                String string = str.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"str.toString()");
                sb.append(StringsKt.trimIndent((String)stringBuilder2.append(ButtonKt.escapeXml(string)).append("\n                </tspan>\n                ").toString()));
            }
            sb.append("</text>");
        }
        sb.append("</svg>");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    private final String makeStyles() {
        return "        <style>\n    rect.card {\n        pointer-events: bounding-box;\n        opacity: 01;\n    }\n    rect.card:hover {\n        opacity: 0.6;\n    }\n    .headline {\n        font: bold 18px \"Noto Sans\",sans-serif;;\n        fill: #46494d;\n    }\n    .link {\n        font: bold 12px \"Noto Sans\",sans-serif;;\n        fill: #335D79;\n    }\n    .description {\n        font: normal 12px \"Noto Sans\",sans-serif;\n    }\n    .longdesc {\n        font: normal 11px \"Noto Sans\",sans-serif;\n    }\n</style>";
    }
}

