/*
 * Decompiled with CFR 0.152.
 */
package io.docops.asciidoc.buttons;

import io.docops.asciidoc.buttons.ButtonCardRenderer;
import io.docops.asciidoc.buttons.ButtonRenderer;
import io.docops.asciidoc.buttons.LargeCard;
import io.docops.asciidoc.buttons.RoundButtonItemRenderer;
import io.docops.asciidoc.buttons.SlimCardRenderer;
import io.docops.asciidoc.buttons.models.Button;
import io.docops.asciidoc.buttons.theme.ButtonType;
import io.docops.asciidoc.buttons.theme.Grouping;
import io.docops.asciidoc.buttons.theme.GroupingOrder;
import io.docops.asciidoc.buttons.theme.Theme;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\f\u001a\u00020\r2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J*\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lio/docops/asciidoc/buttons/ButtonRenderImpl;", "Lio/docops/asciidoc/buttons/ButtonRenderer;", "()V", "groupButtons", "", "buttons", "", "Lio/docops/asciidoc/buttons/models/Button;", "groupBy", "Lio/docops/asciidoc/buttons/theme/Grouping;", "groupOrder", "Lio/docops/asciidoc/buttons/theme/GroupingOrder;", "render", "", "theme", "Lio/docops/asciidoc/buttons/theme/Theme;", "toRows", "cols", "", "docops.button-render"})
public final class ButtonRenderImpl
implements ButtonRenderer {
    @Override
    @NotNull
    public String render(@NotNull List<Button> buttons, @NotNull Theme theme) {
        String string;
        Intrinsics.checkNotNullParameter(buttons, (String)"buttons");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.groupButtons(buttons, theme.getGroupBy(), theme.getGroupOrder());
        List<List<Button>> rows = this.toRows(buttons, theme.getColumns());
        switch (WhenMappings.$EnumSwitchMapping$0[theme.getType().ordinal()]) {
            case 1: {
                string = new SlimCardRenderer().makeButtons(rows, theme);
                break;
            }
            case 2: {
                string = new RoundButtonItemRenderer().makeButtons(rows, theme);
                break;
            }
            case 3: {
                string = new ButtonCardRenderer().makeButtons(rows, theme);
                break;
            }
            case 4: {
                string = new LargeCard().makeButtons(rows, theme);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final List<List<Button>> toRows(List<Button> buttons, int cols) {
        List rows = new ArrayList();
        List rowArray = null;
        rowArray = new ArrayList();
        rows.add(rowArray);
        Iterable $this$forEach$iv = buttons;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Button it = (Button)element$iv;
            boolean bl = false;
            if (rowArray.size() == cols) {
                rowArray = new ArrayList();
                rows.add(rowArray);
            }
            rowArray.add(it);
        }
        return rows;
    }

    private final void groupButtons(List<Button> buttons, Grouping groupBy, GroupingOrder groupOrder) {
        switch (WhenMappings.$EnumSwitchMapping$1[groupBy.ordinal()]) {
            case 1: {
                if (WhenMappings.$EnumSwitchMapping$2[groupOrder.ordinal()] == 1) {
                    List<Button> $this$sortByDescending$iv = buttons;
                    boolean $i$f$sortByDescending = false;
                    if ($this$sortByDescending$iv.size() <= 1) break;
                    CollectionsKt.sortWith($this$sortByDescending$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            Button it = (Button)b;
                            boolean bl = false;
                            Comparable comparable = (Comparable)((Object)it.getType());
                            it = (Button)a;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getType())));
                        }
                    });
                    break;
                }
                List<Button> $this$sortBy$iv = buttons;
                boolean $i$f$sortBy = false;
                if ($this$sortBy$iv.size() <= 1) break;
                CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Button it = (Button)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getType());
                        it = (Button)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getType())));
                    }
                });
                break;
            }
            case 2: {
                if (WhenMappings.$EnumSwitchMapping$2[groupOrder.ordinal()] == 1) {
                    List<Button> $this$sortByDescending$iv = buttons;
                    boolean $i$f$sortByDescending = false;
                    if ($this$sortByDescending$iv.size() <= 1) break;
                    CollectionsKt.sortWith($this$sortByDescending$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            Button it = (Button)b;
                            boolean bl = false;
                            Comparable comparable = (Comparable)((Object)it.getAuthors().get(0));
                            it = (Button)a;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getAuthors().get(0))));
                        }
                    });
                    break;
                }
                List<Button> $this$sortBy$iv = buttons;
                boolean $i$f$sortBy = false;
                if ($this$sortBy$iv.size() <= 1) break;
                CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Button it = (Button)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getAuthors().get(0));
                        it = (Button)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getAuthors().get(0))));
                    }
                });
                break;
            }
            case 3: {
                if (WhenMappings.$EnumSwitchMapping$2[groupOrder.ordinal()] == 1) {
                    List<Button> $this$sortByDescending$iv = buttons;
                    boolean $i$f$sortByDescending = false;
                    if ($this$sortByDescending$iv.size() <= 1) break;
                    CollectionsKt.sortWith($this$sortByDescending$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            Button it = (Button)b;
                            boolean bl = false;
                            Comparable comparable = (Comparable)((Object)it.getTitle());
                            it = (Button)a;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getTitle())));
                        }
                    });
                    break;
                }
                List<Button> $this$sortBy$iv = buttons;
                boolean $i$f$sortBy = false;
                if ($this$sortBy$iv.size() <= 1) break;
                CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Button it = (Button)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getTitle());
                        it = (Button)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getTitle())));
                    }
                });
                break;
            }
            case 4: {
                if (groupOrder == GroupingOrder.ASCENDING) {
                    List<Button> $this$sortBy$iv = buttons;
                    boolean $i$f$sortBy = false;
                    if ($this$sortBy$iv.size() <= 1) break;
                    CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            Button it = (Button)a;
                            boolean bl = false;
                            Comparable comparable = it.dateFromStr();
                            it = (Button)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.dateFromStr());
                        }
                    });
                    break;
                }
                List<Button> $this$sortByDescending$iv = buttons;
                boolean $i$f$sortByDescending = false;
                if ($this$sortByDescending$iv.size() <= 1) break;
                CollectionsKt.sortWith($this$sortByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Button it = (Button)b;
                        boolean bl = false;
                        Comparable comparable = it.dateFromStr();
                        it = (Button)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.dateFromStr());
                    }
                });
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[ButtonType.values().length];
            nArray[ButtonType.SLIM_CARD.ordinal()] = 1;
            nArray[ButtonType.ROUND.ordinal()] = 2;
            nArray[ButtonType.BUTTON.ordinal()] = 3;
            nArray[ButtonType.LARGE_CARD.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Grouping.values().length];
            nArray[Grouping.TYPE.ordinal()] = 1;
            nArray[Grouping.AUTHOR.ordinal()] = 2;
            nArray[Grouping.TITLE.ordinal()] = 3;
            nArray[Grouping.DATE.ordinal()] = 4;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[GroupingOrder.values().length];
            nArray[GroupingOrder.DESCENDING.ordinal()] = 1;
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

