/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service.util;

import io.dingodb.common.Common;
import io.dingodb.index.Index;
import io.dingodb.sdk.common.DingoCommonId;
import io.dingodb.sdk.common.Location;
import io.dingodb.sdk.common.SDKCommonId;
import io.dingodb.sdk.common.table.RangeDistribution;
import io.dingodb.sdk.common.utils.EntityConversion;
import io.dingodb.sdk.common.vector.VectorCalcDistance;
import io.dingodb.sdk.common.vector.VectorDistance;
import io.dingodb.sdk.common.vector.VectorDistanceRes;
import io.dingodb.sdk.service.connector.UtilServiceConnector;
import io.dingodb.sdk.service.meta.MetaServiceClient;
import io.dingodb.util.UtilServiceGrpc;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class UtilServiceClient {
    private final Map<DingoCommonId, UtilServiceConnector> connectorCache = new ConcurrentHashMap<DingoCommonId, UtilServiceConnector>();
    private final MetaServiceClient rootMetaService;
    private Integer retryTimes;

    public UtilServiceClient(MetaServiceClient rootMetaService) {
        this(rootMetaService, 20);
    }

    public UtilServiceClient(MetaServiceClient rootMetaService, Integer retryTimes) {
        this.rootMetaService = rootMetaService;
        this.retryTimes = retryTimes;
    }

    private Supplier<Location> locationSupplier(DingoCommonId schemaId, DingoCommonId indexId, DingoCommonId regionId) {
        return () -> this.rootMetaService.getSubMetaService(schemaId).getIndexRangeDistribution(indexId).values().stream().filter(rd -> rd.getId().equals(regionId)).findAny().map(RangeDistribution::getLeader).orElse(null);
    }

    public UtilServiceConnector getIndexStoreConnector(DingoCommonId indexId, DingoCommonId regionId) {
        SDKCommonId schemaId = new SDKCommonId(DingoCommonId.Type.ENTITY_TYPE_INDEX, this.rootMetaService.id().getEntityId(), indexId.parentId());
        return this.connectorCache.computeIfAbsent(regionId, __ -> new UtilServiceConnector(this.locationSupplier(schemaId, indexId, regionId)));
    }

    public void shutdown() {
        this.connectorCache.clear();
    }

    public VectorDistanceRes vectorCalcDistance(DingoCommonId indexId, DingoCommonId regionId, VectorCalcDistance distance) {
        Index.VectorCalcDistanceRequest request = Index.VectorCalcDistanceRequest.newBuilder().setAlgorithmType(Index.AlgorithmType.valueOf(distance.getAlgorithmType().name())).setMetricType(Common.MetricType.valueOf(distance.getMetricType().name())).addAllOpLeftVectors(distance.getLeftVectors().stream().map(EntityConversion::mapping).collect(Collectors.toList())).addAllOpRightVectors(distance.getRightVectors().stream().map(EntityConversion::mapping).collect(Collectors.toList())).setIsReturnNormlize(distance.getIsReturnNormalize()).build();
        Index.VectorCalcDistanceResponse response = this.exec(stub -> stub.vectorCalcDistance(request), this.retryTimes, indexId, regionId);
        return new VectorDistanceRes(response.getOpLeftVectorsList().stream().map(EntityConversion::mapping).collect(Collectors.toList()), response.getOpRightVectorsList().stream().map(EntityConversion::mapping).collect(Collectors.toList()), response.getDistancesList().stream().map(d -> new VectorDistance(d.getInternalDistancesList())).collect(Collectors.toList()));
    }

    private <R> R exec(Function<UtilServiceGrpc.UtilServiceBlockingStub, R> function, int retryTimes, DingoCommonId indexId, DingoCommonId regionId) {
        return this.getIndexStoreConnector(indexId, regionId).exec(function, retryTimes);
    }
}

