/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service.store;

import com.google.protobuf.ByteString;
import io.dingodb.common.Common;
import io.dingodb.sdk.common.Context;
import io.dingodb.sdk.common.DingoCommonId;
import io.dingodb.sdk.common.KeyValue;
import io.dingodb.sdk.common.KeyValueWithExpect;
import io.dingodb.sdk.common.Location;
import io.dingodb.sdk.common.Range;
import io.dingodb.sdk.common.RangeWithOptions;
import io.dingodb.sdk.common.SDKCommonId;
import io.dingodb.sdk.common.table.RangeDistribution;
import io.dingodb.sdk.common.utils.EntityConversion;
import io.dingodb.sdk.common.utils.ErrorCodeUtils;
import io.dingodb.sdk.common.utils.StackTraces;
import io.dingodb.sdk.service.connector.StoreServiceConnector;
import io.dingodb.sdk.service.meta.MetaServiceClient;
import io.dingodb.sdk.service.store.Coprocessor;
import io.dingodb.sdk.service.store.ScanIterator;
import io.dingodb.store.Store;
import io.dingodb.store.StoreServiceGrpc;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreServiceClient {
    private static final Logger log = LoggerFactory.getLogger(StoreServiceClient.class);
    private final Map<DingoCommonId, StoreServiceConnector> connectorCache = new ConcurrentHashMap<DingoCommonId, StoreServiceConnector>();
    private final Map<DingoCommonId, Context> contextCache = new ConcurrentHashMap<DingoCommonId, Context>();
    private final MetaServiceClient rootMetaService;
    private Integer retryTimes;

    public StoreServiceClient(MetaServiceClient rootMetaService) {
        this(rootMetaService, 20);
    }

    public StoreServiceClient(MetaServiceClient rootMetaService, Integer retryTimes) {
        this.rootMetaService = rootMetaService;
        this.retryTimes = retryTimes;
    }

    private Supplier<Location> locationSupplier(DingoCommonId schemaId, DingoCommonId tableId, DingoCommonId regionId) {
        if (tableId.type() == DingoCommonId.Type.ENTITY_TYPE_TABLE) {
            return () -> this.rootMetaService.getSubMetaService(schemaId).getRangeDistribution(tableId).values().stream().filter(rd -> rd.getId().equals(regionId)).findAny().map(this::cacheRangeEpoch).map(RangeDistribution::getLeader).orElse(null);
        }
        if (tableId.type() == DingoCommonId.Type.ENTITY_TYPE_INDEX) {
            return () -> this.rootMetaService.getSubMetaService(schemaId).getIndexRangeDistribution(tableId).values().stream().filter(rd -> rd.getId().equals(regionId)).findAny().map(this::cacheRangeEpoch).map(RangeDistribution::getLeader).orElse(null);
        }
        return null;
    }

    private RangeDistribution cacheRangeEpoch(RangeDistribution rangeDistribution) {
        Context context = this.contextCache.get(rangeDistribution.getId());
        if (context != null && !context.getRegionEpoch().equals(rangeDistribution.getRegionEpoch())) {
            context.setRegionEpoch(rangeDistribution.getRegionEpoch());
        } else {
            this.contextCache.put(rangeDistribution.getId(), new Context(rangeDistribution.getId(), rangeDistribution.getRegionEpoch()));
        }
        return rangeDistribution;
    }

    public StoreServiceConnector getStoreConnector(DingoCommonId tableId, DingoCommonId regionId) {
        SDKCommonId schemaId = new SDKCommonId(DingoCommonId.Type.ENTITY_TYPE_SCHEMA, this.rootMetaService.id().getEntityId(), tableId.parentId());
        return this.connectorCache.computeIfAbsent(regionId, __ -> new StoreServiceConnector(this.locationSupplier(schemaId, tableId, regionId)));
    }

    public void shutdown() {
        this.connectorCache.clear();
        this.contextCache.clear();
    }

    public byte[] kvGet(DingoCommonId tableId, DingoCommonId regionId, byte[] key) {
        Store.KvGetRequest.Builder builder = Store.KvGetRequest.newBuilder().setKey(ByteString.copyFrom((byte[])key));
        return this.exec(stub -> stub.kvGet(builder.setContext(EntityConversion.mapping(this.contextCache.get(regionId))).build()), this.retryTimes, tableId, regionId).getValue().toByteArray();
    }

    public List<KeyValue> kvBatchGet(DingoCommonId tableId, DingoCommonId regionId, List<byte[]> keys) {
        Store.KvBatchGetRequest.Builder builder = Store.KvBatchGetRequest.newBuilder().addAllKeys(keys.stream().map(ByteString::copyFrom).collect(Collectors.toList()));
        return this.exec(stub -> stub.kvBatchGet(builder.setContext(EntityConversion.mapping(this.contextCache.get(regionId))).build()), this.retryTimes, tableId, regionId).getKvsList().stream().map(EntityConversion::mapping).collect(Collectors.toList());
    }

    public Iterator<KeyValue> scan(DingoCommonId tableId, DingoCommonId regionId, Range range, boolean withStart, boolean withEnd) {
        return this.scan(tableId, regionId, range, withStart, withEnd, null);
    }

    public Iterator<KeyValue> scan(DingoCommonId tableId, DingoCommonId regionId, Range range, boolean withStart, boolean withEnd, Coprocessor coprocessor) {
        return new ScanIterator(this.getStoreConnector(tableId, regionId), () -> this.contextCache.get(regionId), Common.RangeWithOptions.newBuilder().setRange(Common.Range.newBuilder().setStartKey(ByteString.copyFrom((byte[])range.getStartKey())).setEndKey(ByteString.copyFrom((byte[])range.getEndKey())).build()).setWithStart(withStart).setWithEnd(withEnd).build(), false, this.retryTimes, coprocessor);
    }

    public boolean kvPut(DingoCommonId tableId, DingoCommonId regionId, KeyValue keyValue) {
        Store.KvPutRequest.Builder builder = Store.KvPutRequest.newBuilder().setKv(EntityConversion.mapping(keyValue));
        this.exec(stub -> stub.kvPut(builder.setContext(EntityConversion.mapping(this.contextCache.get(regionId))).build()), this.retryTimes, tableId, regionId);
        return true;
    }

    public boolean kvBatchPut(DingoCommonId tableId, DingoCommonId regionId, List<KeyValue> keyValues) {
        Store.KvBatchPutRequest.Builder builder = Store.KvBatchPutRequest.newBuilder().addAllKvs(keyValues.stream().map(EntityConversion::mapping).collect(Collectors.toList()));
        this.exec(stub -> stub.kvBatchPut(builder.setContext(EntityConversion.mapping(this.contextCache.get(regionId))).build()), this.retryTimes, tableId, regionId);
        return true;
    }

    public boolean kvPutIfAbsent(DingoCommonId tableId, DingoCommonId regionId, KeyValue keyValue) {
        Store.KvPutIfAbsentRequest.Builder builder = Store.KvPutIfAbsentRequest.newBuilder().setKv(EntityConversion.mapping(keyValue));
        return this.exec(stub -> stub.kvPutIfAbsent(builder.setContext(EntityConversion.mapping(this.contextCache.get(regionId))).build()), this.retryTimes, tableId, regionId).getKeyState();
    }

    public List<Boolean> kvBatchPutIfAbsent(DingoCommonId tableId, DingoCommonId regionId, List<KeyValue> keyValues) {
        return this.kvBatchPutIfAbsent(tableId, regionId, keyValues, false);
    }

    public List<Boolean> kvBatchPutIfAbsent(DingoCommonId tableId, DingoCommonId regionId, List<KeyValue> keyValues, boolean isAtomic) {
        Store.KvBatchPutIfAbsentRequest.Builder builder = Store.KvBatchPutIfAbsentRequest.newBuilder().addAllKvs(keyValues.stream().map(EntityConversion::mapping).collect(Collectors.toList())).setIsAtomic(isAtomic);
        return this.exec(stub -> stub.kvBatchPutIfAbsent(builder.setContext(EntityConversion.mapping(this.contextCache.get(regionId))).build()), this.retryTimes, tableId, regionId).getKeyStatesList();
    }

    public List<Boolean> kvBatchDelete(DingoCommonId tableId, DingoCommonId regionId, List<byte[]> keys) {
        Store.KvBatchDeleteRequest.Builder builder = Store.KvBatchDeleteRequest.newBuilder().addAllKeys(keys.stream().map(ByteString::copyFrom).collect(Collectors.toList()));
        return this.exec(stub -> stub.kvBatchDelete(builder.setContext(EntityConversion.mapping(this.contextCache.get(regionId))).build()), this.retryTimes, tableId, regionId).getKeyStatesList();
    }

    public long kvDeleteRange(DingoCommonId tableId, DingoCommonId regionId, RangeWithOptions range) {
        Store.KvDeleteRangeRequest.Builder builder = Store.KvDeleteRangeRequest.newBuilder().setRange(EntityConversion.mapping(range));
        return this.exec(stub -> stub.kvDeleteRange(builder.setContext(EntityConversion.mapping(this.contextCache.get(regionId))).build()), this.retryTimes, tableId, regionId).getDeleteCount();
    }

    public boolean kvCompareAndSet(DingoCommonId tableId, DingoCommonId regionId, KeyValueWithExpect keyValue) {
        Store.KvCompareAndSetRequest.Builder builder = Store.KvCompareAndSetRequest.newBuilder().setKv(EntityConversion.mapping(keyValue)).setExpectValue(ByteString.copyFrom((byte[])keyValue.expect));
        return this.exec(stub -> stub.kvCompareAndSet(builder.setContext(EntityConversion.mapping(this.contextCache.get(regionId))).build()), this.retryTimes, tableId, regionId).getKeyState();
    }

    public List<Boolean> kvBatchCompareAndSet(DingoCommonId tableId, DingoCommonId regionId, List<KeyValueWithExpect> keyValues, boolean isAtomic) {
        ArrayList kvs = new ArrayList();
        ArrayList expects = new ArrayList();
        keyValues.stream().peek(__ -> kvs.add(EntityConversion.mapping(__))).forEach(__ -> expects.add(ByteString.copyFrom((byte[])__.expect)));
        Store.KvBatchCompareAndSetRequest.Builder builder = Store.KvBatchCompareAndSetRequest.newBuilder().addAllKvs(kvs).addAllExpectValues(expects).setIsAtomic(isAtomic);
        return this.exec(stub -> stub.kvBatchCompareAndSet(builder.setContext(EntityConversion.mapping(this.contextCache.get(regionId))).build()), this.retryTimes, tableId, regionId).getKeyStatesList();
    }

    private <R> R exec(Function<StoreServiceGrpc.StoreServiceBlockingStub, R> function, int retryTimes, DingoCommonId tableId, DingoCommonId regionId) {
        String stack = StackTraces.stack(2);
        try {
            return this.getStoreConnector(tableId, regionId).exec(stack, function, retryTimes, ErrorCodeUtils.errorToStrategyFunc);
        }
        catch (Exception e) {
            log.error("Call [{}] exec error, table id: [{}], region id: [{}], msg: [{}].", new Object[]{stack, tableId, regionId, e.getMessage()});
            throw e;
        }
    }
}

