/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service.store;

import com.google.protobuf.ByteString;
import io.dingodb.common.Common;
import io.dingodb.error.ErrorOuterClass;
import io.dingodb.sdk.common.Context;
import io.dingodb.sdk.common.DingoClientException;
import io.dingodb.sdk.common.KeyValue;
import io.dingodb.sdk.common.utils.EntityConversion;
import io.dingodb.sdk.service.connector.StoreServiceConnector;
import io.dingodb.sdk.service.store.Coprocessor;
import io.dingodb.store.Store;
import io.dingodb.store.StoreServiceGrpc;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class ScanIterator
implements Iterator<KeyValue>,
AutoCloseable {
    private final AtomicReference<StoreServiceGrpc.StoreServiceBlockingStub> stub = new AtomicReference();
    private final AtomicReference<Context> context = new AtomicReference();
    private final StoreServiceConnector connector;
    private final Supplier<Context> contextSupplier;
    private final Common.RangeWithOptions range;
    private final ByteString scanId;
    private final int retryTimes;
    private final Coprocessor coprocessor;
    private Iterator<KeyValue> delegateIterator = Collections.emptyList().iterator();
    private boolean release = false;

    public ScanIterator(StoreServiceConnector connector, Supplier<Context> contextSupplier, Common.RangeWithOptions range, boolean key_only, int retryTimes, Coprocessor coprocessor) {
        this.connector = connector;
        this.contextSupplier = contextSupplier;
        this.range = range;
        this.retryTimes = retryTimes;
        this.coprocessor = coprocessor;
        this.scanId = this.scanBegin();
        if (this.scanId == null || this.scanId.isEmpty()) {
            this.release = true;
        }
    }

    private static void checkRes(ErrorOuterClass.Error error, String param) {
        if (error.getErrcodeValue() != 0) {
            throw new DingoClientException(error.getErrcodeValue(), "Scan " + param + " error: " + error.getErrmsg());
        }
    }

    private KeyValue mapping(Common.KeyValue pbKv) {
        return new KeyValue(pbKv.getKey().toByteArray(), pbKv.getValue().toByteArray());
    }

    public ByteString scanBegin() {
        Store.KvScanBeginRequest.Builder builder = Store.KvScanBeginRequest.newBuilder().setRange(this.range).setMaxFetchCnt(0L);
        Store.KvScanBeginResponse response = this.connector.exec(stub -> {
            Context con = this.contextSupplier.get();
            this.context.set(con);
            if (this.coprocessor != null) {
                builder.setCoprocessor(EntityConversion.mapping(this.coprocessor, con.getRegionId()));
            }
            this.stub.set((StoreServiceGrpc.StoreServiceBlockingStub)((Object)stub));
            return stub.kvScanBegin(builder.setContext(EntityConversion.mapping(con)).build());
        });
        return response.getScanId();
    }

    public synchronized void scanContinue() {
        if (this.delegateIterator.hasNext()) {
            return;
        }
        Store.KvScanContinueResponse response = this.stub.get().kvScanContinue(Store.KvScanContinueRequest.newBuilder().setScanId(this.scanId).setContext(EntityConversion.mapping(this.context.get())).setMaxFetchCnt(10L).build());
        ScanIterator.checkRes(response.getError(), "continue");
        this.delegateIterator = response.getKvsList().stream().map(this::mapping).iterator();
        if (!this.delegateIterator.hasNext()) {
            this.release = true;
            CompletableFuture.runAsync(this::scanRelease);
        }
    }

    public void scanRelease() {
        Store.KvScanReleaseResponse response = this.stub.get().kvScanRelease(Store.KvScanReleaseRequest.newBuilder().setContext(EntityConversion.mapping(this.context.get())).setScanId(this.scanId).build());
        ScanIterator.checkRes(response.getError(), "release");
    }

    @Override
    public synchronized void close() {
        if (this.release) {
            return;
        }
        this.scanRelease();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public boolean hasNext() {
        if (this.release) {
            return false;
        }
        if (this.delegateIterator.hasNext()) {
            return true;
        }
        this.scanContinue();
        return this.delegateIterator.hasNext();
    }

    @Override
    public KeyValue next() {
        if (this.release) {
            throw new NoSuchElementException();
        }
        return this.delegateIterator.next();
    }
}

