/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service.meta;

import com.google.protobuf.ByteString;
import io.dingodb.common.Common;
import io.dingodb.coordinator.Coordinator;
import io.dingodb.meta.Meta;
import io.dingodb.meta.MetaServiceGrpc;
import io.dingodb.sdk.common.DingoClientException;
import io.dingodb.sdk.common.DingoCommonId;
import io.dingodb.sdk.common.SDKCommonId;
import io.dingodb.sdk.common.codec.DingoKeyValueCodec;
import io.dingodb.sdk.common.index.Index;
import io.dingodb.sdk.common.index.IndexMetrics;
import io.dingodb.sdk.common.partition.Partition;
import io.dingodb.sdk.common.partition.PartitionDetail;
import io.dingodb.sdk.common.table.Column;
import io.dingodb.sdk.common.table.RangeDistribution;
import io.dingodb.sdk.common.table.Table;
import io.dingodb.sdk.common.table.metric.TableMetrics;
import io.dingodb.sdk.common.utils.ByteArrayUtils;
import io.dingodb.sdk.common.utils.EntityConversion;
import io.dingodb.sdk.common.utils.Optional;
import io.dingodb.sdk.common.utils.Parameters;
import io.dingodb.sdk.common.utils.TypeSchemaMapper;
import io.dingodb.sdk.service.connector.MetaServiceConnector;
import io.dingodb.sdk.service.connector.ServiceConnector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaServiceClient {
    private static final Logger log = LoggerFactory.getLogger(MetaServiceClient.class);
    private static final ExecutorService reloadExecutor = Executors.newCachedThreadPool(runnable -> new Thread(Thread.currentThread().getThreadGroup(), runnable, "meta-service-client-reload"));
    private static final Meta.DingoCommonId ROOT_SCHEMA_ID = Meta.DingoCommonId.newBuilder().setEntityType(Meta.EntityType.ENTITY_TYPE_SCHEMA).setEntityId(0L).setParentEntityId(0L).build();
    private static final Meta.DingoCommonId DINGO_SCHEMA_ID = Meta.DingoCommonId.newBuilder().setEntityType(Meta.EntityType.ENTITY_TYPE_SCHEMA).setEntityId(2L).setParentEntityId(0L).build();
    private static Pattern pattern = Pattern.compile("^[A-Z_][A-Z\\d_]*$");
    private static Pattern warnPattern = Pattern.compile(".*[a-z]+.*");
    private static final String ROOT_NAME = "ROOT";
    private final Meta.DingoCommonId parentId = ROOT_SCHEMA_ID;
    private final Meta.DingoCommonId id;
    private final String name;
    private MetaServiceConnector metaConnector;

    public MetaServiceClient(String servers) {
        this.id = ROOT_SCHEMA_ID;
        this.name = ROOT_NAME;
        this.metaConnector = MetaServiceConnector.getMetaServiceConnector(servers);
    }

    private MetaServiceClient(Meta.DingoCommonId id, String name, MetaServiceConnector metaConnector) {
        this.metaConnector = metaConnector;
        this.id = id;
        this.name = this.cleanSchemaName(name);
    }

    public ServiceConnector<MetaServiceGrpc.MetaServiceBlockingStub> getMetaConnector() {
        return this.metaConnector;
    }

    public void close() {
    }

    public void createSubMetaService(String name) {
        name = this.cleanSchemaName(name);
        Meta.CreateSchemaRequest request = Meta.CreateSchemaRequest.newBuilder().setParentSchemaId(this.parentId).setSchemaName(name).build();
        this.metaConnector.exec(stub -> stub.createSchema(request));
    }

    public List<Meta.Schema> getSchemas(Meta.DingoCommonId id) {
        Meta.GetSchemasRequest request = Meta.GetSchemasRequest.newBuilder().setSchemaId(id).build();
        return Optional.mapOrGet(this.metaConnector.exec(stub -> stub.getSchemas(request)), Meta.GetSchemasResponse::getSchemasList, Collections::emptyList);
    }

    public Map<String, MetaServiceClient> getSubMetaServices() {
        return this.getSchemas(this.parentId).stream().map(schema -> new MetaServiceClient(schema.getId(), schema.getName(), this.metaConnector)).collect(Collectors.toMap(MetaServiceClient::name, Function.identity()));
    }

    public MetaServiceClient getSubMetaService(String name) {
        name = this.cleanSchemaName(name);
        Meta.GetSchemaByNameRequest request = Meta.GetSchemaByNameRequest.newBuilder().setSchemaName(name).build();
        return Optional.ofNullable(this.metaConnector.exec(stub -> stub.getSchemaByName(request))).map(Meta.GetSchemaByNameResponse::getSchema).mapOrNull(__ -> new MetaServiceClient(__.getId(), __.getName(), this.metaConnector));
    }

    public MetaServiceClient getSubMetaService(DingoCommonId schemaId) {
        return this.getSubMetaService(Meta.DingoCommonId.newBuilder().setEntityType(Meta.EntityType.ENTITY_TYPE_SCHEMA).setParentEntityId(schemaId.parentId()).setEntityId(schemaId.entityId()).build());
    }

    private MetaServiceClient getSubMetaService(Meta.DingoCommonId schemaId) {
        Meta.GetSchemaRequest request = Meta.GetSchemaRequest.newBuilder().setSchemaId(schemaId).build();
        Meta.GetSchemaResponse response = this.metaConnector.exec(stub -> stub.getSchema(request));
        Meta.Schema schema = response.getSchema();
        return new MetaServiceClient(schema.getId(), schema.getName(), this.metaConnector);
    }

    public boolean dropSubMetaService(DingoCommonId schemaId) {
        Meta.DropSchemaRequest request = Meta.DropSchemaRequest.newBuilder().setSchemaId(EntityConversion.mapping(schemaId)).build();
        return this.metaConnector.exec(stub -> stub.dropSchema(request)) != null;
    }

    public boolean createTable(@NonNull String tableName, @NonNull Table table2) {
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        if (table2 == null) {
            throw new NullPointerException("table is marked non-null but is null");
        }
        return this.createTables(table2, new ArrayList<Table>());
    }

    public boolean createTables(@NonNull Table table2, List<Table> indexes) {
        if (table2 == null) {
            throw new NullPointerException("table is marked non-null but is null");
        }
        String tableName = this.cleanTableName(table2.getName());
        List<Column> columns = table2.getColumns();
        for (int i2 = 0; i2 < columns.size(); ++i2) {
            String elementType;
            Column column = columns.get(i2);
            String typeName = column.getType();
            if (TypeSchemaMapper.checkType(typeName, elementType = column.getElementType())) continue;
            throw new DingoClientException("There is no schema mapping for " + typeName + " and " + elementType);
        }
        if (Optional.mapOrNull(this.getTableId(tableName), this::getTableDefinition) != null) {
            throw new DingoClientException("Table " + tableName + " already exists");
        }
        List partCount = indexes.stream().map(i -> Optional.ofNullable(i.getPartition()).map(Partition::getDetails).map(List::size).orElse(0) + 1).collect(Collectors.toList());
        Meta.GenerateTableIdsRequest request = Meta.GenerateTableIdsRequest.newBuilder().setSchemaId(this.id).setCount(Meta.TableWithPartCount.newBuilder().setHasTable(true).setTablePartCount(Optional.mapOrGet(table2.getPartition(), __ -> __.getDetails().size() + 1, () -> 1)).setIndexCount(indexes.size()).addAllIndexPartCount(partCount).build()).build();
        List<Meta.TableIdWithPartIds> ids = this.metaConnector.exec(stub -> stub.generateTableIds(request)).getIdsList();
        Meta.TableIdWithPartIds tableWithId = ids.stream().filter(i -> i.getTableId().getEntityType().name().equals(Meta.EntityType.ENTITY_TYPE_TABLE.name())).findAny().get();
        List indexIds = ids.stream().filter(i -> i.getTableId().getEntityType().name().equals(Meta.EntityType.ENTITY_TYPE_INDEX.name())).collect(Collectors.toList());
        Meta.CreateTablesRequest.Builder builder = Meta.CreateTablesRequest.newBuilder().setSchemaId(this.id);
        if (indexIds.size() == partCount.size()) {
            for (int i3 = 0; i3 < indexIds.size(); ++i3) {
                Table index = indexes.get(i3);
                Meta.TableIdWithPartIds tableIdWithPartId = (Meta.TableIdWithPartIds)indexIds.get(i3);
                Meta.TableDefinition indexDefinition = EntityConversion.mapping(index, tableIdWithPartId.getTableId(), tableIdWithPartId.getPartIdsList());
                builder.addTableDefinitionWithIds(Meta.TableDefinitionWithId.newBuilder().setTableId(tableIdWithPartId.getTableId()).setTableDefinition(indexDefinition).build());
            }
        }
        builder.addTableDefinitionWithIds(Meta.TableDefinitionWithId.newBuilder().setTableId(tableWithId.getTableId()).setTableDefinition(EntityConversion.mapping(table2, tableWithId.getTableId(), tableWithId.getPartIdsList())).build());
        Meta.CreateTablesResponse response = this.metaConnector.exec(stub -> stub.createTables(builder.build()));
        return response != null;
    }

    public synchronized boolean dropTable(@NonNull String tableName) {
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        DingoCommonId tableId = this.getTableId(tableName = this.cleanTableName(tableName));
        if (tableId == null) {
            throw new DingoClientException("Table " + tableName + " does not exist");
        }
        Meta.DropTableRequest request = Meta.DropTableRequest.newBuilder().setTableId(EntityConversion.mapping(tableId)).build();
        Meta.DropTableResponse response = this.metaConnector.exec(stub -> stub.dropTable(request));
        return response.getError().getErrcodeValue() == 0;
    }

    public synchronized boolean dropTables(@NonNull Collection<DingoCommonId> tableIds) {
        if (tableIds == null) {
            throw new NullPointerException("tableIds is marked non-null but is null");
        }
        Meta.DropTablesRequest request = Meta.DropTablesRequest.newBuilder().addAllTableIds(tableIds.stream().map(EntityConversion::mapping).collect(Collectors.toList())).build();
        Meta.DropTablesResponse response = this.metaConnector.exec(stub -> stub.dropTables(request));
        return response.getError().getErrcodeValue() == 0;
    }

    public synchronized boolean dropTables(@NonNull List<String> tableNames) {
        if (tableNames == null) {
            throw new NullPointerException("tableNames is marked non-null but is null");
        }
        ArrayList<Meta.DingoCommonId> tableIds = new ArrayList<Meta.DingoCommonId>();
        for (String tableName : tableNames) {
            DingoCommonId tableId = this.getTableId(tableName = this.cleanTableName(tableName));
            if (tableId == null) {
                throw new DingoClientException("Table " + tableName + " does not exist");
            }
            tableIds.add(EntityConversion.mapping(tableId));
        }
        Meta.DropTablesRequest request = Meta.DropTablesRequest.newBuilder().addAllTableIds(tableIds).build();
        Meta.DropTablesResponse response = this.metaConnector.exec(stub -> stub.dropTables(request));
        return response.getError().getErrcodeValue() == 0;
    }

    public DingoCommonId getTableId(@NonNull String tableName) {
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        tableName = this.cleanTableName(tableName);
        return Optional.mapOrNull(this.getTableDefinitionWithId(tableName), __ -> EntityConversion.mapping(__.getTableId()));
    }

    @Deprecated
    public List<Table> getTables(String tableName) {
        DingoCommonId tableId = this.getTableId(tableName = this.cleanTableName(tableName));
        if (tableId == null) {
            throw new DingoClientException("Table " + tableName + " does not exist");
        }
        Meta.GetTablesRequest request = Meta.GetTablesRequest.newBuilder().setTableId(EntityConversion.mapping(tableId)).build();
        Meta.GetTablesResponse response = this.metaConnector.exec(stub -> stub.getTables(request));
        return response.getTableDefinitionWithIdsList().stream().map(EntityConversion::mapping).collect(Collectors.toList());
    }

    public Map<DingoCommonId, Table> getTableIndexes(String tableName) {
        DingoCommonId tableId = this.getTableId(tableName = this.cleanTableName(tableName));
        if (tableId == null) {
            throw new DingoClientException("Table " + tableName + " does not exist");
        }
        return this.getTableIndexes(tableId);
    }

    public Map<DingoCommonId, Table> getTableIndexes(DingoCommonId tableId) {
        Meta.DingoCommonId metaTableId = EntityConversion.mapping(tableId);
        Meta.GetTablesRequest request = Meta.GetTablesRequest.newBuilder().setTableId(metaTableId).build();
        Meta.GetTablesResponse response = this.metaConnector.exec(stub -> stub.getTables(request));
        return response.getTableDefinitionWithIdsList().stream().filter(__ -> !__.getTableId().equals(metaTableId)).collect(Collectors.toMap(__ -> EntityConversion.mapping(__.getTableId()), EntityConversion::mapping));
    }

    public Map<String, Table> getTableDefinitionsBySchema() {
        if (this.id != ROOT_SCHEMA_ID) {
            List<Meta.TableDefinitionWithId> tableDefinitions = this.getTableDefinitionsBySchema(this.id);
            return tableDefinitions.stream().map(EntityConversion::mapping).collect(Collectors.toMap(Table::getName, Function.identity()));
        }
        return Collections.emptyMap();
    }

    private List<Meta.TableDefinitionWithId> getTableDefinitionsBySchema(Meta.DingoCommonId id) {
        Meta.GetTablesBySchemaRequest request = Meta.GetTablesBySchemaRequest.newBuilder().setSchemaId(id).build();
        return this.metaConnector.exec(stub -> stub.getTablesBySchema(request)).getTableDefinitionWithIdsList();
    }

    public Table getTableDefinition(@NonNull String tableName) {
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        return Optional.mapOrThrow(this.getTableDefinitionWithId(this.cleanTableName(tableName)), EntityConversion::mapping, () -> new DingoClientException("Table " + tableName + " does not exist"));
    }

    public Table getTableDefinition(@NonNull DingoCommonId tableId) {
        if (tableId == null) {
            throw new NullPointerException("tableId is marked non-null but is null");
        }
        Meta.GetTableRequest request = Meta.GetTableRequest.newBuilder().setTableId(EntityConversion.mapping(tableId)).build();
        return EntityConversion.mapping(this.metaConnector.exec(stub -> stub.getTable(request)).getTableDefinitionWithId());
    }

    private Meta.TableDefinitionWithId getTableDefinitionWithId(String tableName) {
        Meta.GetTableByNameRequest request = Meta.GetTableByNameRequest.newBuilder().setSchemaId(this.id).setTableName(tableName).build();
        return Optional.ofNullable(this.metaConnector.exec(stub -> stub.getTableByName(request))).map(Meta.GetTableByNameResponse::getTableDefinitionWithId).filter(__ -> __.getTableDefinition().getName().equalsIgnoreCase(tableName)).orNull();
    }

    public Map<DingoCommonId, Long> getTableCommitCount() {
        if (!this.id().equals(ROOT_SCHEMA_ID)) {
            throw new UnsupportedOperationException("Only supported root meta service.");
        }
        List regions = this.metaConnector.getCoordinatorServiceConnector().exec(stub -> stub.getRegionMap(Coordinator.GetRegionMapRequest.newBuilder().build())).getRegionmap().getRegionsList().stream().map(Common.Region::getId).map(__ -> this.metaConnector.getCoordinatorServiceConnector().exec(stub -> stub.queryRegion(Coordinator.QueryRegionRequest.newBuilder().setRegionId((long)__).build()))).map(Coordinator.QueryRegionResponse::getRegion).collect(Collectors.toList());
        List tableIds = this.getSchemas(ROOT_SCHEMA_ID).stream().map(Meta.Schema::getTableIdsList).flatMap(Collection::stream).map(Meta.DingoCommonId::getEntityId).collect(Collectors.toList());
        HashMap<DingoCommonId, Long> metrics = new HashMap<DingoCommonId, Long>();
        for (Common.Region region2 : regions) {
            Common.RegionDefinition definition = region2.getDefinition();
            SDKCommonId tableId = new SDKCommonId(DingoCommonId.Type.ENTITY_TYPE_TABLE, definition.getSchemaId(), definition.getTableId());
            if (!tableIds.contains(definition.getTableId())) continue;
            long committedIndex = region2.getMetrics().getBraftStatus().getCommittedIndex();
            metrics.compute(tableId, (id, c) -> c == null ? committedIndex : c + committedIndex);
        }
        return metrics;
    }

    public void addDistribution(String tableName, PartitionDetail partitionDetail) {
        tableName = this.cleanTableName(tableName);
        Meta.TableDefinitionWithId definitionWithId = Parameters.nonNull(this.getTableDefinitionWithId(tableName), "Table " + tableName + " dose not exist");
        Table table2 = EntityConversion.mapping(definitionWithId);
        DingoCommonId tableId = EntityConversion.mapping(definitionWithId.getTableId());
        DingoKeyValueCodec codec = DingoKeyValueCodec.of(table2.getCodecVersion(), tableId.entityId(), table2.getKeyColumns());
        try {
            byte[] key = codec.encodeKeyPrefix(partitionDetail.getOperand(), partitionDetail.getOperand().length);
            RangeDistribution distribution = this.getRangeDistribution(tableName, new ByteArrayUtils.ComparableByteArray(key, 8));
            Coordinator.SplitRegionRequest request = Coordinator.SplitRegionRequest.newBuilder().setSplitRequest(Coordinator.SplitRequest.newBuilder().setSplitFromRegionId(distribution.getId().entityId()).setSplitWatershedKey(ByteString.copyFrom((byte[])codec.resetPrefix(key, 8L))).build()).build();
            this.metaConnector.getCoordinatorServiceConnector().exec(stub -> stub.splitRegion(request));
        }
        catch (Exception e) {
            throw new DingoClientException(-1, (Throwable)e);
        }
    }

    public RangeDistribution getRangeDistribution(String tableName, ByteArrayUtils.ComparableByteArray key) {
        return this.getRangeDistribution(this.cleanTableName(tableName)).floorEntry(key).getValue();
    }

    public RangeDistribution getRangeDistribution(String tableName, DingoCommonId regionId) {
        return this.getRangeDistribution(this.cleanTableName(tableName)).values().stream().filter(r -> r.getId().equals(regionId)).findAny().orElseThrow(() -> new DingoClientException("Not found region " + tableName + ":" + String.valueOf(regionId)));
    }

    public RangeDistribution getRangeDistribution(DingoCommonId id, ByteArrayUtils.ComparableByteArray key) {
        return this.getRangeDistribution(id).floorEntry(key).getValue();
    }

    public RangeDistribution getRangeDistribution(DingoCommonId id, DingoCommonId regionId) {
        return this.getRangeDistribution(id).values().stream().filter(r -> r.getId().equals(regionId)).findAny().orElseThrow(() -> new DingoClientException("Not found region " + String.valueOf(id) + ":" + String.valueOf(regionId)));
    }

    public NavigableMap<ByteArrayUtils.ComparableByteArray, RangeDistribution> getRangeDistribution(String tableName) {
        DingoCommonId tableId = this.getTableId(tableName = this.cleanTableName(tableName));
        if (tableId == null) {
            throw new DingoClientException("Table " + tableName + " does not exist");
        }
        return this.getRangeDistribution(tableId);
    }

    public NavigableMap<ByteArrayUtils.ComparableByteArray, RangeDistribution> getRangeDistribution(DingoCommonId id) {
        TreeMap<ByteArrayUtils.ComparableByteArray, RangeDistribution> result = new TreeMap<ByteArrayUtils.ComparableByteArray, RangeDistribution>();
        Meta.GetTableRangeRequest request = Meta.GetTableRangeRequest.newBuilder().setTableId(EntityConversion.mapping(id)).build();
        Meta.GetTableRangeResponse response = this.metaConnector.exec(stub -> stub.getTableRange(request));
        for (Meta.RangeDistribution tablePart : response.getTableRange().getRangeDistributionList()) {
            result.put(new ByteArrayUtils.ComparableByteArray(tablePart.getRange().getStartKey().toByteArray()), EntityConversion.mapping(tablePart));
        }
        return result;
    }

    public TableMetrics getTableMetrics(String tableName) {
        DingoCommonId tableId = this.getTableId(tableName = this.cleanTableName(tableName));
        if (tableId == null) {
            throw new DingoClientException("Table " + tableName + " does not exist");
        }
        return Optional.ofNullable(tableId).map(__ -> {
            Meta.GetTableMetricsRequest request = Meta.GetTableMetricsRequest.newBuilder().setTableId(EntityConversion.mapping(__)).build();
            return Optional.ofNullable(this.metaConnector.exec(stub -> stub.getTableMetrics(request))).map(Meta.GetTableMetricsResponse::getTableMetrics).map(Meta.TableMetricsWithId::getTableMetrics).orNull();
        }).mapOrNull(EntityConversion::mapping);
    }

    public boolean createIndex(String name, Index index) {
        Meta.GenerateTableIdsRequest generateRequest = Meta.GenerateTableIdsRequest.newBuilder().setSchemaId(this.id).setCount(Meta.TableWithPartCount.newBuilder().setHasTable(false).setIndexCount(1).addAllIndexPartCount(Collections.singletonList(index.getIndexPartition().getDetails().size() + 1)).build()).build();
        Meta.GenerateTableIdsResponse generateResponse = this.metaConnector.exec(stub -> stub.generateTableIds(generateRequest));
        if (generateResponse.getIdsCount() <= 0) {
            throw new DingoClientException("Index id generation failed");
        }
        Meta.TableIdWithPartIds withPartIds = generateResponse.getIdsList().get(0);
        Meta.CreateIndexRequest request = Meta.CreateIndexRequest.newBuilder().setSchemaId(this.id).setIndexId(withPartIds.getTableId()).setIndexDefinition(EntityConversion.mapping(withPartIds.getTableId().getEntityId(), index, withPartIds.getPartIdsList())).build();
        Meta.CreateIndexResponse response = this.metaConnector.exec(stub -> stub.createIndex(request));
        return response != null;
    }

    public boolean updateIndex(String index, Index newIndex) {
        if (index.contains(".")) {
            return false;
        }
        DingoCommonId indexId = this.getIndexId(index);
        Meta.UpdateIndexRequest request = Meta.UpdateIndexRequest.newBuilder().setIndexId(EntityConversion.mapping(indexId)).setNewIndexDefinition(EntityConversion.mapping(indexId.entityId(), newIndex, Collections.emptyList())).build();
        Meta.UpdateIndexResponse response = this.metaConnector.exec(stub -> stub.updateIndex(request));
        return response != null;
    }

    public boolean dropIndex(String indexName) {
        if (indexName.contains(".")) {
            return false;
        }
        DingoCommonId indexId = this.getIndexId(indexName);
        return this.dropIndex(indexId);
    }

    public boolean dropIndex(DingoCommonId indexId) {
        Meta.DropIndexRequest request = Meta.DropIndexRequest.newBuilder().setIndexId(EntityConversion.mapping(indexId)).build();
        Meta.DropIndexResponse response = this.metaConnector.exec(stub -> stub.dropIndex(request));
        return response.getError().getErrcodeValue() == 0;
    }

    public Index getIndex(DingoCommonId indexId) {
        Meta.GetIndexRequest request = Meta.GetIndexRequest.newBuilder().setIndexId(EntityConversion.mapping(indexId)).build();
        Meta.GetIndexResponse response = this.metaConnector.exec(stub -> stub.getIndex(request));
        if (response.getIndexDefinitionWithId().getIndexDefinition().getName().contains(".")) {
            return null;
        }
        return EntityConversion.mapping(indexId.entityId(), response.getIndexDefinitionWithId().getIndexDefinition());
    }

    public Index getIndex(String name) {
        if (name.contains(".")) {
            return null;
        }
        Meta.GetIndexByNameRequest request = Meta.GetIndexByNameRequest.newBuilder().setSchemaId(this.id).setIndexName(name).build();
        Meta.GetIndexByNameResponse response = this.metaConnector.exec(stub -> stub.getIndexByName(request));
        Meta.IndexDefinitionWithId withId = response.getIndexDefinitionWithId();
        return EntityConversion.mapping(withId.getIndexId().getEntityId(), withId.getIndexDefinition());
    }

    public Map<DingoCommonId, Index> getIndexes(DingoCommonId schemaId) {
        ConcurrentHashMap<DingoCommonId, Index> results = new ConcurrentHashMap<DingoCommonId, Index>();
        Meta.GetIndexesRequest request = Meta.GetIndexesRequest.newBuilder().setSchemaId(EntityConversion.mapping(schemaId)).build();
        Meta.GetIndexesResponse response = this.metaConnector.exec(stub -> stub.getIndexes(request));
        for (Meta.IndexDefinitionWithId withId : response.getIndexDefinitionWithIdsList()) {
            if (withId.getIndexDefinition().getName().contains(".")) continue;
            results.put(EntityConversion.mapping(withId.getIndexId()), EntityConversion.mapping(withId.getIndexId().getEntityId(), withId.getIndexDefinition()));
        }
        return results;
    }

    public DingoCommonId getIndexId(String indexName) {
        return Optional.mapOrNull(this.getIndexDefinitionWithId(indexName), __ -> EntityConversion.mapping(__.getIndexId()));
    }

    private Meta.IndexDefinitionWithId getIndexDefinitionWithId(String indexName) {
        if (indexName.contains(".")) {
            return null;
        }
        Meta.GetIndexByNameRequest request = Meta.GetIndexByNameRequest.newBuilder().setSchemaId(this.id).setIndexName(indexName).build();
        return Optional.ofNullable(this.metaConnector.exec(stub -> stub.getIndexByName(request))).map(Meta.GetIndexByNameResponse::getIndexDefinitionWithId).filter(__ -> __.getIndexDefinition().getName().equalsIgnoreCase(indexName)).orNull();
    }

    public RangeDistribution getIndexRangeDistribution(String tableName, ByteArrayUtils.ComparableByteArray key) {
        return this.getIndexRangeDistribution(this.cleanTableName(tableName)).floorEntry(key).getValue();
    }

    public RangeDistribution getIndexRangeDistribution(String tableName, DingoCommonId regionId) {
        return this.getIndexRangeDistribution(this.cleanTableName(tableName)).values().stream().filter(r -> r.getId().equals(regionId)).findAny().orElseThrow(() -> new DingoClientException("Not found region " + tableName + ":" + String.valueOf(regionId)));
    }

    public RangeDistribution getIndexRangeDistribution(DingoCommonId id, ByteArrayUtils.ComparableByteArray key) {
        return this.getIndexRangeDistribution(id).floorEntry(key).getValue();
    }

    public NavigableMap<ByteArrayUtils.ComparableByteArray, RangeDistribution> getIndexRangeDistribution(String indexName) {
        DingoCommonId indexId = this.getIndexId(indexName);
        if (indexId == null) {
            throw new DingoClientException("Index " + indexName + " does not exist");
        }
        return this.getIndexRangeDistribution(indexId);
    }

    public NavigableMap<ByteArrayUtils.ComparableByteArray, RangeDistribution> getIndexRangeDistribution(DingoCommonId indexId) {
        TreeMap<ByteArrayUtils.ComparableByteArray, RangeDistribution> result = new TreeMap<ByteArrayUtils.ComparableByteArray, RangeDistribution>();
        Meta.GetIndexRangeRequest request = Meta.GetIndexRangeRequest.newBuilder().setIndexId(EntityConversion.mapping(indexId)).build();
        Meta.GetIndexRangeResponse response = this.metaConnector.exec(stub -> stub.getIndexRange(request));
        for (Meta.RangeDistribution indexPart : response.getIndexRange().getRangeDistributionList()) {
            result.put(new ByteArrayUtils.ComparableByteArray(indexPart.getRange().getStartKey().toByteArray()), EntityConversion.mapping(indexPart));
        }
        return result;
    }

    public IndexMetrics getIndexMetrics(String index) {
        DingoCommonId indexId = this.getIndexId(index);
        if (indexId == null) {
            throw new DingoClientException("Index" + index + " does not exist");
        }
        return this.getIndexMetrics(indexId);
    }

    public IndexMetrics getIndexMetrics(DingoCommonId indexId) {
        return Optional.ofNullable(indexId).map(__ -> {
            Meta.GetIndexMetricsRequest request = Meta.GetIndexMetricsRequest.newBuilder().setIndexId(EntityConversion.mapping(__)).build();
            return Optional.ofNullable(this.metaConnector.exec(stub -> stub.getIndexMetrics(request))).map(Meta.GetIndexMetricsResponse::getIndexMetrics).map(Meta.IndexMetricsWithId::getIndexMetrics).orNull();
        }).mapOrNull(EntityConversion::mapping);
    }

    private String cleanTableName(String name) {
        return this.cleanName(name, "Table");
    }

    private String cleanColumnName(String name) {
        return this.cleanName(name, "Column");
    }

    private String cleanSchemaName(String name) {
        return this.cleanName(name, "Schema");
    }

    private String cleanName(String name, String source) {
        if (warnPattern.matcher(name).matches()) {
            log.warn("{} name currently only supports uppercase letters, LowerCase -> UpperCase", (Object)source);
            name = name.toUpperCase();
        }
        if (!pattern.matcher(name).matches()) {
            throw new DingoClientException(source + " name currently only supports uppercase letters, digits, and underscores");
        }
        return name;
    }

    public Meta.DingoCommonId id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }
}

