/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service.meta;

import io.dingodb.meta.Meta;
import io.dingodb.sdk.common.AutoIncrement;
import io.dingodb.sdk.common.DingoCommonId;
import io.dingodb.sdk.common.utils.EntityConversion;
import io.dingodb.sdk.service.connector.AutoIncrementServiceConnector;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoIncrementService {
    private static final Logger log = LoggerFactory.getLogger(AutoIncrementService.class);
    private static final Map<String, Map<DingoCommonId, AutoIncrement>> cache = new ConcurrentHashMap<String, Map<DingoCommonId, AutoIncrement>>();
    ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Map<DingoCommonId, AutoIncrement> innerCache;
    private final AutoIncrementServiceConnector connector;
    private Long count = 10000L;
    private Integer increment = 1;
    private Integer offset = 1;

    public AutoIncrementService(String servers) {
        this.connector = AutoIncrementServiceConnector.getAutoIncrementServiceConnector(servers);
        this.innerCache = cache.computeIfAbsent(servers, s -> new ConcurrentHashMap());
    }

    public void resetCount(long count) {
        this.count = count;
    }

    public void resetOffset(int offset) {
        this.offset = offset;
        cache.forEach((k, v) -> v.clear());
    }

    public void resetIncrement(int increment) {
        this.increment = increment;
        cache.forEach((k, v) -> v.clear());
    }

    public void reset(long count, int increment, int offset) {
        this.count = count;
        this.offset = offset;
        this.increment = increment;
        cache.forEach((k, v) -> v.clear());
    }

    private AutoIncrement.Increment fetcher(DingoCommonId tableId) {
        try {
            log.info("Generate auto-increment request count:{}, increment:{}, offset:{}", new Object[]{this.count, this.increment, this.offset});
            Meta.GenerateAutoIncrementRequest request = Meta.GenerateAutoIncrementRequest.newBuilder().setTableId(EntityConversion.mapping(tableId)).setCount(this.count).setAutoIncrementIncrement(this.increment).setAutoIncrementOffset(this.offset).build();
            Meta.GenerateAutoIncrementResponse response = this.connector.exec(stub -> stub.generateAutoIncrement(request));
            log.info("Generated auto-increment response startId:{}, endId:{}", (Object)response.getStartId(), (Object)response.getEndId());
            return new AutoIncrement.Increment(response.getEndId(), response.getStartId());
        }
        catch (Exception e) {
            this.innerCache.remove(tableId);
            throw e;
        }
    }

    public long current(DingoCommonId tableId) {
        Meta.GetAutoIncrementRequest request = Meta.GetAutoIncrementRequest.newBuilder().setTableId(EntityConversion.mapping(tableId)).build();
        return this.connector.exec(stub -> stub.getAutoIncrement(request)).getStartId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long localCurrent(DingoCommonId tableId) {
        this.rwLock.readLock().lock();
        try {
            AutoIncrement autoIncrement = this.innerCache.get(tableId);
            if (autoIncrement == null) {
                long l = this.current(tableId);
                return l;
            }
            long l = autoIncrement.current();
            return l;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long next(DingoCommonId tableId) {
        this.rwLock.readLock().lock();
        try {
            long l = this.innerCache.computeIfAbsent(tableId, id -> new AutoIncrement((DingoCommonId)id, this.increment, this.offset, this::fetcher)).inc();
            return l;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public void updateIncrement(DingoCommonId tableId, long increment) {
        Meta.UpdateAutoIncrementRequest request = Meta.UpdateAutoIncrementRequest.newBuilder().setTableId(EntityConversion.mapping(tableId)).setStartId(increment).setForce(true).build();
        this.connector.exec(stub -> stub.updateAutoIncrement(request));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(DingoCommonId tableId, long incrementId) {
        this.rwLock.writeLock().lock();
        ++incrementId;
        try {
            AutoIncrement autoIncrement = this.innerCache.computeIfAbsent(tableId, id -> new AutoIncrement((DingoCommonId)id, this.increment, this.offset, this::fetcher));
            if (autoIncrement.getLimit() == 0L) {
                autoIncrement.init();
            }
            if (incrementId < autoIncrement.getLimit() && incrementId >= autoIncrement.current()) {
                autoIncrement.inc(incrementId);
            } else {
                long maxId;
                autoIncrement.inc(incrementId);
                if (autoIncrement.getLimit() > 0L && incrementId > autoIncrement.getLimit() && incrementId > (maxId = this.current(tableId))) {
                    this.updateIncrement(tableId, incrementId);
                    this.reset(tableId);
                }
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public void reset(DingoCommonId tableId) {
        this.rwLock.writeLock().lock();
        try {
            this.innerCache.remove(tableId);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public void reset() {
        this.rwLock.writeLock().lock();
        try {
            this.innerCache.clear();
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public boolean cacheAutoIncrement(DingoCommonId tableId) {
        return this.innerCache.containsKey(tableId);
    }
}

