/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service.entity.version;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.ResponseInfo;
import io.dingodb.sdk.service.entity.error.Error;
import io.dingodb.sdk.service.entity.version.Kv;
import io.dingodb.sdk.service.entity.version.ResponseHeader;
import java.util.List;

public class RangeResponse
implements Message,
Message.Response {
    private Error error;
    private ResponseInfo responseInfo;
    private ResponseHeader header;
    private boolean more;
    private List<Kv> kvs;
    private long count;
    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write((Integer)1, (Message)this.responseInfo, out);
        Writer.write((Integer)2, (Message)this.error, out);
        Writer.write((Integer)3, (Message)this.header, out);
        Writer.write((Integer)4, this.kvs, (n, v) -> Writer.write(n, (Message)v, out));
        Writer.write((Integer)5, this.more, out);
        Writer.write((Integer)6, this.count, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        block8: while ((number = Reader.readNumber(input)) != 0) {
            switch (number) {
                case 1: {
                    this.responseInfo = Reader.readMessage(new ResponseInfo(), input);
                    hasValue = hasValue ? hasValue : this.responseInfo != null;
                    continue block8;
                }
                case 2: {
                    this.error = Reader.readMessage(new Error(), input);
                    hasValue = hasValue ? hasValue : this.error != null;
                    continue block8;
                }
                case 3: {
                    this.header = Reader.readMessage(new ResponseHeader(), input);
                    hasValue = hasValue ? hasValue : this.header != null;
                    continue block8;
                }
                case 4: {
                    this.kvs = Reader.readList(this.kvs, input, in -> Reader.readMessage(new Kv(), in));
                    hasValue = true;
                    continue block8;
                }
                case 5: {
                    this.more = Reader.readBoolean(input);
                    hasValue = true;
                    continue block8;
                }
                case 6: {
                    this.count = Reader.readLong(input);
                    hasValue = true;
                    continue block8;
                }
            }
            Reader.skip(input);
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf((Integer)1, (Message)this.responseInfo).intValue();
        size += SizeUtils.sizeOf((Integer)2, (Message)this.error).intValue();
        size += SizeUtils.sizeOf((Integer)3, (Message)this.header).intValue();
        size += SizeUtils.sizeOf(4, this.kvs, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf((Integer)5, this.more).intValue();
        return size += SizeUtils.sizeOf((Integer)6, this.count).intValue();
    }

    protected RangeResponse(RangeResponseBuilder<?, ?> b) {
        this.error = b.error;
        this.responseInfo = b.responseInfo;
        this.header = b.header;
        this.more = b.more;
        this.kvs = b.kvs;
        this.count = b.count;
        this.ext$ = b.ext$;
    }

    public static RangeResponseBuilder<?, ?> builder() {
        return new RangeResponseBuilderImpl();
    }

    @Override
    public Error getError() {
        return this.error;
    }

    @Override
    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public ResponseHeader getHeader() {
        return this.header;
    }

    public boolean isMore() {
        return this.more;
    }

    public List<Kv> getKvs() {
        return this.kvs;
    }

    public long getCount() {
        return this.count;
    }

    @Override
    public Object getExt$() {
        return this.ext$;
    }

    public void setError(Error error) {
        this.error = error;
    }

    @Override
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    public void setHeader(ResponseHeader header) {
        this.header = header;
    }

    public void setMore(boolean more) {
        this.more = more;
    }

    public void setKvs(List<Kv> kvs) {
        this.kvs = kvs;
    }

    public void setCount(long count) {
        this.count = count;
    }

    @Override
    public void setExt$(Object ext$) {
        this.ext$ = ext$;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RangeResponse)) {
            return false;
        }
        RangeResponse other = (RangeResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isMore() != other.isMore()) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        Error this$error = this.getError();
        Error other$error = other.getError();
        if (this$error == null ? other$error != null : !((Object)this$error).equals(other$error)) {
            return false;
        }
        ResponseInfo this$responseInfo = this.getResponseInfo();
        ResponseInfo other$responseInfo = other.getResponseInfo();
        if (this$responseInfo == null ? other$responseInfo != null : !((Object)this$responseInfo).equals(other$responseInfo)) {
            return false;
        }
        ResponseHeader this$header = this.getHeader();
        ResponseHeader other$header = other.getHeader();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        List<Kv> this$kvs = this.getKvs();
        List<Kv> other$kvs = other.getKvs();
        if (this$kvs == null ? other$kvs != null : !((Object)this$kvs).equals(other$kvs)) {
            return false;
        }
        Object this$ext$ = this.getExt$();
        Object other$ext$ = other.getExt$();
        return !(this$ext$ == null ? other$ext$ != null : !this$ext$.equals(other$ext$));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RangeResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isMore() ? 79 : 97);
        long $count = this.getCount();
        result = result * 59 + (int)($count >>> 32 ^ $count);
        Error $error = this.getError();
        result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
        ResponseInfo $responseInfo = this.getResponseInfo();
        result = result * 59 + ($responseInfo == null ? 43 : ((Object)$responseInfo).hashCode());
        ResponseHeader $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        List<Kv> $kvs = this.getKvs();
        result = result * 59 + ($kvs == null ? 43 : ((Object)$kvs).hashCode());
        Object $ext$ = this.getExt$();
        result = result * 59 + ($ext$ == null ? 43 : $ext$.hashCode());
        return result;
    }

    public String toString() {
        return "RangeResponse(error=" + String.valueOf(this.getError()) + ", responseInfo=" + String.valueOf(this.getResponseInfo()) + ", header=" + String.valueOf(this.getHeader()) + ", more=" + this.isMore() + ", kvs=" + String.valueOf(this.getKvs()) + ", count=" + this.getCount() + ", ext$=" + String.valueOf(this.getExt$()) + ")";
    }

    public RangeResponse() {
    }

    public static abstract class RangeResponseBuilder<C extends RangeResponse, B extends RangeResponseBuilder<C, B>> {
        private Error error;
        private ResponseInfo responseInfo;
        private ResponseHeader header;
        private boolean more;
        private List<Kv> kvs;
        private long count;
        private Object ext$;

        protected abstract B self();

        public abstract C build();

        public B error(Error error) {
            this.error = error;
            return this.self();
        }

        public B responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this.self();
        }

        public B header(ResponseHeader header) {
            this.header = header;
            return this.self();
        }

        public B more(boolean more) {
            this.more = more;
            return this.self();
        }

        public B kvs(List<Kv> kvs) {
            this.kvs = kvs;
            return this.self();
        }

        public B count(long count) {
            this.count = count;
            return this.self();
        }

        public B ext$(Object ext$) {
            this.ext$ = ext$;
            return this.self();
        }

        public String toString() {
            return "RangeResponse.RangeResponseBuilder(error=" + String.valueOf(this.error) + ", responseInfo=" + String.valueOf(this.responseInfo) + ", header=" + String.valueOf(this.header) + ", more=" + this.more + ", kvs=" + String.valueOf(this.kvs) + ", count=" + this.count + ", ext$=" + String.valueOf(this.ext$) + ")";
        }
    }

    private static final class RangeResponseBuilderImpl
    extends RangeResponseBuilder<RangeResponse, RangeResponseBuilderImpl> {
        private RangeResponseBuilderImpl() {
        }

        @Override
        protected RangeResponseBuilderImpl self() {
            return this;
        }

        @Override
        public RangeResponse build() {
            return new RangeResponse(this);
        }
    }

    public static final class Fields {
        public static final String error = "error";
        public static final String responseInfo = "responseInfo";
        public static final String header = "header";
        public static final String more = "more";
        public static final String kvs = "kvs";
        public static final String count = "count";
        public static final String ext$ = "ext$";
    }
}

