/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service.entity.store;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import io.dingodb.sdk.service.entity.store.Context;
import io.dingodb.sdk.service.entity.store.ForUpdateTsCheck;
import io.dingodb.sdk.service.entity.store.LockExtraData;
import io.dingodb.sdk.service.entity.store.Mutation;
import io.dingodb.sdk.service.entity.store.PessimisticCheck;
import java.util.Arrays;
import java.util.List;

public class TxnPrewriteRequest
implements Message,
Message.Request,
Message.StoreRequest {
    private boolean tryOnePc;
    private List<Mutation> mutations;
    private List<PessimisticCheck> pessimisticChecks;
    private byte[] primaryLock;
    private List<byte[]> secondaries;
    private long maxCommitTs;
    private RequestInfo requestInfo;
    private long txnSize;
    private long minCommitTs;
    private long lockTtl;
    private long startTs;
    private boolean useAsyncCommit;
    private List<LockExtraData> lockExtraDatas;
    private Context context;
    private List<ForUpdateTsCheck> forUpdateTsChecks;
    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write((Integer)1, (Message)this.requestInfo, out);
        Writer.write((Integer)2, (Message)this.context, out);
        Writer.write((Integer)3, this.mutations, (n, v) -> Writer.write(n, (Message)v, out));
        Writer.write((Integer)4, this.primaryLock, out);
        Writer.write((Integer)5, this.startTs, out);
        Writer.write((Integer)6, this.lockTtl, out);
        Writer.write((Integer)7, this.txnSize, out);
        Writer.write((Integer)8, this.tryOnePc, out);
        Writer.write((Integer)9, this.maxCommitTs, out);
        Writer.write((Integer)10, this.pessimisticChecks, (n, v) -> Writer.write(n, v, out));
        Writer.write((Integer)11, this.forUpdateTsChecks, (n, v) -> Writer.write(n, (Message)v, out));
        Writer.write((Integer)12, this.lockExtraDatas, (n, v) -> Writer.write(n, (Message)v, out));
        Writer.write((Integer)13, this.minCommitTs, out);
        Writer.write((Integer)14, this.useAsyncCommit, out);
        Writer.write((Integer)15, this.secondaries, (n, v) -> Writer.write(n, v, out));
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        block17: while ((number = Reader.readNumber(input)) != 0) {
            switch (number) {
                case 1: {
                    this.requestInfo = Reader.readMessage(new RequestInfo(), input);
                    hasValue = hasValue ? hasValue : this.requestInfo != null;
                    continue block17;
                }
                case 2: {
                    this.context = Reader.readMessage(new Context(), input);
                    hasValue = hasValue ? hasValue : this.context != null;
                    continue block17;
                }
                case 3: {
                    this.mutations = Reader.readList(this.mutations, input, in -> Reader.readMessage(new Mutation(), in));
                    hasValue = true;
                    continue block17;
                }
                case 4: {
                    this.primaryLock = Reader.readBytes(input);
                    hasValue = true;
                    continue block17;
                }
                case 5: {
                    this.startTs = Reader.readLong(input);
                    hasValue = true;
                    continue block17;
                }
                case 6: {
                    this.lockTtl = Reader.readLong(input);
                    hasValue = true;
                    continue block17;
                }
                case 7: {
                    this.txnSize = Reader.readLong(input);
                    hasValue = true;
                    continue block17;
                }
                case 8: {
                    this.tryOnePc = Reader.readBoolean(input);
                    hasValue = true;
                    continue block17;
                }
                case 9: {
                    this.maxCommitTs = Reader.readLong(input);
                    hasValue = true;
                    continue block17;
                }
                case 10: {
                    this.pessimisticChecks = Reader.readList(this.pessimisticChecks, input, in -> PessimisticCheck.forNumber(Reader.readInt(input)));
                    hasValue = true;
                    continue block17;
                }
                case 11: {
                    this.forUpdateTsChecks = Reader.readList(this.forUpdateTsChecks, input, in -> Reader.readMessage(new ForUpdateTsCheck(), in));
                    hasValue = true;
                    continue block17;
                }
                case 12: {
                    this.lockExtraDatas = Reader.readList(this.lockExtraDatas, input, in -> Reader.readMessage(new LockExtraData(), in));
                    hasValue = true;
                    continue block17;
                }
                case 13: {
                    this.minCommitTs = Reader.readLong(input);
                    hasValue = true;
                    continue block17;
                }
                case 14: {
                    this.useAsyncCommit = Reader.readBoolean(input);
                    hasValue = true;
                    continue block17;
                }
                case 15: {
                    this.secondaries = Reader.readList(this.secondaries, input, Reader::readBytes);
                    hasValue = true;
                    continue block17;
                }
            }
            Reader.skip(input);
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf((Integer)1, (Message)this.requestInfo).intValue();
        size += SizeUtils.sizeOf((Integer)2, (Message)this.context).intValue();
        size += SizeUtils.sizeOf(3, this.mutations, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf((Integer)4, this.primaryLock).intValue();
        size += SizeUtils.sizeOf((Integer)5, this.startTs).intValue();
        size += SizeUtils.sizeOf((Integer)6, this.lockTtl).intValue();
        size += SizeUtils.sizeOf((Integer)7, this.txnSize).intValue();
        size += SizeUtils.sizeOf((Integer)8, this.tryOnePc).intValue();
        size += SizeUtils.sizeOf((Integer)9, this.maxCommitTs).intValue();
        size += SizeUtils.sizeOf(10, this.pessimisticChecks, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(11, this.forUpdateTsChecks, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(12, this.lockExtraDatas, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf((Integer)13, this.minCommitTs).intValue();
        size += SizeUtils.sizeOf((Integer)14, this.useAsyncCommit).intValue();
        return size += SizeUtils.sizeOf(15, this.secondaries, SizeUtils::sizeOf);
    }

    protected TxnPrewriteRequest(TxnPrewriteRequestBuilder<?, ?> b) {
        this.tryOnePc = b.tryOnePc;
        this.mutations = b.mutations;
        this.pessimisticChecks = b.pessimisticChecks;
        this.primaryLock = b.primaryLock;
        this.secondaries = b.secondaries;
        this.maxCommitTs = b.maxCommitTs;
        this.requestInfo = b.requestInfo;
        this.txnSize = b.txnSize;
        this.minCommitTs = b.minCommitTs;
        this.lockTtl = b.lockTtl;
        this.startTs = b.startTs;
        this.useAsyncCommit = b.useAsyncCommit;
        this.lockExtraDatas = b.lockExtraDatas;
        this.context = b.context;
        this.forUpdateTsChecks = b.forUpdateTsChecks;
        this.ext$ = b.ext$;
    }

    public static TxnPrewriteRequestBuilder<?, ?> builder() {
        return new TxnPrewriteRequestBuilderImpl();
    }

    public boolean isTryOnePc() {
        return this.tryOnePc;
    }

    public List<Mutation> getMutations() {
        return this.mutations;
    }

    public List<PessimisticCheck> getPessimisticChecks() {
        return this.pessimisticChecks;
    }

    public byte[] getPrimaryLock() {
        return this.primaryLock;
    }

    public List<byte[]> getSecondaries() {
        return this.secondaries;
    }

    public long getMaxCommitTs() {
        return this.maxCommitTs;
    }

    @Override
    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public long getTxnSize() {
        return this.txnSize;
    }

    public long getMinCommitTs() {
        return this.minCommitTs;
    }

    public long getLockTtl() {
        return this.lockTtl;
    }

    public long getStartTs() {
        return this.startTs;
    }

    public boolean isUseAsyncCommit() {
        return this.useAsyncCommit;
    }

    public List<LockExtraData> getLockExtraDatas() {
        return this.lockExtraDatas;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    public List<ForUpdateTsCheck> getForUpdateTsChecks() {
        return this.forUpdateTsChecks;
    }

    @Override
    public Object getExt$() {
        return this.ext$;
    }

    public void setTryOnePc(boolean tryOnePc) {
        this.tryOnePc = tryOnePc;
    }

    public void setMutations(List<Mutation> mutations) {
        this.mutations = mutations;
    }

    public void setPessimisticChecks(List<PessimisticCheck> pessimisticChecks) {
        this.pessimisticChecks = pessimisticChecks;
    }

    public void setPrimaryLock(byte[] primaryLock) {
        this.primaryLock = primaryLock;
    }

    public void setSecondaries(List<byte[]> secondaries) {
        this.secondaries = secondaries;
    }

    public void setMaxCommitTs(long maxCommitTs) {
        this.maxCommitTs = maxCommitTs;
    }

    @Override
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    public void setTxnSize(long txnSize) {
        this.txnSize = txnSize;
    }

    public void setMinCommitTs(long minCommitTs) {
        this.minCommitTs = minCommitTs;
    }

    public void setLockTtl(long lockTtl) {
        this.lockTtl = lockTtl;
    }

    public void setStartTs(long startTs) {
        this.startTs = startTs;
    }

    public void setUseAsyncCommit(boolean useAsyncCommit) {
        this.useAsyncCommit = useAsyncCommit;
    }

    public void setLockExtraDatas(List<LockExtraData> lockExtraDatas) {
        this.lockExtraDatas = lockExtraDatas;
    }

    @Override
    public void setContext(Context context) {
        this.context = context;
    }

    public void setForUpdateTsChecks(List<ForUpdateTsCheck> forUpdateTsChecks) {
        this.forUpdateTsChecks = forUpdateTsChecks;
    }

    @Override
    public void setExt$(Object ext$) {
        this.ext$ = ext$;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TxnPrewriteRequest)) {
            return false;
        }
        TxnPrewriteRequest other = (TxnPrewriteRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isTryOnePc() != other.isTryOnePc()) {
            return false;
        }
        if (this.getMaxCommitTs() != other.getMaxCommitTs()) {
            return false;
        }
        if (this.getTxnSize() != other.getTxnSize()) {
            return false;
        }
        if (this.getMinCommitTs() != other.getMinCommitTs()) {
            return false;
        }
        if (this.getLockTtl() != other.getLockTtl()) {
            return false;
        }
        if (this.getStartTs() != other.getStartTs()) {
            return false;
        }
        if (this.isUseAsyncCommit() != other.isUseAsyncCommit()) {
            return false;
        }
        List<Mutation> this$mutations = this.getMutations();
        List<Mutation> other$mutations = other.getMutations();
        if (this$mutations == null ? other$mutations != null : !((Object)this$mutations).equals(other$mutations)) {
            return false;
        }
        List<PessimisticCheck> this$pessimisticChecks = this.getPessimisticChecks();
        List<PessimisticCheck> other$pessimisticChecks = other.getPessimisticChecks();
        if (this$pessimisticChecks == null ? other$pessimisticChecks != null : !((Object)this$pessimisticChecks).equals(other$pessimisticChecks)) {
            return false;
        }
        if (!Arrays.equals(this.getPrimaryLock(), other.getPrimaryLock())) {
            return false;
        }
        List<byte[]> this$secondaries = this.getSecondaries();
        List<byte[]> other$secondaries = other.getSecondaries();
        if (this$secondaries == null ? other$secondaries != null : !((Object)this$secondaries).equals(other$secondaries)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !((Object)this$requestInfo).equals(other$requestInfo)) {
            return false;
        }
        List<LockExtraData> this$lockExtraDatas = this.getLockExtraDatas();
        List<LockExtraData> other$lockExtraDatas = other.getLockExtraDatas();
        if (this$lockExtraDatas == null ? other$lockExtraDatas != null : !((Object)this$lockExtraDatas).equals(other$lockExtraDatas)) {
            return false;
        }
        Context this$context = this.getContext();
        Context other$context = other.getContext();
        if (this$context == null ? other$context != null : !((Object)this$context).equals(other$context)) {
            return false;
        }
        List<ForUpdateTsCheck> this$forUpdateTsChecks = this.getForUpdateTsChecks();
        List<ForUpdateTsCheck> other$forUpdateTsChecks = other.getForUpdateTsChecks();
        if (this$forUpdateTsChecks == null ? other$forUpdateTsChecks != null : !((Object)this$forUpdateTsChecks).equals(other$forUpdateTsChecks)) {
            return false;
        }
        Object this$ext$ = this.getExt$();
        Object other$ext$ = other.getExt$();
        return !(this$ext$ == null ? other$ext$ != null : !this$ext$.equals(other$ext$));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TxnPrewriteRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTryOnePc() ? 79 : 97);
        long $maxCommitTs = this.getMaxCommitTs();
        result = result * 59 + (int)($maxCommitTs >>> 32 ^ $maxCommitTs);
        long $txnSize = this.getTxnSize();
        result = result * 59 + (int)($txnSize >>> 32 ^ $txnSize);
        long $minCommitTs = this.getMinCommitTs();
        result = result * 59 + (int)($minCommitTs >>> 32 ^ $minCommitTs);
        long $lockTtl = this.getLockTtl();
        result = result * 59 + (int)($lockTtl >>> 32 ^ $lockTtl);
        long $startTs = this.getStartTs();
        result = result * 59 + (int)($startTs >>> 32 ^ $startTs);
        result = result * 59 + (this.isUseAsyncCommit() ? 79 : 97);
        List<Mutation> $mutations = this.getMutations();
        result = result * 59 + ($mutations == null ? 43 : ((Object)$mutations).hashCode());
        List<PessimisticCheck> $pessimisticChecks = this.getPessimisticChecks();
        result = result * 59 + ($pessimisticChecks == null ? 43 : ((Object)$pessimisticChecks).hashCode());
        result = result * 59 + Arrays.hashCode(this.getPrimaryLock());
        List<byte[]> $secondaries = this.getSecondaries();
        result = result * 59 + ($secondaries == null ? 43 : ((Object)$secondaries).hashCode());
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : ((Object)$requestInfo).hashCode());
        List<LockExtraData> $lockExtraDatas = this.getLockExtraDatas();
        result = result * 59 + ($lockExtraDatas == null ? 43 : ((Object)$lockExtraDatas).hashCode());
        Context $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        List<ForUpdateTsCheck> $forUpdateTsChecks = this.getForUpdateTsChecks();
        result = result * 59 + ($forUpdateTsChecks == null ? 43 : ((Object)$forUpdateTsChecks).hashCode());
        Object $ext$ = this.getExt$();
        result = result * 59 + ($ext$ == null ? 43 : $ext$.hashCode());
        return result;
    }

    public String toString() {
        return "TxnPrewriteRequest(tryOnePc=" + this.isTryOnePc() + ", mutations=" + String.valueOf(this.getMutations()) + ", pessimisticChecks=" + String.valueOf(this.getPessimisticChecks()) + ", primaryLock=" + Arrays.toString(this.getPrimaryLock()) + ", secondaries=" + String.valueOf(this.getSecondaries()) + ", maxCommitTs=" + this.getMaxCommitTs() + ", requestInfo=" + String.valueOf(this.getRequestInfo()) + ", txnSize=" + this.getTxnSize() + ", minCommitTs=" + this.getMinCommitTs() + ", lockTtl=" + this.getLockTtl() + ", startTs=" + this.getStartTs() + ", useAsyncCommit=" + this.isUseAsyncCommit() + ", lockExtraDatas=" + String.valueOf(this.getLockExtraDatas()) + ", context=" + String.valueOf(this.getContext()) + ", forUpdateTsChecks=" + String.valueOf(this.getForUpdateTsChecks()) + ", ext$=" + String.valueOf(this.getExt$()) + ")";
    }

    public TxnPrewriteRequest() {
    }

    public static abstract class TxnPrewriteRequestBuilder<C extends TxnPrewriteRequest, B extends TxnPrewriteRequestBuilder<C, B>> {
        private boolean tryOnePc;
        private List<Mutation> mutations;
        private List<PessimisticCheck> pessimisticChecks;
        private byte[] primaryLock;
        private List<byte[]> secondaries;
        private long maxCommitTs;
        private RequestInfo requestInfo;
        private long txnSize;
        private long minCommitTs;
        private long lockTtl;
        private long startTs;
        private boolean useAsyncCommit;
        private List<LockExtraData> lockExtraDatas;
        private Context context;
        private List<ForUpdateTsCheck> forUpdateTsChecks;
        private Object ext$;

        protected abstract B self();

        public abstract C build();

        public B tryOnePc(boolean tryOnePc) {
            this.tryOnePc = tryOnePc;
            return this.self();
        }

        public B mutations(List<Mutation> mutations) {
            this.mutations = mutations;
            return this.self();
        }

        public B pessimisticChecks(List<PessimisticCheck> pessimisticChecks) {
            this.pessimisticChecks = pessimisticChecks;
            return this.self();
        }

        public B primaryLock(byte[] primaryLock) {
            this.primaryLock = primaryLock;
            return this.self();
        }

        public B secondaries(List<byte[]> secondaries) {
            this.secondaries = secondaries;
            return this.self();
        }

        public B maxCommitTs(long maxCommitTs) {
            this.maxCommitTs = maxCommitTs;
            return this.self();
        }

        public B requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this.self();
        }

        public B txnSize(long txnSize) {
            this.txnSize = txnSize;
            return this.self();
        }

        public B minCommitTs(long minCommitTs) {
            this.minCommitTs = minCommitTs;
            return this.self();
        }

        public B lockTtl(long lockTtl) {
            this.lockTtl = lockTtl;
            return this.self();
        }

        public B startTs(long startTs) {
            this.startTs = startTs;
            return this.self();
        }

        public B useAsyncCommit(boolean useAsyncCommit) {
            this.useAsyncCommit = useAsyncCommit;
            return this.self();
        }

        public B lockExtraDatas(List<LockExtraData> lockExtraDatas) {
            this.lockExtraDatas = lockExtraDatas;
            return this.self();
        }

        public B context(Context context) {
            this.context = context;
            return this.self();
        }

        public B forUpdateTsChecks(List<ForUpdateTsCheck> forUpdateTsChecks) {
            this.forUpdateTsChecks = forUpdateTsChecks;
            return this.self();
        }

        public B ext$(Object ext$) {
            this.ext$ = ext$;
            return this.self();
        }

        public String toString() {
            return "TxnPrewriteRequest.TxnPrewriteRequestBuilder(tryOnePc=" + this.tryOnePc + ", mutations=" + String.valueOf(this.mutations) + ", pessimisticChecks=" + String.valueOf(this.pessimisticChecks) + ", primaryLock=" + Arrays.toString(this.primaryLock) + ", secondaries=" + String.valueOf(this.secondaries) + ", maxCommitTs=" + this.maxCommitTs + ", requestInfo=" + String.valueOf(this.requestInfo) + ", txnSize=" + this.txnSize + ", minCommitTs=" + this.minCommitTs + ", lockTtl=" + this.lockTtl + ", startTs=" + this.startTs + ", useAsyncCommit=" + this.useAsyncCommit + ", lockExtraDatas=" + String.valueOf(this.lockExtraDatas) + ", context=" + String.valueOf(this.context) + ", forUpdateTsChecks=" + String.valueOf(this.forUpdateTsChecks) + ", ext$=" + String.valueOf(this.ext$) + ")";
        }
    }

    private static final class TxnPrewriteRequestBuilderImpl
    extends TxnPrewriteRequestBuilder<TxnPrewriteRequest, TxnPrewriteRequestBuilderImpl> {
        private TxnPrewriteRequestBuilderImpl() {
        }

        @Override
        protected TxnPrewriteRequestBuilderImpl self() {
            return this;
        }

        @Override
        public TxnPrewriteRequest build() {
            return new TxnPrewriteRequest(this);
        }
    }

    public static final class Fields {
        public static final String tryOnePc = "tryOnePc";
        public static final String mutations = "mutations";
        public static final String pessimisticChecks = "pessimisticChecks";
        public static final String primaryLock = "primaryLock";
        public static final String secondaries = "secondaries";
        public static final String maxCommitTs = "maxCommitTs";
        public static final String requestInfo = "requestInfo";
        public static final String txnSize = "txnSize";
        public static final String minCommitTs = "minCommitTs";
        public static final String lockTtl = "lockTtl";
        public static final String startTs = "startTs";
        public static final String useAsyncCommit = "useAsyncCommit";
        public static final String lockExtraDatas = "lockExtraDatas";
        public static final String context = "context";
        public static final String forUpdateTsChecks = "forUpdateTsChecks";
        public static final String ext$ = "ext$";
    }
}

