/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service.entity.raft;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import java.util.Arrays;

public class LogEntry
implements Message {
    private byte[] data;
    private long term;
    private long index;
    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write((Integer)1, this.index, out);
        Writer.write((Integer)2, this.term, out);
        Writer.write((Integer)3, this.data, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        block5: while ((number = Reader.readNumber(input)) != 0) {
            switch (number) {
                case 1: {
                    this.index = Reader.readLong(input);
                    hasValue = true;
                    continue block5;
                }
                case 2: {
                    this.term = Reader.readLong(input);
                    hasValue = true;
                    continue block5;
                }
                case 3: {
                    this.data = Reader.readBytes(input);
                    hasValue = true;
                    continue block5;
                }
            }
            Reader.skip(input);
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf((Integer)1, this.index).intValue();
        size += SizeUtils.sizeOf((Integer)2, this.term).intValue();
        return size += SizeUtils.sizeOf((Integer)3, this.data).intValue();
    }

    protected LogEntry(LogEntryBuilder<?, ?> b) {
        this.data = b.data;
        this.term = b.term;
        this.index = b.index;
        this.ext$ = b.ext$;
    }

    public static LogEntryBuilder<?, ?> builder() {
        return new LogEntryBuilderImpl();
    }

    public byte[] getData() {
        return this.data;
    }

    public long getTerm() {
        return this.term;
    }

    public long getIndex() {
        return this.index;
    }

    @Override
    public Object getExt$() {
        return this.ext$;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setTerm(long term) {
        this.term = term;
    }

    public void setIndex(long index) {
        this.index = index;
    }

    @Override
    public void setExt$(Object ext$) {
        this.ext$ = ext$;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogEntry)) {
            return false;
        }
        LogEntry other = (LogEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTerm() != other.getTerm()) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        if (!Arrays.equals(this.getData(), other.getData())) {
            return false;
        }
        Object this$ext$ = this.getExt$();
        Object other$ext$ = other.getExt$();
        return !(this$ext$ == null ? other$ext$ != null : !this$ext$.equals(other$ext$));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LogEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $term = this.getTerm();
        result = result * 59 + (int)($term >>> 32 ^ $term);
        long $index = this.getIndex();
        result = result * 59 + (int)($index >>> 32 ^ $index);
        result = result * 59 + Arrays.hashCode(this.getData());
        Object $ext$ = this.getExt$();
        result = result * 59 + ($ext$ == null ? 43 : $ext$.hashCode());
        return result;
    }

    public String toString() {
        return "LogEntry(data=" + Arrays.toString(this.getData()) + ", term=" + this.getTerm() + ", index=" + this.getIndex() + ", ext$=" + String.valueOf(this.getExt$()) + ")";
    }

    public LogEntry() {
    }

    public static abstract class LogEntryBuilder<C extends LogEntry, B extends LogEntryBuilder<C, B>> {
        private byte[] data;
        private long term;
        private long index;
        private Object ext$;

        protected abstract B self();

        public abstract C build();

        public B data(byte[] data) {
            this.data = data;
            return this.self();
        }

        public B term(long term) {
            this.term = term;
            return this.self();
        }

        public B index(long index) {
            this.index = index;
            return this.self();
        }

        public B ext$(Object ext$) {
            this.ext$ = ext$;
            return this.self();
        }

        public String toString() {
            return "LogEntry.LogEntryBuilder(data=" + Arrays.toString(this.data) + ", term=" + this.term + ", index=" + this.index + ", ext$=" + String.valueOf(this.ext$) + ")";
        }
    }

    private static final class LogEntryBuilderImpl
    extends LogEntryBuilder<LogEntry, LogEntryBuilderImpl> {
        private LogEntryBuilderImpl() {
        }

        @Override
        protected LogEntryBuilderImpl self() {
            return this;
        }

        @Override
        public LogEntry build() {
            return new LogEntry(this);
        }
    }

    public static final class Fields {
        public static final String data = "data";
        public static final String term = "term";
        public static final String index = "index";
        public static final String ext$ = "ext$";
    }
}

