/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service.entity.meta;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.Engine;
import io.dingodb.sdk.service.entity.common.IndexParameter;
import io.dingodb.sdk.service.entity.common.SchemaState;
import io.dingodb.sdk.service.entity.common.StorageEngine;
import io.dingodb.sdk.service.entity.meta.ColumnDefinition;
import io.dingodb.sdk.service.entity.meta.PartitionRule;
import java.util.List;
import java.util.Map;

public class TableDefinition
implements Message {
    private StorageEngine storeEngine;
    private String charset;
    private String name;
    private long deleteTimestamp;
    private PartitionRule tablePartition;
    private int version;
    private Engine engine;
    private boolean visible;
    private Map<String, String> properties;
    private String tableType;
    private SchemaState schemaState;
    private long createTimestamp;
    private IndexParameter indexParameter;
    private String collate;
    private int codecVersion;
    private long ttl;
    private long revision;
    private long autoIncrement;
    private long updateTimestamp;
    private String rowFormat;
    private String createSql;
    private List<ColumnDefinition> columns;
    private String comment;
    private int replica;
    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write((Integer)1, this.name, out);
        Writer.write((Integer)2, this.version, out);
        Writer.write((Integer)3, this.ttl, out);
        Writer.write((Integer)4, this.autoIncrement, out);
        Writer.write((Integer)5, this.createSql, out);
        Writer.write((Integer)6, this.charset, out);
        Writer.write((Integer)7, this.collate, out);
        Writer.write((Integer)20, (Message)this.tablePartition, out);
        Writer.write((Integer)21, this.replica, out);
        Writer.write((Integer)22, this.engine, out);
        Writer.write((Integer)23, this.storeEngine, out);
        Writer.write((Integer)30, this.columns, (n, v) -> Writer.write(n, (Message)v, out));
        Writer.write(40, this.properties, out, (n, v) -> Writer.write(n, v, out), (n, v) -> Writer.write(n, v, out), SizeUtils::sizeOf, SizeUtils::sizeOf);
        Writer.write((Integer)41, (Message)this.indexParameter, out);
        Writer.write((Integer)51, this.createTimestamp, out);
        Writer.write((Integer)52, this.updateTimestamp, out);
        Writer.write((Integer)53, this.deleteTimestamp, out);
        Writer.write((Integer)60, this.comment, out);
        Writer.write((Integer)61, this.tableType, out);
        Writer.write((Integer)62, this.rowFormat, out);
        Writer.write((Integer)63, this.schemaState, out);
        Writer.write((Integer)64, this.visible, out);
        Writer.write((Integer)65, this.codecVersion, out);
        Writer.write((Integer)100, this.revision, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        block26: while ((number = Reader.readNumber(input)) != 0) {
            switch (number) {
                case 1: {
                    this.name = Reader.readString(input);
                    hasValue = true;
                    continue block26;
                }
                case 2: {
                    this.version = Reader.readInt(input);
                    hasValue = true;
                    continue block26;
                }
                case 3: {
                    this.ttl = Reader.readLong(input);
                    hasValue = true;
                    continue block26;
                }
                case 4: {
                    this.autoIncrement = Reader.readLong(input);
                    hasValue = true;
                    continue block26;
                }
                case 5: {
                    this.createSql = Reader.readString(input);
                    hasValue = true;
                    continue block26;
                }
                case 6: {
                    this.charset = Reader.readString(input);
                    hasValue = true;
                    continue block26;
                }
                case 7: {
                    this.collate = Reader.readString(input);
                    hasValue = true;
                    continue block26;
                }
                case 20: {
                    this.tablePartition = Reader.readMessage(new PartitionRule(), input);
                    hasValue = hasValue ? hasValue : this.tablePartition != null;
                    continue block26;
                }
                case 21: {
                    this.replica = Reader.readInt(input);
                    hasValue = true;
                    continue block26;
                }
                case 22: {
                    this.engine = Engine.forNumber(Reader.readInt(input));
                    hasValue = true;
                    continue block26;
                }
                case 23: {
                    this.storeEngine = StorageEngine.forNumber(Reader.readInt(input));
                    hasValue = true;
                    continue block26;
                }
                case 30: {
                    this.columns = Reader.readList(this.columns, input, in -> Reader.readMessage(new ColumnDefinition(), in));
                    hasValue = true;
                    continue block26;
                }
                case 40: {
                    this.properties = Reader.readMap(number, this.properties, input, Reader::readString, Reader::readString);
                    hasValue = true;
                    continue block26;
                }
                case 41: {
                    this.indexParameter = Reader.readMessage(new IndexParameter(), input);
                    hasValue = hasValue ? hasValue : this.indexParameter != null;
                    continue block26;
                }
                case 51: {
                    this.createTimestamp = Reader.readLong(input);
                    hasValue = true;
                    continue block26;
                }
                case 52: {
                    this.updateTimestamp = Reader.readLong(input);
                    hasValue = true;
                    continue block26;
                }
                case 53: {
                    this.deleteTimestamp = Reader.readLong(input);
                    hasValue = true;
                    continue block26;
                }
                case 60: {
                    this.comment = Reader.readString(input);
                    hasValue = true;
                    continue block26;
                }
                case 61: {
                    this.tableType = Reader.readString(input);
                    hasValue = true;
                    continue block26;
                }
                case 62: {
                    this.rowFormat = Reader.readString(input);
                    hasValue = true;
                    continue block26;
                }
                case 63: {
                    this.schemaState = SchemaState.forNumber(Reader.readInt(input));
                    hasValue = true;
                    continue block26;
                }
                case 64: {
                    this.visible = Reader.readBoolean(input);
                    hasValue = true;
                    continue block26;
                }
                case 65: {
                    this.codecVersion = Reader.readInt(input);
                    hasValue = true;
                    continue block26;
                }
                case 100: {
                    this.revision = Reader.readLong(input);
                    hasValue = true;
                    continue block26;
                }
            }
            Reader.skip(input);
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf((Integer)1, this.name).intValue();
        size += SizeUtils.sizeOf((Integer)2, this.version).intValue();
        size += SizeUtils.sizeOf((Integer)3, this.ttl).intValue();
        size += SizeUtils.sizeOf((Integer)4, this.autoIncrement).intValue();
        size += SizeUtils.sizeOf((Integer)5, this.createSql).intValue();
        size += SizeUtils.sizeOf((Integer)6, this.charset).intValue();
        size += SizeUtils.sizeOf((Integer)7, this.collate).intValue();
        size += SizeUtils.sizeOf((Integer)20, (Message)this.tablePartition).intValue();
        size += SizeUtils.sizeOf((Integer)21, this.replica).intValue();
        size += SizeUtils.sizeOf((Integer)22, this.engine).intValue();
        size += SizeUtils.sizeOf((Integer)23, this.storeEngine).intValue();
        size += SizeUtils.sizeOf(30, this.columns, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(40, this.properties, SizeUtils::sizeOf, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf((Integer)41, (Message)this.indexParameter).intValue();
        size += SizeUtils.sizeOf((Integer)51, this.createTimestamp).intValue();
        size += SizeUtils.sizeOf((Integer)52, this.updateTimestamp).intValue();
        size += SizeUtils.sizeOf((Integer)53, this.deleteTimestamp).intValue();
        size += SizeUtils.sizeOf((Integer)60, this.comment).intValue();
        size += SizeUtils.sizeOf((Integer)61, this.tableType).intValue();
        size += SizeUtils.sizeOf((Integer)62, this.rowFormat).intValue();
        size += SizeUtils.sizeOf((Integer)63, this.schemaState).intValue();
        size += SizeUtils.sizeOf((Integer)64, this.visible).intValue();
        size += SizeUtils.sizeOf((Integer)65, this.codecVersion).intValue();
        return size += SizeUtils.sizeOf((Integer)100, this.revision).intValue();
    }

    protected TableDefinition(TableDefinitionBuilder<?, ?> b) {
        this.storeEngine = b.storeEngine;
        this.charset = b.charset;
        this.name = b.name;
        this.deleteTimestamp = b.deleteTimestamp;
        this.tablePartition = b.tablePartition;
        this.version = b.version;
        this.engine = b.engine;
        this.visible = b.visible;
        this.properties = b.properties;
        this.tableType = b.tableType;
        this.schemaState = b.schemaState;
        this.createTimestamp = b.createTimestamp;
        this.indexParameter = b.indexParameter;
        this.collate = b.collate;
        this.codecVersion = b.codecVersion;
        this.ttl = b.ttl;
        this.revision = b.revision;
        this.autoIncrement = b.autoIncrement;
        this.updateTimestamp = b.updateTimestamp;
        this.rowFormat = b.rowFormat;
        this.createSql = b.createSql;
        this.columns = b.columns;
        this.comment = b.comment;
        this.replica = b.replica;
        this.ext$ = b.ext$;
    }

    public static TableDefinitionBuilder<?, ?> builder() {
        return new TableDefinitionBuilderImpl();
    }

    public StorageEngine getStoreEngine() {
        return this.storeEngine;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getName() {
        return this.name;
    }

    public long getDeleteTimestamp() {
        return this.deleteTimestamp;
    }

    public PartitionRule getTablePartition() {
        return this.tablePartition;
    }

    public int getVersion() {
        return this.version;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getTableType() {
        return this.tableType;
    }

    public SchemaState getSchemaState() {
        return this.schemaState;
    }

    public long getCreateTimestamp() {
        return this.createTimestamp;
    }

    public IndexParameter getIndexParameter() {
        return this.indexParameter;
    }

    public String getCollate() {
        return this.collate;
    }

    public int getCodecVersion() {
        return this.codecVersion;
    }

    public long getTtl() {
        return this.ttl;
    }

    public long getRevision() {
        return this.revision;
    }

    public long getAutoIncrement() {
        return this.autoIncrement;
    }

    public long getUpdateTimestamp() {
        return this.updateTimestamp;
    }

    public String getRowFormat() {
        return this.rowFormat;
    }

    public String getCreateSql() {
        return this.createSql;
    }

    public List<ColumnDefinition> getColumns() {
        return this.columns;
    }

    public String getComment() {
        return this.comment;
    }

    public int getReplica() {
        return this.replica;
    }

    @Override
    public Object getExt$() {
        return this.ext$;
    }

    public void setStoreEngine(StorageEngine storeEngine) {
        this.storeEngine = storeEngine;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDeleteTimestamp(long deleteTimestamp) {
        this.deleteTimestamp = deleteTimestamp;
    }

    public void setTablePartition(PartitionRule tablePartition) {
        this.tablePartition = tablePartition;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public void setSchemaState(SchemaState schemaState) {
        this.schemaState = schemaState;
    }

    public void setCreateTimestamp(long createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    public void setIndexParameter(IndexParameter indexParameter) {
        this.indexParameter = indexParameter;
    }

    public void setCollate(String collate) {
        this.collate = collate;
    }

    public void setCodecVersion(int codecVersion) {
        this.codecVersion = codecVersion;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public void setRevision(long revision) {
        this.revision = revision;
    }

    public void setAutoIncrement(long autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public void setUpdateTimestamp(long updateTimestamp) {
        this.updateTimestamp = updateTimestamp;
    }

    public void setRowFormat(String rowFormat) {
        this.rowFormat = rowFormat;
    }

    public void setCreateSql(String createSql) {
        this.createSql = createSql;
    }

    public void setColumns(List<ColumnDefinition> columns) {
        this.columns = columns;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setReplica(int replica) {
        this.replica = replica;
    }

    @Override
    public void setExt$(Object ext$) {
        this.ext$ = ext$;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableDefinition)) {
            return false;
        }
        TableDefinition other = (TableDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDeleteTimestamp() != other.getDeleteTimestamp()) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.isVisible() != other.isVisible()) {
            return false;
        }
        if (this.getCreateTimestamp() != other.getCreateTimestamp()) {
            return false;
        }
        if (this.getCodecVersion() != other.getCodecVersion()) {
            return false;
        }
        if (this.getTtl() != other.getTtl()) {
            return false;
        }
        if (this.getRevision() != other.getRevision()) {
            return false;
        }
        if (this.getAutoIncrement() != other.getAutoIncrement()) {
            return false;
        }
        if (this.getUpdateTimestamp() != other.getUpdateTimestamp()) {
            return false;
        }
        if (this.getReplica() != other.getReplica()) {
            return false;
        }
        StorageEngine this$storeEngine = this.getStoreEngine();
        StorageEngine other$storeEngine = other.getStoreEngine();
        if (this$storeEngine == null ? other$storeEngine != null : !this$storeEngine.equals(other$storeEngine)) {
            return false;
        }
        String this$charset = this.getCharset();
        String other$charset = other.getCharset();
        if (this$charset == null ? other$charset != null : !this$charset.equals(other$charset)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        PartitionRule this$tablePartition = this.getTablePartition();
        PartitionRule other$tablePartition = other.getTablePartition();
        if (this$tablePartition == null ? other$tablePartition != null : !((Object)this$tablePartition).equals(other$tablePartition)) {
            return false;
        }
        Engine this$engine = this.getEngine();
        Engine other$engine = other.getEngine();
        if (this$engine == null ? other$engine != null : !this$engine.equals(other$engine)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        String this$tableType = this.getTableType();
        String other$tableType = other.getTableType();
        if (this$tableType == null ? other$tableType != null : !this$tableType.equals(other$tableType)) {
            return false;
        }
        SchemaState this$schemaState = this.getSchemaState();
        SchemaState other$schemaState = other.getSchemaState();
        if (this$schemaState == null ? other$schemaState != null : !this$schemaState.equals(other$schemaState)) {
            return false;
        }
        IndexParameter this$indexParameter = this.getIndexParameter();
        IndexParameter other$indexParameter = other.getIndexParameter();
        if (this$indexParameter == null ? other$indexParameter != null : !((Object)this$indexParameter).equals(other$indexParameter)) {
            return false;
        }
        String this$collate = this.getCollate();
        String other$collate = other.getCollate();
        if (this$collate == null ? other$collate != null : !this$collate.equals(other$collate)) {
            return false;
        }
        String this$rowFormat = this.getRowFormat();
        String other$rowFormat = other.getRowFormat();
        if (this$rowFormat == null ? other$rowFormat != null : !this$rowFormat.equals(other$rowFormat)) {
            return false;
        }
        String this$createSql = this.getCreateSql();
        String other$createSql = other.getCreateSql();
        if (this$createSql == null ? other$createSql != null : !this$createSql.equals(other$createSql)) {
            return false;
        }
        List<ColumnDefinition> this$columns = this.getColumns();
        List<ColumnDefinition> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        Object this$ext$ = this.getExt$();
        Object other$ext$ = other.getExt$();
        return !(this$ext$ == null ? other$ext$ != null : !this$ext$.equals(other$ext$));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $deleteTimestamp = this.getDeleteTimestamp();
        result = result * 59 + (int)($deleteTimestamp >>> 32 ^ $deleteTimestamp);
        result = result * 59 + this.getVersion();
        result = result * 59 + (this.isVisible() ? 79 : 97);
        long $createTimestamp = this.getCreateTimestamp();
        result = result * 59 + (int)($createTimestamp >>> 32 ^ $createTimestamp);
        result = result * 59 + this.getCodecVersion();
        long $ttl = this.getTtl();
        result = result * 59 + (int)($ttl >>> 32 ^ $ttl);
        long $revision = this.getRevision();
        result = result * 59 + (int)($revision >>> 32 ^ $revision);
        long $autoIncrement = this.getAutoIncrement();
        result = result * 59 + (int)($autoIncrement >>> 32 ^ $autoIncrement);
        long $updateTimestamp = this.getUpdateTimestamp();
        result = result * 59 + (int)($updateTimestamp >>> 32 ^ $updateTimestamp);
        result = result * 59 + this.getReplica();
        StorageEngine $storeEngine = this.getStoreEngine();
        result = result * 59 + ($storeEngine == null ? 43 : $storeEngine.hashCode());
        String $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : $charset.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        PartitionRule $tablePartition = this.getTablePartition();
        result = result * 59 + ($tablePartition == null ? 43 : ((Object)$tablePartition).hashCode());
        Engine $engine = this.getEngine();
        result = result * 59 + ($engine == null ? 43 : $engine.hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        String $tableType = this.getTableType();
        result = result * 59 + ($tableType == null ? 43 : $tableType.hashCode());
        SchemaState $schemaState = this.getSchemaState();
        result = result * 59 + ($schemaState == null ? 43 : $schemaState.hashCode());
        IndexParameter $indexParameter = this.getIndexParameter();
        result = result * 59 + ($indexParameter == null ? 43 : ((Object)$indexParameter).hashCode());
        String $collate = this.getCollate();
        result = result * 59 + ($collate == null ? 43 : $collate.hashCode());
        String $rowFormat = this.getRowFormat();
        result = result * 59 + ($rowFormat == null ? 43 : $rowFormat.hashCode());
        String $createSql = this.getCreateSql();
        result = result * 59 + ($createSql == null ? 43 : $createSql.hashCode());
        List<ColumnDefinition> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        Object $ext$ = this.getExt$();
        result = result * 59 + ($ext$ == null ? 43 : $ext$.hashCode());
        return result;
    }

    public String toString() {
        return "TableDefinition(storeEngine=" + String.valueOf(this.getStoreEngine()) + ", charset=" + this.getCharset() + ", name=" + this.getName() + ", deleteTimestamp=" + this.getDeleteTimestamp() + ", tablePartition=" + String.valueOf(this.getTablePartition()) + ", version=" + this.getVersion() + ", engine=" + String.valueOf(this.getEngine()) + ", visible=" + this.isVisible() + ", properties=" + String.valueOf(this.getProperties()) + ", tableType=" + this.getTableType() + ", schemaState=" + String.valueOf(this.getSchemaState()) + ", createTimestamp=" + this.getCreateTimestamp() + ", indexParameter=" + String.valueOf(this.getIndexParameter()) + ", collate=" + this.getCollate() + ", codecVersion=" + this.getCodecVersion() + ", ttl=" + this.getTtl() + ", revision=" + this.getRevision() + ", autoIncrement=" + this.getAutoIncrement() + ", updateTimestamp=" + this.getUpdateTimestamp() + ", rowFormat=" + this.getRowFormat() + ", createSql=" + this.getCreateSql() + ", columns=" + String.valueOf(this.getColumns()) + ", comment=" + this.getComment() + ", replica=" + this.getReplica() + ", ext$=" + String.valueOf(this.getExt$()) + ")";
    }

    public TableDefinition() {
    }

    public static abstract class TableDefinitionBuilder<C extends TableDefinition, B extends TableDefinitionBuilder<C, B>> {
        private StorageEngine storeEngine;
        private String charset;
        private String name;
        private long deleteTimestamp;
        private PartitionRule tablePartition;
        private int version;
        private Engine engine;
        private boolean visible;
        private Map<String, String> properties;
        private String tableType;
        private SchemaState schemaState;
        private long createTimestamp;
        private IndexParameter indexParameter;
        private String collate;
        private int codecVersion;
        private long ttl;
        private long revision;
        private long autoIncrement;
        private long updateTimestamp;
        private String rowFormat;
        private String createSql;
        private List<ColumnDefinition> columns;
        private String comment;
        private int replica;
        private Object ext$;

        protected abstract B self();

        public abstract C build();

        public B storeEngine(StorageEngine storeEngine) {
            this.storeEngine = storeEngine;
            return this.self();
        }

        public B charset(String charset) {
            this.charset = charset;
            return this.self();
        }

        public B name(String name) {
            this.name = name;
            return this.self();
        }

        public B deleteTimestamp(long deleteTimestamp) {
            this.deleteTimestamp = deleteTimestamp;
            return this.self();
        }

        public B tablePartition(PartitionRule tablePartition) {
            this.tablePartition = tablePartition;
            return this.self();
        }

        public B version(int version) {
            this.version = version;
            return this.self();
        }

        public B engine(Engine engine) {
            this.engine = engine;
            return this.self();
        }

        public B visible(boolean visible) {
            this.visible = visible;
            return this.self();
        }

        public B properties(Map<String, String> properties) {
            this.properties = properties;
            return this.self();
        }

        public B tableType(String tableType) {
            this.tableType = tableType;
            return this.self();
        }

        public B schemaState(SchemaState schemaState) {
            this.schemaState = schemaState;
            return this.self();
        }

        public B createTimestamp(long createTimestamp) {
            this.createTimestamp = createTimestamp;
            return this.self();
        }

        public B indexParameter(IndexParameter indexParameter) {
            this.indexParameter = indexParameter;
            return this.self();
        }

        public B collate(String collate) {
            this.collate = collate;
            return this.self();
        }

        public B codecVersion(int codecVersion) {
            this.codecVersion = codecVersion;
            return this.self();
        }

        public B ttl(long ttl) {
            this.ttl = ttl;
            return this.self();
        }

        public B revision(long revision) {
            this.revision = revision;
            return this.self();
        }

        public B autoIncrement(long autoIncrement) {
            this.autoIncrement = autoIncrement;
            return this.self();
        }

        public B updateTimestamp(long updateTimestamp) {
            this.updateTimestamp = updateTimestamp;
            return this.self();
        }

        public B rowFormat(String rowFormat) {
            this.rowFormat = rowFormat;
            return this.self();
        }

        public B createSql(String createSql) {
            this.createSql = createSql;
            return this.self();
        }

        public B columns(List<ColumnDefinition> columns) {
            this.columns = columns;
            return this.self();
        }

        public B comment(String comment) {
            this.comment = comment;
            return this.self();
        }

        public B replica(int replica) {
            this.replica = replica;
            return this.self();
        }

        public B ext$(Object ext$) {
            this.ext$ = ext$;
            return this.self();
        }

        public String toString() {
            return "TableDefinition.TableDefinitionBuilder(storeEngine=" + String.valueOf(this.storeEngine) + ", charset=" + this.charset + ", name=" + this.name + ", deleteTimestamp=" + this.deleteTimestamp + ", tablePartition=" + String.valueOf(this.tablePartition) + ", version=" + this.version + ", engine=" + String.valueOf(this.engine) + ", visible=" + this.visible + ", properties=" + String.valueOf(this.properties) + ", tableType=" + this.tableType + ", schemaState=" + String.valueOf(this.schemaState) + ", createTimestamp=" + this.createTimestamp + ", indexParameter=" + String.valueOf(this.indexParameter) + ", collate=" + this.collate + ", codecVersion=" + this.codecVersion + ", ttl=" + this.ttl + ", revision=" + this.revision + ", autoIncrement=" + this.autoIncrement + ", updateTimestamp=" + this.updateTimestamp + ", rowFormat=" + this.rowFormat + ", createSql=" + this.createSql + ", columns=" + String.valueOf(this.columns) + ", comment=" + this.comment + ", replica=" + this.replica + ", ext$=" + String.valueOf(this.ext$) + ")";
        }
    }

    private static final class TableDefinitionBuilderImpl
    extends TableDefinitionBuilder<TableDefinition, TableDefinitionBuilderImpl> {
        private TableDefinitionBuilderImpl() {
        }

        @Override
        protected TableDefinitionBuilderImpl self() {
            return this;
        }

        @Override
        public TableDefinition build() {
            return new TableDefinition(this);
        }
    }

    public static final class Fields {
        public static final String storeEngine = "storeEngine";
        public static final String charset = "charset";
        public static final String name = "name";
        public static final String deleteTimestamp = "deleteTimestamp";
        public static final String tablePartition = "tablePartition";
        public static final String version = "version";
        public static final String engine = "engine";
        public static final String visible = "visible";
        public static final String properties = "properties";
        public static final String tableType = "tableType";
        public static final String schemaState = "schemaState";
        public static final String createTimestamp = "createTimestamp";
        public static final String indexParameter = "indexParameter";
        public static final String collate = "collate";
        public static final String codecVersion = "codecVersion";
        public static final String ttl = "ttl";
        public static final String revision = "revision";
        public static final String autoIncrement = "autoIncrement";
        public static final String updateTimestamp = "updateTimestamp";
        public static final String rowFormat = "rowFormat";
        public static final String createSql = "createSql";
        public static final String columns = "columns";
        public static final String comment = "comment";
        public static final String replica = "replica";
        public static final String ext$ = "ext$";
    }
}

