/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service.entity.meta;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.Location;
import io.dingodb.sdk.service.entity.common.Range;
import io.dingodb.sdk.service.entity.common.RegionEpoch;
import io.dingodb.sdk.service.entity.meta.DingoCommonId;
import io.dingodb.sdk.service.entity.meta.RegionStatus;
import java.util.List;

public class RangeDistribution
implements Message {
    private List<Location> voters;
    private long storemapEpoch;
    private DingoCommonId id;
    private RegionEpoch regionEpoch;
    private long regionmapEpoch;
    private RegionStatus status;
    private List<Location> learners;
    private Range range;
    private Location leader;
    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write((Integer)1, (Message)this.id, out);
        Writer.write((Integer)2, (Message)this.range, out);
        Writer.write((Integer)3, (Message)this.leader, out);
        Writer.write((Integer)4, this.voters, (n, v) -> Writer.write(n, (Message)v, out));
        Writer.write((Integer)5, this.learners, (n, v) -> Writer.write(n, (Message)v, out));
        Writer.write((Integer)6, this.regionmapEpoch, out);
        Writer.write((Integer)7, this.storemapEpoch, out);
        Writer.write((Integer)8, (Message)this.regionEpoch, out);
        Writer.write((Integer)9, (Message)this.status, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        block11: while ((number = Reader.readNumber(input)) != 0) {
            switch (number) {
                case 1: {
                    this.id = Reader.readMessage(new DingoCommonId(), input);
                    hasValue = hasValue ? hasValue : this.id != null;
                    continue block11;
                }
                case 2: {
                    this.range = Reader.readMessage(new Range(), input);
                    hasValue = hasValue ? hasValue : this.range != null;
                    continue block11;
                }
                case 3: {
                    this.leader = Reader.readMessage(new Location(), input);
                    hasValue = hasValue ? hasValue : this.leader != null;
                    continue block11;
                }
                case 4: {
                    this.voters = Reader.readList(this.voters, input, in -> Reader.readMessage(new Location(), in));
                    hasValue = true;
                    continue block11;
                }
                case 5: {
                    this.learners = Reader.readList(this.learners, input, in -> Reader.readMessage(new Location(), in));
                    hasValue = true;
                    continue block11;
                }
                case 6: {
                    this.regionmapEpoch = Reader.readLong(input);
                    hasValue = true;
                    continue block11;
                }
                case 7: {
                    this.storemapEpoch = Reader.readLong(input);
                    hasValue = true;
                    continue block11;
                }
                case 8: {
                    this.regionEpoch = Reader.readMessage(new RegionEpoch(), input);
                    hasValue = hasValue ? hasValue : this.regionEpoch != null;
                    continue block11;
                }
                case 9: {
                    this.status = Reader.readMessage(new RegionStatus(), input);
                    hasValue = hasValue ? hasValue : this.status != null;
                    continue block11;
                }
            }
            Reader.skip(input);
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf((Integer)1, (Message)this.id).intValue();
        size += SizeUtils.sizeOf((Integer)2, (Message)this.range).intValue();
        size += SizeUtils.sizeOf((Integer)3, (Message)this.leader).intValue();
        size += SizeUtils.sizeOf(4, this.voters, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf(5, this.learners, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf((Integer)6, this.regionmapEpoch).intValue();
        size += SizeUtils.sizeOf((Integer)7, this.storemapEpoch).intValue();
        size += SizeUtils.sizeOf((Integer)8, (Message)this.regionEpoch).intValue();
        return size += SizeUtils.sizeOf((Integer)9, (Message)this.status).intValue();
    }

    protected RangeDistribution(RangeDistributionBuilder<?, ?> b) {
        this.voters = b.voters;
        this.storemapEpoch = b.storemapEpoch;
        this.id = b.id;
        this.regionEpoch = b.regionEpoch;
        this.regionmapEpoch = b.regionmapEpoch;
        this.status = b.status;
        this.learners = b.learners;
        this.range = b.range;
        this.leader = b.leader;
        this.ext$ = b.ext$;
    }

    public static RangeDistributionBuilder<?, ?> builder() {
        return new RangeDistributionBuilderImpl();
    }

    public List<Location> getVoters() {
        return this.voters;
    }

    public long getStoremapEpoch() {
        return this.storemapEpoch;
    }

    public DingoCommonId getId() {
        return this.id;
    }

    public RegionEpoch getRegionEpoch() {
        return this.regionEpoch;
    }

    public long getRegionmapEpoch() {
        return this.regionmapEpoch;
    }

    public RegionStatus getStatus() {
        return this.status;
    }

    public List<Location> getLearners() {
        return this.learners;
    }

    public Range getRange() {
        return this.range;
    }

    public Location getLeader() {
        return this.leader;
    }

    @Override
    public Object getExt$() {
        return this.ext$;
    }

    public void setVoters(List<Location> voters) {
        this.voters = voters;
    }

    public void setStoremapEpoch(long storemapEpoch) {
        this.storemapEpoch = storemapEpoch;
    }

    public void setId(DingoCommonId id) {
        this.id = id;
    }

    public void setRegionEpoch(RegionEpoch regionEpoch) {
        this.regionEpoch = regionEpoch;
    }

    public void setRegionmapEpoch(long regionmapEpoch) {
        this.regionmapEpoch = regionmapEpoch;
    }

    public void setStatus(RegionStatus status) {
        this.status = status;
    }

    public void setLearners(List<Location> learners) {
        this.learners = learners;
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public void setLeader(Location leader) {
        this.leader = leader;
    }

    @Override
    public void setExt$(Object ext$) {
        this.ext$ = ext$;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RangeDistribution)) {
            return false;
        }
        RangeDistribution other = (RangeDistribution)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStoremapEpoch() != other.getStoremapEpoch()) {
            return false;
        }
        if (this.getRegionmapEpoch() != other.getRegionmapEpoch()) {
            return false;
        }
        List<Location> this$voters = this.getVoters();
        List<Location> other$voters = other.getVoters();
        if (this$voters == null ? other$voters != null : !((Object)this$voters).equals(other$voters)) {
            return false;
        }
        DingoCommonId this$id = this.getId();
        DingoCommonId other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        RegionEpoch this$regionEpoch = this.getRegionEpoch();
        RegionEpoch other$regionEpoch = other.getRegionEpoch();
        if (this$regionEpoch == null ? other$regionEpoch != null : !((Object)this$regionEpoch).equals(other$regionEpoch)) {
            return false;
        }
        RegionStatus this$status = this.getStatus();
        RegionStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        List<Location> this$learners = this.getLearners();
        List<Location> other$learners = other.getLearners();
        if (this$learners == null ? other$learners != null : !((Object)this$learners).equals(other$learners)) {
            return false;
        }
        Range this$range = this.getRange();
        Range other$range = other.getRange();
        if (this$range == null ? other$range != null : !((Object)this$range).equals(other$range)) {
            return false;
        }
        Location this$leader = this.getLeader();
        Location other$leader = other.getLeader();
        if (this$leader == null ? other$leader != null : !((Object)this$leader).equals(other$leader)) {
            return false;
        }
        Object this$ext$ = this.getExt$();
        Object other$ext$ = other.getExt$();
        return !(this$ext$ == null ? other$ext$ != null : !this$ext$.equals(other$ext$));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RangeDistribution;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $storemapEpoch = this.getStoremapEpoch();
        result = result * 59 + (int)($storemapEpoch >>> 32 ^ $storemapEpoch);
        long $regionmapEpoch = this.getRegionmapEpoch();
        result = result * 59 + (int)($regionmapEpoch >>> 32 ^ $regionmapEpoch);
        List<Location> $voters = this.getVoters();
        result = result * 59 + ($voters == null ? 43 : ((Object)$voters).hashCode());
        DingoCommonId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        RegionEpoch $regionEpoch = this.getRegionEpoch();
        result = result * 59 + ($regionEpoch == null ? 43 : ((Object)$regionEpoch).hashCode());
        RegionStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        List<Location> $learners = this.getLearners();
        result = result * 59 + ($learners == null ? 43 : ((Object)$learners).hashCode());
        Range $range = this.getRange();
        result = result * 59 + ($range == null ? 43 : ((Object)$range).hashCode());
        Location $leader = this.getLeader();
        result = result * 59 + ($leader == null ? 43 : ((Object)$leader).hashCode());
        Object $ext$ = this.getExt$();
        result = result * 59 + ($ext$ == null ? 43 : $ext$.hashCode());
        return result;
    }

    public String toString() {
        return "RangeDistribution(voters=" + String.valueOf(this.getVoters()) + ", storemapEpoch=" + this.getStoremapEpoch() + ", id=" + String.valueOf(this.getId()) + ", regionEpoch=" + String.valueOf(this.getRegionEpoch()) + ", regionmapEpoch=" + this.getRegionmapEpoch() + ", status=" + String.valueOf(this.getStatus()) + ", learners=" + String.valueOf(this.getLearners()) + ", range=" + String.valueOf(this.getRange()) + ", leader=" + String.valueOf(this.getLeader()) + ", ext$=" + String.valueOf(this.getExt$()) + ")";
    }

    public RangeDistribution() {
    }

    public static abstract class RangeDistributionBuilder<C extends RangeDistribution, B extends RangeDistributionBuilder<C, B>> {
        private List<Location> voters;
        private long storemapEpoch;
        private DingoCommonId id;
        private RegionEpoch regionEpoch;
        private long regionmapEpoch;
        private RegionStatus status;
        private List<Location> learners;
        private Range range;
        private Location leader;
        private Object ext$;

        protected abstract B self();

        public abstract C build();

        public B voters(List<Location> voters) {
            this.voters = voters;
            return this.self();
        }

        public B storemapEpoch(long storemapEpoch) {
            this.storemapEpoch = storemapEpoch;
            return this.self();
        }

        public B id(DingoCommonId id) {
            this.id = id;
            return this.self();
        }

        public B regionEpoch(RegionEpoch regionEpoch) {
            this.regionEpoch = regionEpoch;
            return this.self();
        }

        public B regionmapEpoch(long regionmapEpoch) {
            this.regionmapEpoch = regionmapEpoch;
            return this.self();
        }

        public B status(RegionStatus status) {
            this.status = status;
            return this.self();
        }

        public B learners(List<Location> learners) {
            this.learners = learners;
            return this.self();
        }

        public B range(Range range) {
            this.range = range;
            return this.self();
        }

        public B leader(Location leader) {
            this.leader = leader;
            return this.self();
        }

        public B ext$(Object ext$) {
            this.ext$ = ext$;
            return this.self();
        }

        public String toString() {
            return "RangeDistribution.RangeDistributionBuilder(voters=" + String.valueOf(this.voters) + ", storemapEpoch=" + this.storemapEpoch + ", id=" + String.valueOf(this.id) + ", regionEpoch=" + String.valueOf(this.regionEpoch) + ", regionmapEpoch=" + this.regionmapEpoch + ", status=" + String.valueOf(this.status) + ", learners=" + String.valueOf(this.learners) + ", range=" + String.valueOf(this.range) + ", leader=" + String.valueOf(this.leader) + ", ext$=" + String.valueOf(this.ext$) + ")";
        }
    }

    private static final class RangeDistributionBuilderImpl
    extends RangeDistributionBuilder<RangeDistribution, RangeDistributionBuilderImpl> {
        private RangeDistributionBuilderImpl() {
        }

        @Override
        protected RangeDistributionBuilderImpl self() {
            return this;
        }

        @Override
        public RangeDistribution build() {
            return new RangeDistribution(this);
        }
    }

    public static final class Fields {
        public static final String voters = "voters";
        public static final String storemapEpoch = "storemapEpoch";
        public static final String id = "id";
        public static final String regionEpoch = "regionEpoch";
        public static final String regionmapEpoch = "regionmapEpoch";
        public static final String status = "status";
        public static final String learners = "learners";
        public static final String range = "range";
        public static final String leader = "leader";
        public static final String ext$ = "ext$";
    }
}

