/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service.entity.meta;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.meta.Partition;
import io.dingodb.sdk.service.entity.meta.PartitionStrategy;
import java.util.List;

public class PartitionRule
implements Message {
    private PartitionStrategy strategy;
    private List<String> columns;
    private List<Partition> partitions;
    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write((Integer)1, this.columns, (n, v) -> Writer.write(n, v, out));
        Writer.write((Integer)2, this.strategy, out);
        Writer.write((Integer)10, this.partitions, (n, v) -> Writer.write(n, (Message)v, out));
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        block5: while ((number = Reader.readNumber(input)) != 0) {
            switch (number) {
                case 1: {
                    this.columns = Reader.readList(this.columns, input, Reader::readString);
                    hasValue = true;
                    continue block5;
                }
                case 2: {
                    this.strategy = PartitionStrategy.forNumber(Reader.readInt(input));
                    hasValue = true;
                    continue block5;
                }
                case 10: {
                    this.partitions = Reader.readList(this.partitions, input, in -> Reader.readMessage(new Partition(), in));
                    hasValue = true;
                    continue block5;
                }
            }
            Reader.skip(input);
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf(1, this.columns, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf((Integer)2, this.strategy).intValue();
        return size += SizeUtils.sizeOf(10, this.partitions, SizeUtils::sizeOf);
    }

    protected PartitionRule(PartitionRuleBuilder<?, ?> b) {
        this.strategy = b.strategy;
        this.columns = b.columns;
        this.partitions = b.partitions;
        this.ext$ = b.ext$;
    }

    public static PartitionRuleBuilder<?, ?> builder() {
        return new PartitionRuleBuilderImpl();
    }

    public PartitionStrategy getStrategy() {
        return this.strategy;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public List<Partition> getPartitions() {
        return this.partitions;
    }

    @Override
    public Object getExt$() {
        return this.ext$;
    }

    public void setStrategy(PartitionStrategy strategy) {
        this.strategy = strategy;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public void setPartitions(List<Partition> partitions) {
        this.partitions = partitions;
    }

    @Override
    public void setExt$(Object ext$) {
        this.ext$ = ext$;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PartitionRule)) {
            return false;
        }
        PartitionRule other = (PartitionRule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PartitionStrategy this$strategy = this.getStrategy();
        PartitionStrategy other$strategy = other.getStrategy();
        if (this$strategy == null ? other$strategy != null : !this$strategy.equals(other$strategy)) {
            return false;
        }
        List<String> this$columns = this.getColumns();
        List<String> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        List<Partition> this$partitions = this.getPartitions();
        List<Partition> other$partitions = other.getPartitions();
        if (this$partitions == null ? other$partitions != null : !((Object)this$partitions).equals(other$partitions)) {
            return false;
        }
        Object this$ext$ = this.getExt$();
        Object other$ext$ = other.getExt$();
        return !(this$ext$ == null ? other$ext$ != null : !this$ext$.equals(other$ext$));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PartitionRule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PartitionStrategy $strategy = this.getStrategy();
        result = result * 59 + ($strategy == null ? 43 : $strategy.hashCode());
        List<String> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        List<Partition> $partitions = this.getPartitions();
        result = result * 59 + ($partitions == null ? 43 : ((Object)$partitions).hashCode());
        Object $ext$ = this.getExt$();
        result = result * 59 + ($ext$ == null ? 43 : $ext$.hashCode());
        return result;
    }

    public String toString() {
        return "PartitionRule(strategy=" + String.valueOf(this.getStrategy()) + ", columns=" + String.valueOf(this.getColumns()) + ", partitions=" + String.valueOf(this.getPartitions()) + ", ext$=" + String.valueOf(this.getExt$()) + ")";
    }

    public PartitionRule() {
    }

    public static abstract class PartitionRuleBuilder<C extends PartitionRule, B extends PartitionRuleBuilder<C, B>> {
        private PartitionStrategy strategy;
        private List<String> columns;
        private List<Partition> partitions;
        private Object ext$;

        protected abstract B self();

        public abstract C build();

        public B strategy(PartitionStrategy strategy) {
            this.strategy = strategy;
            return this.self();
        }

        public B columns(List<String> columns) {
            this.columns = columns;
            return this.self();
        }

        public B partitions(List<Partition> partitions) {
            this.partitions = partitions;
            return this.self();
        }

        public B ext$(Object ext$) {
            this.ext$ = ext$;
            return this.self();
        }

        public String toString() {
            return "PartitionRule.PartitionRuleBuilder(strategy=" + String.valueOf(this.strategy) + ", columns=" + String.valueOf(this.columns) + ", partitions=" + String.valueOf(this.partitions) + ", ext$=" + String.valueOf(this.ext$) + ")";
        }
    }

    private static final class PartitionRuleBuilderImpl
    extends PartitionRuleBuilder<PartitionRule, PartitionRuleBuilderImpl> {
        private PartitionRuleBuilderImpl() {
        }

        @Override
        protected PartitionRuleBuilderImpl self() {
            return this;
        }

        @Override
        public PartitionRule build() {
            return new PartitionRule(this);
        }
    }

    public static final class Fields {
        public static final String strategy = "strategy";
        public static final String columns = "columns";
        public static final String partitions = "partitions";
        public static final String ext$ = "ext$";
    }
}

