/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service.entity.meta;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.VectorIndexType;
import java.util.Arrays;

public class IndexMetrics
implements Message {
    private long deletedCount;
    private long minId;
    private long currentCount;
    private long maxId;
    private byte[] maxKey;
    private byte[] minKey;
    private VectorIndexType vectorIndexType;
    private long rowsCount;
    private long partCount;
    private long memoryBytes;
    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write((Integer)1, this.rowsCount, out);
        Writer.write((Integer)2, this.minKey, out);
        Writer.write((Integer)3, this.maxKey, out);
        Writer.write((Integer)4, this.partCount, out);
        Writer.write((Integer)20, this.vectorIndexType, out);
        Writer.write((Integer)21, this.currentCount, out);
        Writer.write((Integer)22, this.deletedCount, out);
        Writer.write((Integer)23, this.maxId, out);
        Writer.write((Integer)24, this.minId, out);
        Writer.write((Integer)25, this.memoryBytes, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        block12: while ((number = Reader.readNumber(input)) != 0) {
            switch (number) {
                case 1: {
                    this.rowsCount = Reader.readLong(input);
                    hasValue = true;
                    continue block12;
                }
                case 2: {
                    this.minKey = Reader.readBytes(input);
                    hasValue = true;
                    continue block12;
                }
                case 3: {
                    this.maxKey = Reader.readBytes(input);
                    hasValue = true;
                    continue block12;
                }
                case 4: {
                    this.partCount = Reader.readLong(input);
                    hasValue = true;
                    continue block12;
                }
                case 20: {
                    this.vectorIndexType = VectorIndexType.forNumber(Reader.readInt(input));
                    hasValue = true;
                    continue block12;
                }
                case 21: {
                    this.currentCount = Reader.readLong(input);
                    hasValue = true;
                    continue block12;
                }
                case 22: {
                    this.deletedCount = Reader.readLong(input);
                    hasValue = true;
                    continue block12;
                }
                case 23: {
                    this.maxId = Reader.readLong(input);
                    hasValue = true;
                    continue block12;
                }
                case 24: {
                    this.minId = Reader.readLong(input);
                    hasValue = true;
                    continue block12;
                }
                case 25: {
                    this.memoryBytes = Reader.readLong(input);
                    hasValue = true;
                    continue block12;
                }
            }
            Reader.skip(input);
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf((Integer)1, this.rowsCount).intValue();
        size += SizeUtils.sizeOf((Integer)2, this.minKey).intValue();
        size += SizeUtils.sizeOf((Integer)3, this.maxKey).intValue();
        size += SizeUtils.sizeOf((Integer)4, this.partCount).intValue();
        size += SizeUtils.sizeOf((Integer)20, this.vectorIndexType).intValue();
        size += SizeUtils.sizeOf((Integer)21, this.currentCount).intValue();
        size += SizeUtils.sizeOf((Integer)22, this.deletedCount).intValue();
        size += SizeUtils.sizeOf((Integer)23, this.maxId).intValue();
        size += SizeUtils.sizeOf((Integer)24, this.minId).intValue();
        return size += SizeUtils.sizeOf((Integer)25, this.memoryBytes).intValue();
    }

    protected IndexMetrics(IndexMetricsBuilder<?, ?> b) {
        this.deletedCount = b.deletedCount;
        this.minId = b.minId;
        this.currentCount = b.currentCount;
        this.maxId = b.maxId;
        this.maxKey = b.maxKey;
        this.minKey = b.minKey;
        this.vectorIndexType = b.vectorIndexType;
        this.rowsCount = b.rowsCount;
        this.partCount = b.partCount;
        this.memoryBytes = b.memoryBytes;
        this.ext$ = b.ext$;
    }

    public static IndexMetricsBuilder<?, ?> builder() {
        return new IndexMetricsBuilderImpl();
    }

    public long getDeletedCount() {
        return this.deletedCount;
    }

    public long getMinId() {
        return this.minId;
    }

    public long getCurrentCount() {
        return this.currentCount;
    }

    public long getMaxId() {
        return this.maxId;
    }

    public byte[] getMaxKey() {
        return this.maxKey;
    }

    public byte[] getMinKey() {
        return this.minKey;
    }

    public VectorIndexType getVectorIndexType() {
        return this.vectorIndexType;
    }

    public long getRowsCount() {
        return this.rowsCount;
    }

    public long getPartCount() {
        return this.partCount;
    }

    public long getMemoryBytes() {
        return this.memoryBytes;
    }

    @Override
    public Object getExt$() {
        return this.ext$;
    }

    public void setDeletedCount(long deletedCount) {
        this.deletedCount = deletedCount;
    }

    public void setMinId(long minId) {
        this.minId = minId;
    }

    public void setCurrentCount(long currentCount) {
        this.currentCount = currentCount;
    }

    public void setMaxId(long maxId) {
        this.maxId = maxId;
    }

    public void setMaxKey(byte[] maxKey) {
        this.maxKey = maxKey;
    }

    public void setMinKey(byte[] minKey) {
        this.minKey = minKey;
    }

    public void setVectorIndexType(VectorIndexType vectorIndexType) {
        this.vectorIndexType = vectorIndexType;
    }

    public void setRowsCount(long rowsCount) {
        this.rowsCount = rowsCount;
    }

    public void setPartCount(long partCount) {
        this.partCount = partCount;
    }

    public void setMemoryBytes(long memoryBytes) {
        this.memoryBytes = memoryBytes;
    }

    @Override
    public void setExt$(Object ext$) {
        this.ext$ = ext$;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexMetrics)) {
            return false;
        }
        IndexMetrics other = (IndexMetrics)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDeletedCount() != other.getDeletedCount()) {
            return false;
        }
        if (this.getMinId() != other.getMinId()) {
            return false;
        }
        if (this.getCurrentCount() != other.getCurrentCount()) {
            return false;
        }
        if (this.getMaxId() != other.getMaxId()) {
            return false;
        }
        if (this.getRowsCount() != other.getRowsCount()) {
            return false;
        }
        if (this.getPartCount() != other.getPartCount()) {
            return false;
        }
        if (this.getMemoryBytes() != other.getMemoryBytes()) {
            return false;
        }
        if (!Arrays.equals(this.getMaxKey(), other.getMaxKey())) {
            return false;
        }
        if (!Arrays.equals(this.getMinKey(), other.getMinKey())) {
            return false;
        }
        VectorIndexType this$vectorIndexType = this.getVectorIndexType();
        VectorIndexType other$vectorIndexType = other.getVectorIndexType();
        if (this$vectorIndexType == null ? other$vectorIndexType != null : !this$vectorIndexType.equals(other$vectorIndexType)) {
            return false;
        }
        Object this$ext$ = this.getExt$();
        Object other$ext$ = other.getExt$();
        return !(this$ext$ == null ? other$ext$ != null : !this$ext$.equals(other$ext$));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IndexMetrics;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $deletedCount = this.getDeletedCount();
        result = result * 59 + (int)($deletedCount >>> 32 ^ $deletedCount);
        long $minId = this.getMinId();
        result = result * 59 + (int)($minId >>> 32 ^ $minId);
        long $currentCount = this.getCurrentCount();
        result = result * 59 + (int)($currentCount >>> 32 ^ $currentCount);
        long $maxId = this.getMaxId();
        result = result * 59 + (int)($maxId >>> 32 ^ $maxId);
        long $rowsCount = this.getRowsCount();
        result = result * 59 + (int)($rowsCount >>> 32 ^ $rowsCount);
        long $partCount = this.getPartCount();
        result = result * 59 + (int)($partCount >>> 32 ^ $partCount);
        long $memoryBytes = this.getMemoryBytes();
        result = result * 59 + (int)($memoryBytes >>> 32 ^ $memoryBytes);
        result = result * 59 + Arrays.hashCode(this.getMaxKey());
        result = result * 59 + Arrays.hashCode(this.getMinKey());
        VectorIndexType $vectorIndexType = this.getVectorIndexType();
        result = result * 59 + ($vectorIndexType == null ? 43 : $vectorIndexType.hashCode());
        Object $ext$ = this.getExt$();
        result = result * 59 + ($ext$ == null ? 43 : $ext$.hashCode());
        return result;
    }

    public String toString() {
        return "IndexMetrics(deletedCount=" + this.getDeletedCount() + ", minId=" + this.getMinId() + ", currentCount=" + this.getCurrentCount() + ", maxId=" + this.getMaxId() + ", maxKey=" + Arrays.toString(this.getMaxKey()) + ", minKey=" + Arrays.toString(this.getMinKey()) + ", vectorIndexType=" + String.valueOf(this.getVectorIndexType()) + ", rowsCount=" + this.getRowsCount() + ", partCount=" + this.getPartCount() + ", memoryBytes=" + this.getMemoryBytes() + ", ext$=" + String.valueOf(this.getExt$()) + ")";
    }

    public IndexMetrics() {
    }

    public static abstract class IndexMetricsBuilder<C extends IndexMetrics, B extends IndexMetricsBuilder<C, B>> {
        private long deletedCount;
        private long minId;
        private long currentCount;
        private long maxId;
        private byte[] maxKey;
        private byte[] minKey;
        private VectorIndexType vectorIndexType;
        private long rowsCount;
        private long partCount;
        private long memoryBytes;
        private Object ext$;

        protected abstract B self();

        public abstract C build();

        public B deletedCount(long deletedCount) {
            this.deletedCount = deletedCount;
            return this.self();
        }

        public B minId(long minId) {
            this.minId = minId;
            return this.self();
        }

        public B currentCount(long currentCount) {
            this.currentCount = currentCount;
            return this.self();
        }

        public B maxId(long maxId) {
            this.maxId = maxId;
            return this.self();
        }

        public B maxKey(byte[] maxKey) {
            this.maxKey = maxKey;
            return this.self();
        }

        public B minKey(byte[] minKey) {
            this.minKey = minKey;
            return this.self();
        }

        public B vectorIndexType(VectorIndexType vectorIndexType) {
            this.vectorIndexType = vectorIndexType;
            return this.self();
        }

        public B rowsCount(long rowsCount) {
            this.rowsCount = rowsCount;
            return this.self();
        }

        public B partCount(long partCount) {
            this.partCount = partCount;
            return this.self();
        }

        public B memoryBytes(long memoryBytes) {
            this.memoryBytes = memoryBytes;
            return this.self();
        }

        public B ext$(Object ext$) {
            this.ext$ = ext$;
            return this.self();
        }

        public String toString() {
            return "IndexMetrics.IndexMetricsBuilder(deletedCount=" + this.deletedCount + ", minId=" + this.minId + ", currentCount=" + this.currentCount + ", maxId=" + this.maxId + ", maxKey=" + Arrays.toString(this.maxKey) + ", minKey=" + Arrays.toString(this.minKey) + ", vectorIndexType=" + String.valueOf(this.vectorIndexType) + ", rowsCount=" + this.rowsCount + ", partCount=" + this.partCount + ", memoryBytes=" + this.memoryBytes + ", ext$=" + String.valueOf(this.ext$) + ")";
        }
    }

    private static final class IndexMetricsBuilderImpl
    extends IndexMetricsBuilder<IndexMetrics, IndexMetricsBuilderImpl> {
        private IndexMetricsBuilderImpl() {
        }

        @Override
        protected IndexMetricsBuilderImpl self() {
            return this;
        }

        @Override
        public IndexMetrics build() {
            return new IndexMetrics(this);
        }
    }

    public static final class Fields {
        public static final String deletedCount = "deletedCount";
        public static final String minId = "minId";
        public static final String currentCount = "currentCount";
        public static final String maxId = "maxId";
        public static final String maxKey = "maxKey";
        public static final String minKey = "minKey";
        public static final String vectorIndexType = "vectorIndexType";
        public static final String rowsCount = "rowsCount";
        public static final String partCount = "partCount";
        public static final String memoryBytes = "memoryBytes";
        public static final String ext$ = "ext$";
    }
}

