/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service.entity.meta;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.Engine;
import io.dingodb.sdk.service.entity.common.IndexParameter;
import io.dingodb.sdk.service.entity.meta.PartitionRule;

public class IndexDefinition
implements Message {
    private String name;
    private boolean withAutoIncrment;
    private IndexParameter indexParameter;
    private int version;
    private Engine engine;
    private long revision;
    private long autoIncrement;
    private PartitionRule indexPartition;
    private int replica;
    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write((Integer)1, this.name, out);
        Writer.write((Integer)2, this.version, out);
        Writer.write((Integer)3, (Message)this.indexPartition, out);
        Writer.write((Integer)4, this.replica, out);
        Writer.write((Integer)5, (Message)this.indexParameter, out);
        Writer.write((Integer)6, this.withAutoIncrment, out);
        Writer.write((Integer)7, this.autoIncrement, out);
        Writer.write((Integer)8, this.engine, out);
        Writer.write((Integer)20, this.revision, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        block11: while ((number = Reader.readNumber(input)) != 0) {
            switch (number) {
                case 1: {
                    this.name = Reader.readString(input);
                    hasValue = true;
                    continue block11;
                }
                case 2: {
                    this.version = Reader.readInt(input);
                    hasValue = true;
                    continue block11;
                }
                case 3: {
                    this.indexPartition = Reader.readMessage(new PartitionRule(), input);
                    hasValue = hasValue ? hasValue : this.indexPartition != null;
                    continue block11;
                }
                case 4: {
                    this.replica = Reader.readInt(input);
                    hasValue = true;
                    continue block11;
                }
                case 5: {
                    this.indexParameter = Reader.readMessage(new IndexParameter(), input);
                    hasValue = hasValue ? hasValue : this.indexParameter != null;
                    continue block11;
                }
                case 6: {
                    this.withAutoIncrment = Reader.readBoolean(input);
                    hasValue = true;
                    continue block11;
                }
                case 7: {
                    this.autoIncrement = Reader.readLong(input);
                    hasValue = true;
                    continue block11;
                }
                case 8: {
                    this.engine = Engine.forNumber(Reader.readInt(input));
                    hasValue = true;
                    continue block11;
                }
                case 20: {
                    this.revision = Reader.readLong(input);
                    hasValue = true;
                    continue block11;
                }
            }
            Reader.skip(input);
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf((Integer)1, this.name).intValue();
        size += SizeUtils.sizeOf((Integer)2, this.version).intValue();
        size += SizeUtils.sizeOf((Integer)3, (Message)this.indexPartition).intValue();
        size += SizeUtils.sizeOf((Integer)4, this.replica).intValue();
        size += SizeUtils.sizeOf((Integer)5, (Message)this.indexParameter).intValue();
        size += SizeUtils.sizeOf((Integer)6, this.withAutoIncrment).intValue();
        size += SizeUtils.sizeOf((Integer)7, this.autoIncrement).intValue();
        size += SizeUtils.sizeOf((Integer)8, this.engine).intValue();
        return size += SizeUtils.sizeOf((Integer)20, this.revision).intValue();
    }

    protected IndexDefinition(IndexDefinitionBuilder<?, ?> b) {
        this.name = b.name;
        this.withAutoIncrment = b.withAutoIncrment;
        this.indexParameter = b.indexParameter;
        this.version = b.version;
        this.engine = b.engine;
        this.revision = b.revision;
        this.autoIncrement = b.autoIncrement;
        this.indexPartition = b.indexPartition;
        this.replica = b.replica;
        this.ext$ = b.ext$;
    }

    public static IndexDefinitionBuilder<?, ?> builder() {
        return new IndexDefinitionBuilderImpl();
    }

    public String getName() {
        return this.name;
    }

    public boolean isWithAutoIncrment() {
        return this.withAutoIncrment;
    }

    public IndexParameter getIndexParameter() {
        return this.indexParameter;
    }

    public int getVersion() {
        return this.version;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public long getRevision() {
        return this.revision;
    }

    public long getAutoIncrement() {
        return this.autoIncrement;
    }

    public PartitionRule getIndexPartition() {
        return this.indexPartition;
    }

    public int getReplica() {
        return this.replica;
    }

    @Override
    public Object getExt$() {
        return this.ext$;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setWithAutoIncrment(boolean withAutoIncrment) {
        this.withAutoIncrment = withAutoIncrment;
    }

    public void setIndexParameter(IndexParameter indexParameter) {
        this.indexParameter = indexParameter;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public void setRevision(long revision) {
        this.revision = revision;
    }

    public void setAutoIncrement(long autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public void setIndexPartition(PartitionRule indexPartition) {
        this.indexPartition = indexPartition;
    }

    public void setReplica(int replica) {
        this.replica = replica;
    }

    @Override
    public void setExt$(Object ext$) {
        this.ext$ = ext$;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexDefinition)) {
            return false;
        }
        IndexDefinition other = (IndexDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isWithAutoIncrment() != other.isWithAutoIncrment()) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.getRevision() != other.getRevision()) {
            return false;
        }
        if (this.getAutoIncrement() != other.getAutoIncrement()) {
            return false;
        }
        if (this.getReplica() != other.getReplica()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        IndexParameter this$indexParameter = this.getIndexParameter();
        IndexParameter other$indexParameter = other.getIndexParameter();
        if (this$indexParameter == null ? other$indexParameter != null : !((Object)this$indexParameter).equals(other$indexParameter)) {
            return false;
        }
        Engine this$engine = this.getEngine();
        Engine other$engine = other.getEngine();
        if (this$engine == null ? other$engine != null : !this$engine.equals(other$engine)) {
            return false;
        }
        PartitionRule this$indexPartition = this.getIndexPartition();
        PartitionRule other$indexPartition = other.getIndexPartition();
        if (this$indexPartition == null ? other$indexPartition != null : !((Object)this$indexPartition).equals(other$indexPartition)) {
            return false;
        }
        Object this$ext$ = this.getExt$();
        Object other$ext$ = other.getExt$();
        return !(this$ext$ == null ? other$ext$ != null : !this$ext$.equals(other$ext$));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IndexDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isWithAutoIncrment() ? 79 : 97);
        result = result * 59 + this.getVersion();
        long $revision = this.getRevision();
        result = result * 59 + (int)($revision >>> 32 ^ $revision);
        long $autoIncrement = this.getAutoIncrement();
        result = result * 59 + (int)($autoIncrement >>> 32 ^ $autoIncrement);
        result = result * 59 + this.getReplica();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        IndexParameter $indexParameter = this.getIndexParameter();
        result = result * 59 + ($indexParameter == null ? 43 : ((Object)$indexParameter).hashCode());
        Engine $engine = this.getEngine();
        result = result * 59 + ($engine == null ? 43 : $engine.hashCode());
        PartitionRule $indexPartition = this.getIndexPartition();
        result = result * 59 + ($indexPartition == null ? 43 : ((Object)$indexPartition).hashCode());
        Object $ext$ = this.getExt$();
        result = result * 59 + ($ext$ == null ? 43 : $ext$.hashCode());
        return result;
    }

    public String toString() {
        return "IndexDefinition(name=" + this.getName() + ", withAutoIncrment=" + this.isWithAutoIncrment() + ", indexParameter=" + String.valueOf(this.getIndexParameter()) + ", version=" + this.getVersion() + ", engine=" + String.valueOf(this.getEngine()) + ", revision=" + this.getRevision() + ", autoIncrement=" + this.getAutoIncrement() + ", indexPartition=" + String.valueOf(this.getIndexPartition()) + ", replica=" + this.getReplica() + ", ext$=" + String.valueOf(this.getExt$()) + ")";
    }

    public IndexDefinition() {
    }

    public static abstract class IndexDefinitionBuilder<C extends IndexDefinition, B extends IndexDefinitionBuilder<C, B>> {
        private String name;
        private boolean withAutoIncrment;
        private IndexParameter indexParameter;
        private int version;
        private Engine engine;
        private long revision;
        private long autoIncrement;
        private PartitionRule indexPartition;
        private int replica;
        private Object ext$;

        protected abstract B self();

        public abstract C build();

        public B name(String name) {
            this.name = name;
            return this.self();
        }

        public B withAutoIncrment(boolean withAutoIncrment) {
            this.withAutoIncrment = withAutoIncrment;
            return this.self();
        }

        public B indexParameter(IndexParameter indexParameter) {
            this.indexParameter = indexParameter;
            return this.self();
        }

        public B version(int version) {
            this.version = version;
            return this.self();
        }

        public B engine(Engine engine) {
            this.engine = engine;
            return this.self();
        }

        public B revision(long revision) {
            this.revision = revision;
            return this.self();
        }

        public B autoIncrement(long autoIncrement) {
            this.autoIncrement = autoIncrement;
            return this.self();
        }

        public B indexPartition(PartitionRule indexPartition) {
            this.indexPartition = indexPartition;
            return this.self();
        }

        public B replica(int replica) {
            this.replica = replica;
            return this.self();
        }

        public B ext$(Object ext$) {
            this.ext$ = ext$;
            return this.self();
        }

        public String toString() {
            return "IndexDefinition.IndexDefinitionBuilder(name=" + this.name + ", withAutoIncrment=" + this.withAutoIncrment + ", indexParameter=" + String.valueOf(this.indexParameter) + ", version=" + this.version + ", engine=" + String.valueOf(this.engine) + ", revision=" + this.revision + ", autoIncrement=" + this.autoIncrement + ", indexPartition=" + String.valueOf(this.indexPartition) + ", replica=" + this.replica + ", ext$=" + String.valueOf(this.ext$) + ")";
        }
    }

    private static final class IndexDefinitionBuilderImpl
    extends IndexDefinitionBuilder<IndexDefinition, IndexDefinitionBuilderImpl> {
        private IndexDefinitionBuilderImpl() {
        }

        @Override
        protected IndexDefinitionBuilderImpl self() {
            return this;
        }

        @Override
        public IndexDefinition build() {
            return new IndexDefinition(this);
        }
    }

    public static final class Fields {
        public static final String name = "name";
        public static final String withAutoIncrment = "withAutoIncrment";
        public static final String indexParameter = "indexParameter";
        public static final String version = "version";
        public static final String engine = "engine";
        public static final String revision = "revision";
        public static final String autoIncrement = "autoIncrement";
        public static final String indexPartition = "indexPartition";
        public static final String replica = "replica";
        public static final String ext$ = "ext$";
    }
}

