/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service.entity.index;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import io.dingodb.sdk.service.entity.common.VectorWithId;
import io.dingodb.sdk.service.entity.store.Context;
import java.util.List;

public class VectorImportRequest
implements Message,
Message.Request,
Message.StoreRequest {
    private Context context;
    private long ttl;
    private RequestInfo requestInfo;
    private List<Long> deleteIds;
    private List<VectorWithId> vectors;
    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write((Integer)1, (Message)this.requestInfo, out);
        Writer.write((Integer)2, (Message)this.context, out);
        Writer.write((Integer)3, this.vectors, (n, v) -> Writer.write(n, (Message)v, out));
        Writer.write(4, this.deleteIds, out, Writer::write, SizeUtils::sizeOf);
        Writer.write((Integer)5, this.ttl, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        block7: while ((number = Reader.readNumber(input)) != 0) {
            switch (number) {
                case 1: {
                    this.requestInfo = Reader.readMessage(new RequestInfo(), input);
                    hasValue = hasValue ? hasValue : this.requestInfo != null;
                    continue block7;
                }
                case 2: {
                    this.context = Reader.readMessage(new Context(), input);
                    hasValue = hasValue ? hasValue : this.context != null;
                    continue block7;
                }
                case 3: {
                    this.vectors = Reader.readList(this.vectors, input, in -> Reader.readMessage(new VectorWithId(), in));
                    hasValue = true;
                    continue block7;
                }
                case 4: {
                    this.deleteIds = Reader.readPack(input, Reader::readLong);
                    hasValue = true;
                    continue block7;
                }
                case 5: {
                    this.ttl = Reader.readLong(input);
                    hasValue = true;
                    continue block7;
                }
            }
            Reader.skip(input);
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf((Integer)1, (Message)this.requestInfo).intValue();
        size += SizeUtils.sizeOf((Integer)2, (Message)this.context).intValue();
        size += SizeUtils.sizeOf(3, this.vectors, SizeUtils::sizeOf);
        size += SizeUtils.sizeOfPack(4, this.deleteIds, SizeUtils::sizeOf);
        return size += SizeUtils.sizeOf((Integer)5, this.ttl).intValue();
    }

    protected VectorImportRequest(VectorImportRequestBuilder<?, ?> b) {
        this.context = b.context;
        this.ttl = b.ttl;
        this.requestInfo = b.requestInfo;
        this.deleteIds = b.deleteIds;
        this.vectors = b.vectors;
        this.ext$ = b.ext$;
    }

    public static VectorImportRequestBuilder<?, ?> builder() {
        return new VectorImportRequestBuilderImpl();
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    public long getTtl() {
        return this.ttl;
    }

    @Override
    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public List<Long> getDeleteIds() {
        return this.deleteIds;
    }

    public List<VectorWithId> getVectors() {
        return this.vectors;
    }

    @Override
    public Object getExt$() {
        return this.ext$;
    }

    @Override
    public void setContext(Context context) {
        this.context = context;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    @Override
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    public void setDeleteIds(List<Long> deleteIds) {
        this.deleteIds = deleteIds;
    }

    public void setVectors(List<VectorWithId> vectors) {
        this.vectors = vectors;
    }

    @Override
    public void setExt$(Object ext$) {
        this.ext$ = ext$;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VectorImportRequest)) {
            return false;
        }
        VectorImportRequest other = (VectorImportRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTtl() != other.getTtl()) {
            return false;
        }
        Context this$context = this.getContext();
        Context other$context = other.getContext();
        if (this$context == null ? other$context != null : !((Object)this$context).equals(other$context)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !((Object)this$requestInfo).equals(other$requestInfo)) {
            return false;
        }
        List<Long> this$deleteIds = this.getDeleteIds();
        List<Long> other$deleteIds = other.getDeleteIds();
        if (this$deleteIds == null ? other$deleteIds != null : !((Object)this$deleteIds).equals(other$deleteIds)) {
            return false;
        }
        List<VectorWithId> this$vectors = this.getVectors();
        List<VectorWithId> other$vectors = other.getVectors();
        if (this$vectors == null ? other$vectors != null : !((Object)this$vectors).equals(other$vectors)) {
            return false;
        }
        Object this$ext$ = this.getExt$();
        Object other$ext$ = other.getExt$();
        return !(this$ext$ == null ? other$ext$ != null : !this$ext$.equals(other$ext$));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VectorImportRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $ttl = this.getTtl();
        result = result * 59 + (int)($ttl >>> 32 ^ $ttl);
        Context $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : ((Object)$requestInfo).hashCode());
        List<Long> $deleteIds = this.getDeleteIds();
        result = result * 59 + ($deleteIds == null ? 43 : ((Object)$deleteIds).hashCode());
        List<VectorWithId> $vectors = this.getVectors();
        result = result * 59 + ($vectors == null ? 43 : ((Object)$vectors).hashCode());
        Object $ext$ = this.getExt$();
        result = result * 59 + ($ext$ == null ? 43 : $ext$.hashCode());
        return result;
    }

    public String toString() {
        return "VectorImportRequest(context=" + String.valueOf(this.getContext()) + ", ttl=" + this.getTtl() + ", requestInfo=" + String.valueOf(this.getRequestInfo()) + ", deleteIds=" + String.valueOf(this.getDeleteIds()) + ", vectors=" + String.valueOf(this.getVectors()) + ", ext$=" + String.valueOf(this.getExt$()) + ")";
    }

    public VectorImportRequest() {
    }

    public static abstract class VectorImportRequestBuilder<C extends VectorImportRequest, B extends VectorImportRequestBuilder<C, B>> {
        private Context context;
        private long ttl;
        private RequestInfo requestInfo;
        private List<Long> deleteIds;
        private List<VectorWithId> vectors;
        private Object ext$;

        protected abstract B self();

        public abstract C build();

        public B context(Context context) {
            this.context = context;
            return this.self();
        }

        public B ttl(long ttl) {
            this.ttl = ttl;
            return this.self();
        }

        public B requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this.self();
        }

        public B deleteIds(List<Long> deleteIds) {
            this.deleteIds = deleteIds;
            return this.self();
        }

        public B vectors(List<VectorWithId> vectors) {
            this.vectors = vectors;
            return this.self();
        }

        public B ext$(Object ext$) {
            this.ext$ = ext$;
            return this.self();
        }

        public String toString() {
            return "VectorImportRequest.VectorImportRequestBuilder(context=" + String.valueOf(this.context) + ", ttl=" + this.ttl + ", requestInfo=" + String.valueOf(this.requestInfo) + ", deleteIds=" + String.valueOf(this.deleteIds) + ", vectors=" + String.valueOf(this.vectors) + ", ext$=" + String.valueOf(this.ext$) + ")";
        }
    }

    private static final class VectorImportRequestBuilderImpl
    extends VectorImportRequestBuilder<VectorImportRequest, VectorImportRequestBuilderImpl> {
        private VectorImportRequestBuilderImpl() {
        }

        @Override
        protected VectorImportRequestBuilderImpl self() {
            return this;
        }

        @Override
        public VectorImportRequest build() {
            return new VectorImportRequest(this);
        }
    }

    public static final class Fields {
        public static final String context = "context";
        public static final String ttl = "ttl";
        public static final String requestInfo = "requestInfo";
        public static final String deleteIds = "deleteIds";
        public static final String vectors = "vectors";
        public static final String ext$ = "ext$";
    }
}

