/*
 * Decompiled with CFR 0.152.
 */
package io.dingodb.sdk.service.entity.index;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import io.dingodb.sdk.grpc.serializer.Reader;
import io.dingodb.sdk.grpc.serializer.SizeUtils;
import io.dingodb.sdk.grpc.serializer.Writer;
import io.dingodb.sdk.service.entity.Message;
import io.dingodb.sdk.service.entity.common.RequestInfo;
import io.dingodb.sdk.service.entity.common.VectorWithId;
import io.dingodb.sdk.service.entity.store.Context;
import java.util.List;

public class VectorAddRequest
implements Message,
Message.Request,
Message.StoreRequest {
    private boolean replaceDeleted;
    private Context context;
    private long ttl;
    private boolean isUpdate;
    private RequestInfo requestInfo;
    private List<VectorWithId> vectors;
    private Object ext$;

    @Override
    public void write(CodedOutputStream out) {
        Writer.write((Integer)1, (Message)this.requestInfo, out);
        Writer.write((Integer)2, (Message)this.context, out);
        Writer.write((Integer)3, this.vectors, (n, v) -> Writer.write(n, (Message)v, out));
        Writer.write((Integer)4, this.replaceDeleted, out);
        Writer.write((Integer)5, this.isUpdate, out);
        Writer.write((Integer)6, this.ttl, out);
    }

    @Override
    public boolean read(CodedInputStream input) {
        int number = 0;
        boolean hasValue = false;
        block8: while ((number = Reader.readNumber(input)) != 0) {
            switch (number) {
                case 1: {
                    this.requestInfo = Reader.readMessage(new RequestInfo(), input);
                    hasValue = hasValue ? hasValue : this.requestInfo != null;
                    continue block8;
                }
                case 2: {
                    this.context = Reader.readMessage(new Context(), input);
                    hasValue = hasValue ? hasValue : this.context != null;
                    continue block8;
                }
                case 3: {
                    this.vectors = Reader.readList(this.vectors, input, in -> Reader.readMessage(new VectorWithId(), in));
                    hasValue = true;
                    continue block8;
                }
                case 4: {
                    this.replaceDeleted = Reader.readBoolean(input);
                    hasValue = true;
                    continue block8;
                }
                case 5: {
                    this.isUpdate = Reader.readBoolean(input);
                    hasValue = true;
                    continue block8;
                }
                case 6: {
                    this.ttl = Reader.readLong(input);
                    hasValue = true;
                    continue block8;
                }
            }
            Reader.skip(input);
        }
        return hasValue;
    }

    @Override
    public int sizeOf() {
        int size = 0;
        size += SizeUtils.sizeOf((Integer)1, (Message)this.requestInfo).intValue();
        size += SizeUtils.sizeOf((Integer)2, (Message)this.context).intValue();
        size += SizeUtils.sizeOf(3, this.vectors, SizeUtils::sizeOf);
        size += SizeUtils.sizeOf((Integer)4, this.replaceDeleted).intValue();
        size += SizeUtils.sizeOf((Integer)5, this.isUpdate).intValue();
        return size += SizeUtils.sizeOf((Integer)6, this.ttl).intValue();
    }

    protected VectorAddRequest(VectorAddRequestBuilder<?, ?> b) {
        this.replaceDeleted = b.replaceDeleted;
        this.context = b.context;
        this.ttl = b.ttl;
        this.isUpdate = b.isUpdate;
        this.requestInfo = b.requestInfo;
        this.vectors = b.vectors;
        this.ext$ = b.ext$;
    }

    public static VectorAddRequestBuilder<?, ?> builder() {
        return new VectorAddRequestBuilderImpl();
    }

    public boolean isReplaceDeleted() {
        return this.replaceDeleted;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    public long getTtl() {
        return this.ttl;
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    @Override
    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public List<VectorWithId> getVectors() {
        return this.vectors;
    }

    @Override
    public Object getExt$() {
        return this.ext$;
    }

    public void setReplaceDeleted(boolean replaceDeleted) {
        this.replaceDeleted = replaceDeleted;
    }

    @Override
    public void setContext(Context context) {
        this.context = context;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public void setUpdate(boolean isUpdate) {
        this.isUpdate = isUpdate;
    }

    @Override
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    public void setVectors(List<VectorWithId> vectors) {
        this.vectors = vectors;
    }

    @Override
    public void setExt$(Object ext$) {
        this.ext$ = ext$;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VectorAddRequest)) {
            return false;
        }
        VectorAddRequest other = (VectorAddRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isReplaceDeleted() != other.isReplaceDeleted()) {
            return false;
        }
        if (this.getTtl() != other.getTtl()) {
            return false;
        }
        if (this.isUpdate() != other.isUpdate()) {
            return false;
        }
        Context this$context = this.getContext();
        Context other$context = other.getContext();
        if (this$context == null ? other$context != null : !((Object)this$context).equals(other$context)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !((Object)this$requestInfo).equals(other$requestInfo)) {
            return false;
        }
        List<VectorWithId> this$vectors = this.getVectors();
        List<VectorWithId> other$vectors = other.getVectors();
        if (this$vectors == null ? other$vectors != null : !((Object)this$vectors).equals(other$vectors)) {
            return false;
        }
        Object this$ext$ = this.getExt$();
        Object other$ext$ = other.getExt$();
        return !(this$ext$ == null ? other$ext$ != null : !this$ext$.equals(other$ext$));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VectorAddRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isReplaceDeleted() ? 79 : 97);
        long $ttl = this.getTtl();
        result = result * 59 + (int)($ttl >>> 32 ^ $ttl);
        result = result * 59 + (this.isUpdate() ? 79 : 97);
        Context $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : ((Object)$requestInfo).hashCode());
        List<VectorWithId> $vectors = this.getVectors();
        result = result * 59 + ($vectors == null ? 43 : ((Object)$vectors).hashCode());
        Object $ext$ = this.getExt$();
        result = result * 59 + ($ext$ == null ? 43 : $ext$.hashCode());
        return result;
    }

    public String toString() {
        return "VectorAddRequest(replaceDeleted=" + this.isReplaceDeleted() + ", context=" + String.valueOf(this.getContext()) + ", ttl=" + this.getTtl() + ", isUpdate=" + this.isUpdate() + ", requestInfo=" + String.valueOf(this.getRequestInfo()) + ", vectors=" + String.valueOf(this.getVectors()) + ", ext$=" + String.valueOf(this.getExt$()) + ")";
    }

    public VectorAddRequest() {
    }

    public static abstract class VectorAddRequestBuilder<C extends VectorAddRequest, B extends VectorAddRequestBuilder<C, B>> {
        private boolean replaceDeleted;
        private Context context;
        private long ttl;
        private boolean isUpdate;
        private RequestInfo requestInfo;
        private List<VectorWithId> vectors;
        private Object ext$;

        protected abstract B self();

        public abstract C build();

        public B replaceDeleted(boolean replaceDeleted) {
            this.replaceDeleted = replaceDeleted;
            return this.self();
        }

        public B context(Context context) {
            this.context = context;
            return this.self();
        }

        public B ttl(long ttl) {
            this.ttl = ttl;
            return this.self();
        }

        public B isUpdate(boolean isUpdate) {
            this.isUpdate = isUpdate;
            return this.self();
        }

        public B requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this.self();
        }

        public B vectors(List<VectorWithId> vectors) {
            this.vectors = vectors;
            return this.self();
        }

        public B ext$(Object ext$) {
            this.ext$ = ext$;
            return this.self();
        }

        public String toString() {
            return "VectorAddRequest.VectorAddRequestBuilder(replaceDeleted=" + this.replaceDeleted + ", context=" + String.valueOf(this.context) + ", ttl=" + this.ttl + ", isUpdate=" + this.isUpdate + ", requestInfo=" + String.valueOf(this.requestInfo) + ", vectors=" + String.valueOf(this.vectors) + ", ext$=" + String.valueOf(this.ext$) + ")";
        }
    }

    private static final class VectorAddRequestBuilderImpl
    extends VectorAddRequestBuilder<VectorAddRequest, VectorAddRequestBuilderImpl> {
        private VectorAddRequestBuilderImpl() {
        }

        @Override
        protected VectorAddRequestBuilderImpl self() {
            return this;
        }

        @Override
        public VectorAddRequest build() {
            return new VectorAddRequest(this);
        }
    }

    public static final class Fields {
        public static final String replaceDeleted = "replaceDeleted";
        public static final String context = "context";
        public static final String ttl = "ttl";
        public static final String isUpdate = "isUpdate";
        public static final String requestInfo = "requestInfo";
        public static final String vectors = "vectors";
        public static final String ext$ = "ext$";
    }
}

